/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client.lights;

import dev.toma.vehiclemod.client.lights.BasicLightEntry;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.ISpecialVehicle;
import java.util.function.Function;
import net.minecraft.client.model.ModelRenderer;

public class SirenLights<V extends EntityVehicle>
extends BasicLightEntry<V> {
    private final int cycle;
    private final Function<Float, Float> outModifier;

    public SirenLights(int cycle, Function<Float, Float> outModifier, ModelRenderer ... renderers) {
        super(0.0f, renderers);
        this.cycle = cycle;
        this.outModifier = outModifier;
    }

    public SirenLights(int cycle, ModelRenderer ... renderers) {
        this(cycle, Function.identity(), renderers);
    }

    @Override
    public boolean shouldApplyLight(V vehicle) {
        if (vehicle == null || !((ISpecialVehicle)vehicle).isEffectActive()) {
            return false;
        }
        long time = System.currentTimeMillis();
        float half = (float)this.cycle / 2.0f;
        long modified = time % (long)this.cycle;
        float intensity = this.outModifier.apply(Float.valueOf(Math.abs((half - (float)modified) / half))).floatValue();
        int coords = (int)(240.0f * intensity);
        this.setLightmapX(coords);
        this.setLightmapY(coords);
        return true;
    }
}

