/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client.lights;

import dev.toma.vehiclemod.client.lights.BasicLightEntry;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.LightController;
import dev.toma.vehiclemod.init.VMSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;

public class TurnIndicatorLights<V extends EntityVehicle>
extends BasicLightEntry<V> {
    final LightController.TurnLightStatus status;
    final int cycle;
    boolean prevState;

    public TurnIndicatorLights(int cycleLength, LightController.TurnLightStatus status, ModelRenderer ... renderers) {
        super(1.0f, renderers);
        this.cycle = cycleLength;
        this.status = status;
    }

    @Override
    public boolean shouldApplyLight(V vehicle) {
        boolean flag = false;
        if (vehicle == null) {
            return false;
        }
        LightController controller = ((EntityVehicle)vehicle).lightController;
        LightController.TurnLightStatus status = controller.getTurnLightStatus();
        if (status == LightController.TurnLightStatus.WARNING || status == this.status) {
            int cycleSwap;
            long time = System.currentTimeMillis();
            boolean bl = flag = time % (long)this.cycle < (long)(cycleSwap = this.cycle / 2);
            if (this.prevState != flag && (status != LightController.TurnLightStatus.WARNING || this.status == LightController.TurnLightStatus.RIGHT)) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(flag ? VMSounds.INDICATOR_ON : VMSounds.INDICATOR_OFF, 1.0f, 1.0f);
            }
            this.prevState = flag;
        }
        return flag;
    }
}

