/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client.model.vehicle;

import dev.toma.vehiclemod.client.lights.LightEntry;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.OpenGlHelper;

public abstract class ModelVehicle<V extends EntityVehicle>
extends ModelBase {
    private final List<LightEntry<V>> lights = new ArrayList<LightEntry<V>>();

    @SafeVarargs
    public final void registerLightEntries(LightEntry<V> ... entries) {
        this.lights.addAll(Arrays.asList(entries));
    }

    public final void render(V vehicle) {
        int i = 0;
        int j = 0;
        if (vehicle != null) {
            int light = ((EntityVehicle)vehicle).field_70170_p.func_175626_b(vehicle.func_180425_c(), 0);
            i = light % 65536;
            j = light / 65536;
        }
        this.renderModel();
        for (LightEntry<V> entry : this.lights) {
            if (entry.shouldApplyLight(vehicle)) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)entry.getLightmapX(), (float)entry.getLightmapY());
            } else {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)i, (float)j);
            }
            for (ModelRenderer renderer : entry.getModels()) {
                renderer.func_78785_a(1.0f);
            }
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    protected abstract void renderModel();

    public static void setRotationAngle(ModelRenderer renderer, float x, float y, float z) {
        renderer.field_78795_f = x;
        renderer.field_78796_g = y;
        renderer.field_78808_h = z;
    }
}

