/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client.render.block;

import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.common.blocks.fuel.TileEntityFuelMaker;
import dev.toma.vehiclemod.common.fluids.FluidEntry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.FastTESR;

public class FuelMakerRenderer
extends FastTESR<TileEntityFuelMaker> {
    private static final ResourceLocation TEXTURE = VehicleMod.getResource("textures/blocks/fuel_maker.png");

    public void renderTileEntityFast(TileEntityFuelMaker te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        FluidEntry output;
        World world = te.func_145831_w();
        BlockPos pos = te.func_174877_v();
        IBlockState state = world.func_180495_p(pos);
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        manager.func_110577_a(TEXTURE);
        int j = state.func_185889_a((IBlockAccess)world, pos);
        int k = j >> 16 & 0xFFFF;
        int l = j & 0xFFFF;
        FluidEntry input = te.getInput();
        if (!input.isEmpty()) {
            this.render3DShape(x + 0.38125, y + 6.25E-4, z + 0.19375, input.getFilledPct(), input.getType().getFluidColor(), k, l, buffer);
        }
        if (!(output = te.getOutput()).isEmpty()) {
            this.render3DShape(x + 0.38125, y + 6.25E-4, z + 0.56875, output.getFilledPct(), output.getType().getFluidColor(), k, l, buffer);
        }
    }

    void render3DShape(double x, double y, double z, float f, int color, int k, int l, BufferBuilder buffer) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        double u1 = 0.75;
        double y1 = y + 0.0625;
        double y2 = y1 + 0.59375 * (double)f;
        double w = 0.2375;
        buffer.func_181662_b(x, y2, z + w).func_181666_a(r, g, b, 1.0f).func_187315_a(u1, 1.0).func_187314_a(k, l).func_181675_d();
        buffer.func_181662_b(x + w, y2, z + w).func_181666_a(r, g, b, 1.0f).func_187315_a(1.0, 1.0).func_187314_a(k, l).func_181675_d();
        buffer.func_181662_b(x + w, y2, z).func_181666_a(r, g, b, 1.0f).func_187315_a(1.0, 0.0).func_187314_a(k, l).func_181675_d();
        buffer.func_181662_b(x, y2, z).func_181666_a(r, g, b, 1.0f).func_187315_a(u1, 0.0).func_187314_a(k, l).func_181675_d();
        this.drawSphere(x, y1, z, x + w, y2, z, u1, r, g, b, k, l, buffer);
        this.drawSphere(x, y1, z + w, x + w, y2, z + w, u1, r, g, b, k, l, buffer);
        this.drawSphere(x + w, y1, z, x + w, y2, z + w, u1, r, g, b, k, l, buffer);
        this.drawSphere(x, y1, z, x, y2, z + w, u1, r, g, b, k, l, buffer);
    }

    void drawSphere(double x1, double y1, double z1, double x2, double y2, double z2, double u1, float r, float g, float b, int k, int l, BufferBuilder buffer) {
        buffer.func_181662_b(x1, y2, z1).func_181666_a(r, g, b, 1.0f).func_187315_a(u1, 1.0).func_187314_a(k, l).func_181675_d();
        buffer.func_181662_b(x2, y2, z2).func_181666_a(r, g, b, 1.0f).func_187315_a(1.0, 1.0).func_187314_a(k, l).func_181675_d();
        buffer.func_181662_b(x2, y1, z2).func_181666_a(r, g, b, 1.0f).func_187315_a(1.0, 0.0).func_187314_a(k, l).func_181675_d();
        buffer.func_181662_b(x1, y1, z1).func_181666_a(r, g, b, 1.0f).func_187315_a(u1, 0.0).func_187314_a(k, l).func_181675_d();
    }
}

