/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.client.render.entity;

import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.client.model.vehicle.ModelVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.NeonHandler;
import dev.toma.vehiclemod.common.entity.vehicle.PositionManager;
import dev.toma.vehiclemod.common.entity.vehicle.VehicleTexture;
import dev.toma.vehiclemod.common.items.ItemNeon;
import dev.toma.vehiclemod.common.items.ItemNeonPulser;
import dev.toma.vehiclemod.config.VMConfig;
import dev.toma.vehiclemod.config.VehicleStats;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public abstract class RenderVehicle<V extends EntityVehicle>
extends Render<V> {
    static final ResourceLocation NEON = VehicleMod.getResource("textures/entity/neon_texture.png");

    public RenderVehicle(RenderManager manager) {
        super(manager);
    }

    public abstract ModelVehicle<V> getVehicleModel();

    protected ResourceLocation getEntityTexture(V entity) {
        if (entity != null) {
            return ((EntityVehicle)entity).getTexture().getResource();
        }
        return this.getDefaultResource();
    }

    protected ResourceLocation getDefaultResource() {
        return VehicleTexture.WHITE.getResource();
    }

    public void doRender(V entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity != null && this.field_188301_f) {
            this.func_177067_a((Entity)entity, x, y, z);
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        RayTraceResult result = mc.field_71476_x;
        if (player.func_70093_af() && result != null && result.field_72313_a == RayTraceResult.Type.ENTITY && result.field_72308_g == entity && entity != null) {
            float f2 = ((EntityVehicle)entity).field_70131_O + 0.5f;
            this.drawInfo(entity, mc, (float)x, (float)y + f2, (float)z);
        }
        if (entity != null && ((EntityVehicle)entity).lightController.areLightsOn((EntityVehicle)entity)) {
            this.drawNeons(entity, x, y, z, entityYaw);
        }
    }

    private void drawNeons(V vehicle, double x, double y, double z, float yaw) {
        PositionManager positions = ((EntityVehicle)vehicle).getVehiclePositions();
        if (positions.areNeonsDisabled()) {
            return;
        }
        NeonHandler neonHandler = ((EntityVehicle)vehicle).getNeonHandler();
        ItemStack pulserStack = neonHandler.getPulserUpgrade();
        int pulse = pulserStack.func_190926_b() ? 0 : ((ItemNeonPulser)pulserStack.func_77973_b()).getPulseLength();
        float aMax = 0.53f;
        float alphaDiff = aMax - 0.1f;
        if (pulse > 0) {
            int time = ((EntityVehicle)vehicle).field_70173_aa % pulse;
            float half = (float)pulse / 2.0f;
            float diff = Math.abs(((float)time - half) / half);
            aMax = Math.max(0.1f, aMax * diff);
        }
        float aMin = Math.max(0.0f, aMax - alphaDiff);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179140_f();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179129_p();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(NEON);
        for (NeonHandler.Direction direction : NeonHandler.Direction.values()) {
            this.drawNeon(vehicle, direction, neonHandler, positions, yaw, aMax, aMin);
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void drawNeon(V vehicle, NeonHandler.Direction direction, NeonHandler handler, PositionManager manager, float yaw, float aMax, float aMin) {
        ItemStack stack = handler.getNeon(direction);
        if (stack.func_190926_b()) {
            return;
        }
        int color = ((ItemNeon)stack.func_77973_b()).getNeonColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        double length = ((EntityVehicle)vehicle).field_70130_N;
        double neonWidth = 0.15;
        double w14 = 2.0 * neonWidth / 4.0;
        double w34 = 3.0 * w14;
        Vec3d pos = direction.getPosition(manager);
        if (direction.isVertical()) {
            float a2;
            if (manager.hasCustomLength(direction)) {
                length = manager.getLength(direction);
            }
            double l = length / 2.0;
            Vec3d p1 = new Vec3d(pos.field_72450_a - neonWidth, 0.01, pos.field_72449_c + l);
            Vec3d p2 = new Vec3d(pos.field_72450_a + neonWidth, 0.01, pos.field_72449_c - l);
            float a1 = direction.shouldInvert() ? aMin : aMax;
            float f = a2 = direction.shouldInvert() ? aMax : aMin;
            if (direction.shouldInvert()) {
                builder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p2.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p1.field_72450_a + w34, p1.field_72448_b, p2.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p1.field_72450_a + w34, p1.field_72448_b, p1.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p1.field_72450_a + w34, p1.field_72448_b, p2.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p2.field_72450_a, p1.field_72448_b, p2.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p2.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p1.field_72450_a + w34, p1.field_72448_b, p1.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a2).func_181675_d();
            } else {
                builder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p2.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p1.field_72450_a + w14, p1.field_72448_b, p2.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p1.field_72450_a + w14, p1.field_72448_b, p1.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p1.field_72450_a + w14, p1.field_72448_b, p2.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p2.field_72450_a, p1.field_72448_b, p2.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p2.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p1.field_72450_a + w14, p1.field_72448_b, p1.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a1).func_181675_d();
            }
        } else {
            float a2;
            if (manager.hasCustomLength(direction)) {
                length = manager.getLength(direction);
            }
            double d = length / 2.0;
            Vec3d p1 = new Vec3d(d, 0.01, pos.field_72449_c - neonWidth);
            Vec3d p2 = new Vec3d(-d, 0.01, pos.field_72449_c + neonWidth);
            float a1 = direction.shouldInvert() ? aMin : aMax;
            float f = a2 = direction.shouldInvert() ? aMax : aMin;
            if (direction.shouldInvert()) {
                builder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c + w34).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p2.field_72450_a, p1.field_72448_b, p1.field_72449_c + w34).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p2.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p2.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p2.field_72450_a, p1.field_72448_b, p2.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p2.field_72450_a, p1.field_72448_b, p1.field_72449_c + w34).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c + w34).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a2).func_181675_d();
            } else {
                builder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c + w14).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p2.field_72450_a, p1.field_72448_b, p1.field_72449_c + w14).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p2.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p2.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p2.field_72450_a, p1.field_72448_b, p2.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a2).func_181675_d();
                builder.func_181662_b(p2.field_72450_a, p1.field_72448_b, p1.field_72449_c + w14).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a1).func_181675_d();
                builder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c + w14).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a1).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }

    private void drawInfo(V vehicle, Minecraft mc, float x, float y, float z) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FontRenderer renderer = mc.field_71466_p;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(mc.field_71474_y.field_74320_O == 2 ? -1 : 1) * this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int i = renderer.func_78256_a(vehicle.func_70005_c_()) / 2;
        if (i < 50) {
            i = 50;
        }
        GlStateManager.func_179090_x();
        float aBG = VMConfig.clientConfig.opaqueColors ? 1.0f : 0.25f;
        double of = -((EntityVehicle)vehicle).field_70131_O - 70.0f;
        int left = -i - 1;
        int right = i + 10;
        VehicleStats stats = ((EntityVehicle)vehicle).getActualStats();
        float speedStat = (stats.maxSpeed - VehicleStats.topSpeedMin) / (VehicleStats.topSpeedMax - VehicleStats.topSpeedMin);
        float accelerationStat = (stats.acceleration - VehicleStats.accelerationMin) / (VehicleStats.accelerationMax - VehicleStats.accelerationMin);
        float handlingStat = (stats.turnSpeed - VehicleStats.handlingMin) / (VehicleStats.handlingMax - VehicleStats.handlingMin);
        float brakingStat = (stats.brakeSpeed - VehicleStats.brakingMin) / (VehicleStats.brakingMax - VehicleStats.brakingMin);
        int px = left + 19;
        int width = right - px - 2;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)left, of, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, aBG).func_181675_d();
        bufferbuilder.func_181662_b((double)left, of + 88.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, aBG).func_181675_d();
        bufferbuilder.func_181662_b((double)right, of + 88.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, aBG).func_181675_d();
        bufferbuilder.func_181662_b((double)right, of, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, aBG).func_181675_d();
        RenderVehicle.addColorShapeToBuffer(bufferbuilder, px, -22, px + width, -18, -0.01, 0.0f, 0.5f, 0.0f, 1.0f);
        RenderVehicle.addColorShapeToBuffer(bufferbuilder, px, -22, (int)((float)px + (float)width * speedStat), -18, -0.02, 0.0f, 1.0f, 0.0f, 1.0f);
        RenderVehicle.addColorShapeToBuffer(bufferbuilder, px, -13, px + width, -8, -0.01, 0.5f, 0.0f, 0.0f, 1.0f);
        RenderVehicle.addColorShapeToBuffer(bufferbuilder, px, -13, (int)((float)px + (float)width * accelerationStat), -8, -0.02, 1.0f, 0.0f, 0.0f, 1.0f);
        RenderVehicle.addColorShapeToBuffer(bufferbuilder, px, -4, px + width, 1, -0.01, 0.0f, 0.0f, 0.5f, 1.0f);
        RenderVehicle.addColorShapeToBuffer(bufferbuilder, px, -4, (int)((float)px + (float)width * handlingStat), 1, -0.02, 0.0f, 0.0f, 1.0f, 1.0f);
        RenderVehicle.addColorShapeToBuffer(bufferbuilder, px, 5, px + width, 10, -0.01, 0.5f, 0.5f, 0.0f, 1.0f);
        RenderVehicle.addColorShapeToBuffer(bufferbuilder, px, 5, (int)((float)px + (float)width * brakingStat), 10, -0.02, 1.0f, 1.0f, 0.0f, 1.0f);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        renderer.func_78276_b(vehicle.func_70005_c_(), -i + 5, -68, -1);
        renderer.func_78276_b("Health: " + (int)(((EntityVehicle)vehicle).health / ((EntityVehicle)vehicle).getActualStats().maxHealth * 100.0f) + " %", -i + 5, -57, -1);
        renderer.func_78276_b("Fuel: " + (int)(100.0f * (((EntityVehicle)vehicle).fuel / (float)((EntityVehicle)vehicle).getActualStats().fuelCapacity)) + " %", -i + 5, -44, -1);
        renderer.func_78276_b("Distance: " + new DecimalFormat("#.#").format(((EntityVehicle)vehicle).getTravelledDistance()) + " km", -i + 5, -33, -1);
        renderer.func_78276_b("SPD", left + 1, -23, 65280);
        renderer.func_78276_b("ACC", left + 1, -14, 0xFF0000);
        renderer.func_78276_b("HDL", left + 1, -5, 255);
        renderer.func_78276_b("BRK", left + 1, 4, 0xFFFF00);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    static void addColorShapeToBuffer(BufferBuilder buffer, int x1, int y1, int x2, int y2, double z, float r, float g, float b, float a) {
        buffer.func_181662_b((double)x1, (double)y2, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y2, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y1, z).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y1, z).func_181666_a(r, g, b, a).func_181675_d();
    }
}

