/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common;

import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.ISpecialVehicle;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber
public class CommonEventHandler {
    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof EntityCreature) {
            EntityAITasks.EntityAITaskEntry[] entries;
            EntityCreature livingEntity = (EntityCreature)e.getEntity();
            EntityAINearestAttackableTarget<?> ai = CommonEventHandler.getTaskToBeRemoved(livingEntity);
            for (EntityAITasks.EntityAITaskEntry entry : entries = ((EntityCreature)e.getEntity()).field_70715_bh.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
                if (!(entry.field_75733_a instanceof EntityAINearestAttackableTarget)) continue;
                livingEntity.field_70715_bh.func_85156_a(entry.field_75733_a);
                livingEntity.field_70715_bh.func_75776_a(3, entry.field_75733_a);
            }
            livingEntity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity(livingEntity, EntityVehicle.class, 20.0f, 1.5, 1.2));
            livingEntity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity(livingEntity, EntityMinecart.class, 20.0f, 1.5, 1.2));
        }
    }

    @SubscribeEvent
    public static void logIn(PlayerEvent.PlayerLoggedInEvent event) {
        ForgeVersion.CheckResult result = ForgeVersion.getResult((ModContainer)Loader.instance().activeModContainer());
        switch (result.status) {
            case OUTDATED: 
            case BETA_OUTDATED: {
                TextComponentString textComponent = new TextComponentString(CommonEventHandler.getMessageLogo() + TextFormatting.RED + " Your mod is " + TextFormatting.UNDERLINE + "outdated" + TextFormatting.RED + ". Click " + TextFormatting.ITALIC + "HERE" + TextFormatting.RESET.toString() + TextFormatting.RED + " to get latest update");
                String url = "https://www.curseforge.com/minecraft/mc-mods/tomanos-vehicle-mod";
                textComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                event.player.func_145747_a((ITextComponent)textComponent);
                break;
            }
            case AHEAD: {
                event.player.func_145747_a((ITextComponent)new TextComponentString(CommonEventHandler.getMessageLogo() + TextFormatting.GREEN + " You are using unofficial version. Expect bugs"));
                break;
            }
            default: {
                event.player.func_145747_a((ITextComponent)new TextComponentString(CommonEventHandler.getMessageLogo() + TextFormatting.GREEN + " No updates available"));
            }
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof ISpecialVehicle) {
            ISpecialVehicle vehicle = (ISpecialVehicle)event.getTarget();
            vehicle.startTracking((EntityVehicle)((Object)((ISpecialVehicle)((Object)((EntityVehicle)((Object)vehicle))))), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public static void stopTracking(PlayerEvent.StopTracking event) {
        if (event.getTarget() instanceof ISpecialVehicle) {
            ISpecialVehicle vehicle = (ISpecialVehicle)event.getTarget();
            vehicle.stopTracking((EntityVehicle)((Object)((ISpecialVehicle)((Object)((EntityVehicle)((Object)vehicle))))), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    private static String getMessageLogo() {
        return TextFormatting.BLUE + "[" + TextFormatting.YELLOW + "VehicleMod" + TextFormatting.BLUE + "]" + TextFormatting.RESET;
    }

    public static EntityAINearestAttackableTarget<?> getTaskToBeRemoved(EntityCreature e) {
        for (EntityAITasks.EntityAITaskEntry ai : e.field_70715_bh.field_75782_a) {
            if (ai.field_75733_a.getClass() != EntityAINearestAttackableTarget.class) continue;
            return (EntityAINearestAttackableTarget)ai.field_75733_a;
        }
        return null;
    }
}

