/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.blocks;

import dev.toma.vehiclemod.Registries;
import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.common.blocks.BlockBasic;
import dev.toma.vehiclemod.common.tileentity.TileEntityMechanicPackage;
import java.util.Random;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMechanicPackage
extends BlockBasic {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.3, 0.9);
    private final Variant variant;

    public BlockMechanicPackage(Variant variant) {
        super("mechanic_package_" + variant.name().toLowerCase(), Material.field_151573_f);
        this.variant = variant;
        this.variant.aPackage = this;
        this.func_149711_c(2.2f);
    }

    public Variant getVariant() {
        return this.variant;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151660_b;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityMechanicPackage();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMechanicPackage) {
            ((TileEntityMechanicPackage)tileEntity).fill(this.variant);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184614_ca().func_77973_b() != Registries.VMItems.LOCKPICK) {
            if (!worldIn.field_72995_K) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("You must use lockpick to unlock this"), true);
            }
            return true;
        }
        if (worldIn.field_72995_K) {
            VehicleMod.proxy.openLockpickUI((TileEntityMechanicPackage)worldIn.func_175625_s(pos));
        }
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public static enum Variant {
        BRONZE(40, 1, 4, 0.6f, 0.25f, 0.08f, 0.05f, 0.02f, 0.0f, 0.0f, 0.07f, 0.0f, 0.0f),
        SILVER(30, 1, 5, 0.3f, 0.4f, 0.15f, 0.08f, 0.05f, 0.02f, 0.0f, 0.0f, 0.07f, 0.0f),
        GOLDEN(20, 2, 6, 0.15f, 0.35f, 0.2f, 0.15f, 0.08f, 0.05f, 0.02f, 0.0f, 0.0f, 0.07f),
        PLATINUM(10, 2, 7, 0.0f, 0.15f, 0.33f, 0.27f, 0.13f, 0.08f, 0.04f, 0.15f, 0.15f, 0.15f);

        final int spawnChance;
        final int partCount;
        final int buttons;
        final float[] levelChances;
        BlockMechanicPackage aPackage;

        private Variant(int spawnChance, int parts, int buttons, float ... chances) {
            this.spawnChance = spawnChance;
            this.partCount = parts;
            this.buttons = buttons;
            this.levelChances = chances;
        }

        public BlockMechanicPackage getPackage() {
            return this.aPackage;
        }

        public int getSpawnChance() {
            return this.spawnChance;
        }

        public int getPartCount() {
            return this.partCount;
        }

        public int getButtons() {
            return this.buttons;
        }

        public float[] getLevelChances() {
            return this.levelChances;
        }
    }
}

