/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.blocks;

import com.google.common.base.Predicate;
import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.common.tileentity.TileEntitySecret;
import dev.toma.vehiclemod.init.VMSounds;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSecret
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.1, 0.0, 0.25, 0.9, 0.5, 0.75), new AxisAlignedBB(0.25, 0.0, 0.1, 0.75, 0.5, 0.9)};

    public BlockSecret(String name) {
        super(Material.field_151576_e, MapColor.field_151660_b);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(VehicleMod.TAB);
        this.func_149722_s();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        VehicleMod.registerItemBlock(this);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151057_cb) {
            TileEntitySecret te = (TileEntitySecret)worldIn.func_175625_s(pos);
            te.setName(stack.func_82833_r());
            if (!worldIn.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("You have successfully changed this object's name to " + te.getObjectName()));
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        } else if (!playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                TileEntitySecret te = (TileEntitySecret)worldIn.func_175625_s(pos);
                worldIn.field_73010_i.forEach(player -> {
                    if (!player.func_70005_c_().equals(playerIn.func_70005_c_())) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + playerIn.func_70005_c_() + " has found a secret: " + TextFormatting.AQUA + te.getObjectName() + TextFormatting.GREEN + "!"));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "You have just found a secret: " + TextFormatting.AQUA + te.getObjectName()));
                    }
                });
            }
            worldIn.func_184133_a(null, pos, VMSounds.SECRET, SoundCategory.MASTER, 3.0f, 1.0f);
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntitySecret();
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB[BlockSecret.getIDFromState(blockState)];
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB[BlockSecret.getIDFromState(state)];
    }

    public static int getIDFromState(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (i % 2 == 0) {
            return 0;
        }
        return 1;
    }
}

