/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.blocks.fuel;

import dev.toma.vehiclemod.common.fluids.FluidEntry;
import dev.toma.vehiclemod.common.fluids.FluidItemBehavior;
import dev.toma.vehiclemod.common.fluids.FluidProcessResult;
import dev.toma.vehiclemod.common.fluids.FluidType;
import dev.toma.vehiclemod.common.fluids.IFilter;
import dev.toma.vehiclemod.common.fluids.IFuelMakerItem;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;

public class TileEntityFuelMaker
extends TileEntity
implements IInventory,
ITickable {
    public static final int MAX_STORED_AMOUNT = 250000;
    private FluidEntry inputFluid = FluidEntry.EMPTY;
    private FluidEntry outputFluid = FluidEntry.EMPTY;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private boolean processing;
    private int processTimer;

    public boolean isWorking() {
        return this.processTimer > 0;
    }

    public int getProcessTimer() {
        return this.processTimer;
    }

    public FluidEntry getInput() {
        return this.inputFluid;
    }

    public FluidEntry getOutput() {
        return this.outputFluid;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        compound.func_74757_a("isProcessing", this.processing);
        compound.func_74768_a("processTimer", this.processTimer);
        if (!this.inputFluid.isEmpty()) {
            compound.func_74782_a("inputFluid", (NBTBase)this.inputFluid.serializeNBT());
        }
        if (!this.outputFluid.isEmpty()) {
            compound.func_74782_a("outputFluid", (NBTBase)this.outputFluid.serializeNBT());
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.processing = compound.func_74767_n("isProcessing");
        this.processTimer = compound.func_74762_e("processTimer");
        if (compound.func_74764_b("inputFluid")) {
            this.inputFluid = new FluidEntry(compound.func_74775_l("inputFluid"), 250000);
        }
        if (compound.func_74764_b("outputFluid")) {
            this.outputFluid = new FluidEntry(compound.func_74775_l("outputFluid"), 250000);
        }
    }

    public void runAction(int actionID, boolean shiftClick) {
        switch (actionID) {
            case 0: {
                this.dumpInput();
                break;
            }
            case 1: {
                this.transferOutputToInput();
                break;
            }
            case 2: {
                this.processFluidIntoItem(this.inputFluid, 1, shiftClick);
                break;
            }
            case 3: {
                this.processFluidIntoItem(this.outputFluid, 2, shiftClick);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown action ID (" + actionID + ")");
            }
        }
    }

    public void dumpInput() {
        if (!this.inputFluid.isEmpty()) {
            this.inputFluid = FluidEntry.EMPTY;
        }
    }

    public void transferOutputToInput() {
        if (this.inputFluid.isEmpty()) {
            this.inputFluid = this.outputFluid;
            this.outputFluid = FluidEntry.EMPTY;
        } else if (this.inputFluid.canMix(this.outputFluid.getType())) {
            this.inputFluid.mix(this.outputFluid);
            this.outputFluid = FluidEntry.EMPTY;
        }
    }

    public void processFluidIntoItem(FluidEntry entry, int output, boolean max) {
        if (entry.isEmpty() || !entry.getType().hasFluidHolder()) {
            return;
        }
        FluidType type = entry.getType();
        Item item = type.getBehavior().getFluidItem();
        ItemStack stack = this.func_70301_a(output);
        if (stack.func_190926_b()) {
            int amount = Math.min(this.getBucketCount(), max ? entry.getAmount() / 10000 : 1);
            ItemStack out = new ItemStack(item, amount);
            for (int i = 0; i < amount; ++i) {
                int bucketIndex = this.getSlotWithBucket();
                if (bucketIndex == -1) {
                    throw new IllegalStateException("Couldn't find bucket");
                }
                this.func_70301_a(bucketIndex).func_190918_g(1);
            }
            entry.reduce(amount * 10000);
            this.func_70299_a(output, out);
        } else if (stack.func_77973_b() == item) {
            int present = stack.func_190916_E();
            int maxAmount = this.func_70297_j_() - present;
            int amount = Math.min(maxAmount, Math.min(this.getBucketCount(), max ? entry.getAmount() / 10000 : 1));
            for (int i = 0; i < amount; ++i) {
                int bucketIndex = this.getSlotWithBucket();
                if (bucketIndex == -1) {
                    throw new IllegalStateException("Couldn't find bucket");
                }
                this.func_70301_a(bucketIndex).func_190918_g(1);
            }
            entry.reduce(amount * 10000);
            stack.func_190920_e(present + amount);
        }
    }

    public int getBucketCount() {
        int count = 0;
        for (int i = 6; i < 9; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != Items.field_151133_ar) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public int getSlotWithBucket() {
        for (int i = 6; i < 9; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_77973_b() != Items.field_151133_ar) continue;
            return i;
        }
        return -1;
    }

    public void func_73660_a() {
        if (!this.inputFluid.isEmpty() && this.inputFluid.getType().hasResult() && this.hasFilters()) {
            FluidProcessResult result = this.inputFluid.getType().getProcessResult();
            if (this.inputFluid.getAmount() >= result.getRequiredAmount() && (this.outputFluid.isEmpty() || this.outputFluid.canMix(result.getType())) && this.outputFluid.getAmount() + result.getResultAmount() <= 250000) {
                if (!this.processing) {
                    this.processing = true;
                } else if (++this.processTimer >= result.getProcessTime()) {
                    this.processTimer = 0;
                    if (this.outputFluid.isEmpty()) {
                        this.outputFluid = new FluidEntry(result.getType(), 250000);
                    }
                    this.outputFluid.add(result.getResultAmount());
                    this.inputFluid.reduce(result.getRequiredAmount());
                    this.field_145850_b.func_175718_b(1035, this.field_174879_c, 0);
                    for (int i = 3; i < 6; ++i) {
                        this.func_70301_a(i).func_190918_g(1);
                    }
                    this.func_70296_d();
                }
            } else {
                this.stopProcessing();
            }
        } else {
            this.stopProcessing();
        }
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_77973_b() instanceof IFuelMakerItem) {
            int maxAdd;
            int amount;
            IFuelMakerItem item = (IFuelMakerItem)stack.func_77973_b();
            FluidType type = item.getFluid();
            if (this.inputFluid.isEmpty()) {
                this.inputFluid = new FluidEntry(type, 250000);
            }
            if (this.inputFluid.canMix(type) && (amount = Math.min(maxAdd = 250000 - this.inputFluid.getAmount(), item.getFluidAmount(stack))) > 0) {
                this.inputFluid.add(amount);
                ItemStack processed = item.processInsertion(stack.func_77946_l(), amount);
                this.func_70299_a(0, processed);
                this.func_70296_d();
                if (item.shouldCreateEmptyBucket()) {
                    boolean created = false;
                    for (int i = 6; i < 9; ++i) {
                        ItemStack itemStack = this.func_70301_a(i);
                        if (itemStack.func_190926_b()) {
                            this.func_70299_a(i, new ItemStack(Items.field_151133_ar));
                            created = true;
                            break;
                        }
                        if (itemStack.func_77973_b() != Items.field_151133_ar || itemStack.func_190916_E() >= itemStack.func_77976_d()) continue;
                        itemStack.func_190920_e(itemStack.func_190916_E() + 1);
                        created = true;
                        break;
                    }
                    if (!created && !this.field_145850_b.field_72995_K) {
                        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.2, (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack(Items.field_151133_ar));
                        this.field_145850_b.func_72838_d((Entity)entityItem);
                    }
                }
            }
        }
        this.tickOutputSlot(1, this.inputFluid);
        this.tickOutputSlot(2, this.outputFluid);
    }

    boolean hasFilters() {
        for (int i = 3; i < 6; ++i) {
            if (this.func_70301_a(i).func_77973_b() instanceof IFilter) continue;
            return false;
        }
        return true;
    }

    void stopProcessing() {
        this.processing = false;
        this.processTimer = 0;
    }

    void tickOutputSlot(int slotID, FluidEntry entry) {
        ItemStack stack = this.func_70301_a(slotID);
        if (entry.isEmpty() || stack.func_190926_b()) {
            return;
        }
        FluidType type = entry.getType();
        if (!type.hasFluidItemBehavior()) {
            return;
        }
        FluidItemBehavior behavior = type.getBehavior();
        if (behavior.canProcess(stack, entry.getAmount())) {
            behavior.process(stack, entry, slotID, this);
            this.func_70296_d();
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public String func_70005_c_() {
        return "container.fuel_maker.vm";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return 9;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_174888_l() {
        this.inventory = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
        this.func_70296_d();
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.func_70302_i_() ? (ItemStack)this.inventory.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (!stack.func_190926_b()) {
            this.inventory.set(index, (Object)ItemStack.field_190927_a);
        }
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 6;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }
}

