/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.capability.chunks;

import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.common.capability.chunks.ChunkData;
import dev.toma.vehiclemod.common.capability.chunks.ChunkDataProvider;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.EnumVehicleType;
import dev.toma.vehiclemod.common.entity.vehicle.VehicleTexture;
import dev.toma.vehiclemod.config.VMConfig;
import dev.toma.vehiclemod.util.DevUtil;
import dev.toma.vehiclemod.util.WeightedRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ChunkDataFactory
implements ChunkData {
    private boolean marked;

    @Override
    public boolean isMarked() {
        return this.marked;
    }

    @Override
    public void mark() {
        this.marked = true;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("marked", this.marked);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.marked = nbt.func_74767_n("marked");
    }

    @Mod.EventBusSubscriber(modid="vehiclemod")
    public static class EventHandler {
        static final Random random = new Random();
        static final WeightedRandom<EnumVehicleType> TYPES = new WeightedRandom<EnumVehicleType>(EnumVehicleType::getSpawnChance, EnumVehicleType.values());
        static final Map<EnumVehicleType, List<EntityEntry>> TYPE_ENTRY_MAP = new HashMap<EnumVehicleType, List<EntityEntry>>();

        @SubscribeEvent
        public static void onCapabilityAttach(AttachCapabilitiesEvent<Chunk> event) {
            event.addCapability(VehicleMod.getResource("chunk_data"), (ICapabilityProvider)new ChunkDataProvider());
        }

        @SubscribeEvent
        public static void loadChunk(ChunkEvent.Load event) {
            Chunk chunk = event.getChunk();
            World world = chunk.func_177412_p();
            ChunkData data = (ChunkData)chunk.getCapability(ChunkDataProvider.CAPABILITY, null);
            if (data != null && !data.isMarked() && !world.field_72995_K) {
                data.mark();
                chunk.func_76630_e();
                if (random.nextFloat() <= VMConfig.worldConfig.getVehicleSpawnChance()) {
                    EntityVehicle vehicle;
                    EntityEntry entry2;
                    int z;
                    int y;
                    ChunkPos pos = chunk.func_76632_l();
                    int x = (pos.field_77276_a << 4) + random.nextInt(16);
                    BlockPos pos1 = new BlockPos(x, y = world.func_189649_b(x, z = (pos.field_77275_b << 4) + random.nextInt(16)), z);
                    if (!DevUtil.MATERIAL_VALIDATOR.test(world.func_180495_p(pos1.func_177977_b()).func_185904_a())) {
                        return;
                    }
                    if (TYPE_ENTRY_MAP.isEmpty()) {
                        for (EntityEntry entry2 : ForgeRegistries.ENTITIES.getValuesCollection().stream().filter(en -> EntityVehicle.class.isAssignableFrom(en.getEntityClass())).collect(Collectors.toList())) {
                            vehicle = (EntityVehicle)entry2.newInstance(world);
                            TYPE_ENTRY_MAP.computeIfAbsent(vehicle.getVehicleType(), type -> new ArrayList()).add(entry2);
                        }
                    }
                    List<EntityEntry> list = TYPE_ENTRY_MAP.get((Object)TYPES.getRandom());
                    entry2 = list.get(random.nextInt(list.size()));
                    vehicle = (EntityVehicle)entry2.newInstance(world);
                    vehicle.func_70107_b((double)x + 0.5, (double)y + 1.0, (double)z + 0.5);
                    vehicle.fuel = 0.0f;
                    vehicle.health = vehicle.getActualStats().maxHealth * 0.1f;
                    vehicle.setTexture(VehicleTexture.RUST);
                    vehicle.field_70177_z = random.nextInt(180) - random.nextInt(180);
                    vehicle.lockManager.setCarLockType(vehicle.getVehicleType().getCarLockType(), true);
                    vehicle.lightController.setLightState(false);
                    world.func_72838_d((Entity)vehicle);
                }
            }
        }
    }
}

