/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.entity.vehicle;

import com.google.common.base.Predicate;
import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.client.CarHonkSound;
import dev.toma.vehiclemod.client.CarSound;
import dev.toma.vehiclemod.client.VehicleSoundPack;
import dev.toma.vehiclemod.common.ILockpickable;
import dev.toma.vehiclemod.common.entity.vehicle.EnumCarLockType;
import dev.toma.vehiclemod.common.entity.vehicle.EnumVehicleState;
import dev.toma.vehiclemod.common.entity.vehicle.EnumVehicleType;
import dev.toma.vehiclemod.common.entity.vehicle.LightController;
import dev.toma.vehiclemod.common.entity.vehicle.LockManager;
import dev.toma.vehiclemod.common.entity.vehicle.NeonHandler;
import dev.toma.vehiclemod.common.entity.vehicle.NitroHandler;
import dev.toma.vehiclemod.common.entity.vehicle.PositionManager;
import dev.toma.vehiclemod.common.entity.vehicle.VehicleTexture;
import dev.toma.vehiclemod.common.entity.vehicle.VehicleUpgrades;
import dev.toma.vehiclemod.common.items.IVehicleAction;
import dev.toma.vehiclemod.config.VehicleStats;
import dev.toma.vehiclemod.network.VMNetworkManager;
import dev.toma.vehiclemod.network.packets.CPacketUpdateEntity;
import dev.toma.vehiclemod.network.packets.CPacketVehicleData;
import dev.toma.vehiclemod.network.packets.SPacketLockpickAttempt;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityVehicle
extends Entity
implements IEntityAdditionalSpawnData,
ILockpickable {
    private static final Predicate<Entity> TARGET = entity -> EntitySelectors.field_180132_d.apply(entity) && EntitySelectors.field_94557_a.apply(entity) && entity.func_70067_L();
    public float health;
    public float currentSpeed;
    public float prevSpeed;
    public float turnModifier;
    public float fuel;
    public EnumVehicleState currentState;
    public EnumVehicleState prevState;
    public final LockManager lockManager;
    public final LightController lightController;
    public boolean ecoMode;
    protected VehicleContainer inventory = this.createInvetory();
    protected VehicleSoundPack soundPack;
    protected VehicleUpgrades upgrades;
    protected NitroHandler nitroHandler;
    protected NeonHandler neonHandler;
    protected VehicleTexture texture;
    private double distanceTraveled = 0.0;
    private boolean isStarted = false;
    private int startCooldown;
    @SideOnly(value=Side.CLIENT)
    public CarSound currentSound;
    @SideOnly(value=Side.CLIENT)
    public CarHonkSound honkSound;
    protected boolean inputForward;
    protected boolean inputBack;
    protected boolean inputRight;
    protected boolean inputLeft;

    public static double getMovementSpeed(EntityVehicle vehicle) {
        return Math.sqrt(vehicle.field_70159_w * vehicle.field_70159_w + vehicle.field_70179_y * vehicle.field_70179_y);
    }

    public static int[] fill(int l, int v) {
        int[] arr = new int[l];
        for (int i = 0; i < l; ++i) {
            arr[i] = v;
        }
        return arr;
    }

    public EntityVehicle(World world) {
        super(world);
        this.func_70105_a(2.0f, 1.5f);
        this.field_70138_W = 1.0f;
        this.field_70156_m = true;
        this.upgrades = this.createVehicleUpgrades();
        this.nitroHandler = new NitroHandler(this);
        this.neonHandler = new NeonHandler(this);
        this.texture = this.getBaseTexture();
        this.health = this.upgrades.getActualStats().maxHealth;
        this.setFuel();
        this.field_70158_ak = true;
        this.soundPack = this.createSoundPack();
        this.lockManager = new LockManager(EnumCarLockType.IRON);
        this.lightController = new LightController();
    }

    public EntityVehicle(World world, BlockPos pos) {
        this(world);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
    }

    public abstract EnumVehicleType getVehicleType();

    public abstract VehicleStats getConfigStats();

    public abstract int maximumAmountOfPassengers();

    public abstract VehicleSoundPack createSoundPack();

    public abstract VehicleContainer createInvetory();

    public abstract PositionManager getVehiclePositions();

    public VehicleUpgrades createVehicleUpgrades() {
        return new VehicleUpgrades(this.getConfigStats());
    }

    private void updateVehicle() {
        this.updateMotion();
        if (!(this.func_184207_aI() || this.noAccelerationInput() && this.noTurningInput() && this.hasFuel() && this.isStarted())) {
            this.inputForward = false;
            this.inputBack = false;
            this.inputRight = false;
            this.inputLeft = false;
        }
        if (this.startCooldown > 0 && --this.startCooldown == 0) {
            this.attemptStart();
        }
        this.handleEntityCollisions();
        this.checkState();
        if (!this.field_70170_p.field_72995_K) {
            VMNetworkManager.instance().sendToAllAround((IMessage)new CPacketVehicleData(this), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 256.0));
        }
        this.spawnParticles();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70123_F) {
            double d;
            double d0 = EntityVehicle.getMovementSpeed(this);
            if (d > 0.2) {
                this.currentSpeed = 0.0f;
                this.health = (float)((double)this.health - d0 * 50.0);
                for (Entity e : this.func_184188_bt()) {
                    if (e.func_190530_aW()) continue;
                    e.func_70097_a(DamageSource.field_76379_h, (float)d0 * 25.0f);
                }
            }
        }
    }

    private void updateMotion() {
        float mod;
        Vec3d lookVec = this.func_70040_Z();
        VehicleStats stats = this.getActualStats();
        Entity controller = this.func_184179_bs();
        this.nitroHandler.tick(controller);
        float healthpct = this.health / stats.maxHealth;
        float quarterHealth = stats.maxHealth / 4.0f;
        float accModifier = healthpct < 0.25f ? this.health / quarterHealth : 1.0f;
        float f = mod = this.nitroHandler.isNitroActive() ? this.upgrades.getNitroPower() : 0.0f;
        if (this.inputForward && !this.inputBack && (this.hasFuel() || this.currentSpeed < 0.0f)) {
            float acceleration = (mod += Math.max(0.04f, Math.abs(1.0f - this.currentSpeed / stats.maxSpeed))) * stats.acceleration * accModifier;
            float maxSpeed = stats.maxSpeed;
            if (this.ecoMode) {
                maxSpeed *= 0.75f;
                acceleration *= 0.4f;
            }
            this.burnFuel();
            float f2 = this.currentSpeed < maxSpeed ? Math.min(maxSpeed, this.currentSpeed + acceleration) : (this.currentSpeed = this.currentSpeed > maxSpeed ? Math.max(this.currentSpeed - stats.acceleration * mod * 2.0f, maxSpeed) : maxSpeed);
        }
        if (!this.inputForward && this.inputBack && (this.hasFuel() || this.currentSpeed > 0.0f)) {
            float speed;
            this.burnFuel();
            float f3 = speed = this.field_70170_p.func_175727_C(this.func_180425_c()) ? stats.brakeSpeed * 0.5f : stats.brakeSpeed;
            float f4 = this.currentSpeed > 0.0f ? this.currentSpeed - speed : (this.currentSpeed = this.currentSpeed > -stats.maxSpeed * 0.3f ? this.currentSpeed - stats.acceleration * accModifier : -stats.maxSpeed * 0.3f);
        }
        if (this.inputRight && !this.inputLeft) {
            float f5 = this.turnModifier < stats.maxTurningAngle ? (this.turnModifier < 0.0f ? this.turnModifier + stats.turnSpeed + 0.5f : this.turnModifier + stats.turnSpeed * 0.6f) : (this.turnModifier = stats.maxTurningAngle);
        }
        if (this.inputLeft && !this.inputRight) {
            float f6 = this.turnModifier > -stats.maxTurningAngle ? (this.turnModifier > 0.0f ? this.turnModifier - stats.turnSpeed - 0.5f : this.turnModifier - stats.turnSpeed * 0.6f) : (this.turnModifier = -stats.maxTurningAngle);
        }
        if (this.noAccelerationInput() || !this.hasFuel()) {
            if ((double)Math.abs(this.currentSpeed) < 0.01) {
                this.currentSpeed = 0.0f;
            }
            if (this.currentSpeed != 0.0f) {
                float f7 = this.currentSpeed = this.currentSpeed > 0.0f ? this.currentSpeed - stats.brakeSpeed * 0.1f : this.currentSpeed + stats.brakeSpeed * 0.1f;
            }
        }
        if (this.noTurningInput()) {
            if (Math.abs(this.turnModifier) <= 0.5f) {
                this.turnModifier = 0.0f;
            }
            if (this.turnModifier != 0.0f) {
                this.turnModifier = this.turnModifier > 0.0f ? this.turnModifier - 0.5f : this.turnModifier + 0.5f;
            }
        }
        this.field_70159_w = lookVec.field_72450_a * (double)this.currentSpeed;
        this.field_70179_y = lookVec.field_72449_c * (double)this.currentSpeed;
        if (this.currentSpeed != 0.0f) {
            this.field_70177_z += this.currentSpeed > 0.0f ? this.turnModifier : -this.turnModifier;
        }
    }

    private void checkState() {
        if (this.func_70090_H() || this.field_70170_p.func_180495_p(this.func_180425_c().func_177984_a()).func_185904_a().func_76224_d()) {
            if (this.health > 0.0f) {
                this.health = (float)((double)this.health - 0.25);
            }
            this.field_70159_w *= 0.4;
            this.field_70179_y *= 0.4;
            this.field_70181_x = -0.15;
        }
        if (this.func_180799_ab()) {
            this.health -= 10.0f;
        }
        if (!this.field_70170_p.field_72995_K && this.health < 0.0f) {
            this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 4.0f, false);
            this.func_70106_y();
        }
        this.currentState = this.getVehicleState();
    }

    private void vehicleStateChanged() {
        VehicleMod.proxy.playSoundAt(this);
    }

    public void updateInput(boolean forward, boolean back, boolean right, boolean left, EntityPlayer player) {
        if (this.isStarted) {
            this.field_70177_z = this.field_70177_z < 0.0f ? this.field_70177_z + 360.0f : (this.field_70177_z > 360.0f ? this.field_70177_z - 360.0f : this.field_70177_z);
            this.inputForward = forward;
            this.inputBack = back;
            this.inputRight = right;
            this.inputLeft = left;
        }
    }

    public int getNitroCloudSpraySlotCount() {
        return 6;
    }

    public VehicleTexture getTexture() {
        return this.texture;
    }

    public void setTexture(VehicleTexture texture) {
        this.texture = texture;
    }

    public VehicleTexture getBaseTexture() {
        return VehicleTexture.values()[this.field_70170_p.field_73012_v.nextInt(16)];
    }

    public boolean hasInventory() {
        return this.inventory != null;
    }

    public VehicleUpgrades getUpgrades() {
        return this.upgrades;
    }

    public NitroHandler getNitroHandler() {
        return this.nitroHandler;
    }

    public NeonHandler getNeonHandler() {
        return this.neonHandler;
    }

    public VehicleStats getActualStats() {
        return this.upgrades.getActualStats();
    }

    public VehicleSoundPack getSoundPack() {
        return this.soundPack;
    }

    public SoundEvent getVehicleSound() {
        return this.currentState.getSound(this.soundPack);
    }

    public void refillFuel() {
        this.fuel = Math.min((float)this.getActualStats().fuelCapacity, this.fuel + 10.0f);
    }

    public void repair(int amount) {
        this.health = this.health + (float)amount > this.getActualStats().maxHealth ? this.getActualStats().maxHealth : this.health + (float)amount;
    }

    public void setFuel() {
        this.fuel = 5.0f;
    }

    public double getTravelledDistance() {
        return this.distanceTraveled;
    }

    protected double getPassengerOffsetX(int id) {
        return 0.0;
    }

    protected double getPassengerOffsetZ(int id) {
        return 0.0;
    }

    private void spawnParticles() {
        if (this.field_70170_p.field_72995_K) {
            float health = this.health / this.getActualStats().maxHealth;
            this.getVehiclePositions().tickParticles(this, this.field_70170_p, health, this.isStarted && this.fuel > 0.0f, this.nitroHandler.isNitroActive(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z);
        }
    }

    private EnumVehicleState getVehicleState() {
        if (!this.hasFuel()) {
            return EnumVehicleState.IDLE;
        }
        if (this.isAccelerating()) {
            return EnumVehicleState.ACCELERATING;
        }
        if (this.isBraking()) {
            return EnumVehicleState.BRAKING;
        }
        if ((this.prevState == EnumVehicleState.ACCELERATING || this.prevState == EnumVehicleState.KEEPING_SPEED) && this.currentSpeed != 0.0f) {
            return EnumVehicleState.KEEPING_SPEED;
        }
        return EnumVehicleState.IDLE;
    }

    private void handleEntityCollisions() {
        Vec3d vec1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec2 = new Vec3d(vec1.field_72450_a + this.field_70159_w, vec1.field_72448_b + this.field_70181_x, vec1.field_72449_c + this.field_70179_y);
        Entity e = this.findEntityInPath(vec1, vec2);
        if (e != null) {
            if (e instanceof EntityVehicle) {
                double x = e.field_70159_w - this.field_70159_w;
                double z = e.field_70179_y - this.field_70179_y;
                double xz = Math.sqrt(x * x + z * z);
                float vehicleDamage = (float)(xz * 150.0);
                float userDamage = (float)(xz * 60.0);
                e.func_70097_a(DamageSource.field_76379_h, vehicleDamage);
                for (Entity entity : e.func_184188_bt()) {
                    if (entity.func_190530_aW()) continue;
                    entity.func_70097_a(DamageSource.field_76379_h, userDamage);
                }
                this.func_70097_a(DamageSource.field_76379_h, vehicleDamage);
                for (Entity entity : this.func_184188_bt()) {
                    if (entity.func_190530_aW()) continue;
                    entity.func_70097_a(DamageSource.field_76379_h, userDamage);
                }
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                this.currentSpeed = -this.currentSpeed / 10.0f;
            } else {
                e.field_70159_w += this.field_70159_w * (double)this.currentSpeed * 3.0;
                e.field_70181_x += (double)this.currentSpeed;
                e.field_70179_y += this.field_70179_y * (double)this.currentSpeed * 3.0;
                e.func_70097_a(DamageSource.field_76379_h, Math.abs(this.currentSpeed) * 15.0f);
            }
        }
    }

    private Entity findEntityInPath(Vec3d start, Vec3d end) {
        Entity e = null;
        List entityList = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x * 2.0, this.field_70179_y), TARGET);
        for (Entity ent : entityList) {
            AxisAlignedBB aabb;
            RayTraceResult rayTrace;
            if (ent == this || this.func_184188_bt().contains(ent) || (rayTrace = (aabb = ent.func_174813_aQ().func_186662_g(0.3)).func_72327_a(start, end)) == null) continue;
            double d1 = start.func_72436_e(rayTrace.field_72307_f);
            e = ent;
        }
        return e;
    }

    private boolean noAccelerationInput() {
        return !this.inputForward && !this.inputBack;
    }

    private boolean noTurningInput() {
        return !this.inputRight && !this.inputLeft;
    }

    private boolean hasFuel() {
        return this.fuel > 0.0f;
    }

    private void burnFuel() {
        float base = this.getActualStats().fuelConsumption;
        float toBurn = this.ecoMode ? base * 0.5f : base;
        this.fuel = Math.max(0.0f, this.fuel - toBurn);
    }

    private boolean isStandingStill() {
        return this.noAccelerationInput() && this.currentSpeed == this.prevSpeed;
    }

    private boolean isAccelerating() {
        return Math.abs(this.currentSpeed) > Math.abs(this.prevSpeed) || (this.currentSpeed > 0.0f ? this.inputForward : this.inputBack);
    }

    private boolean isBraking() {
        return Math.abs(this.currentSpeed) < Math.abs(this.prevSpeed) && (this.currentSpeed > 0.0f ? this.inputBack : this.inputForward);
    }

    private boolean hasReleasedGas() {
        return this.noAccelerationInput() && this.currentSpeed > 0.0f;
    }

    public VehicleContainer getInventory() {
        return this.inventory;
    }

    public boolean canRepaint(VehicleTexture texture) {
        return true;
    }

    public boolean isStationary() {
        return this.currentSpeed == 0.0f;
    }

    public void sync() {
        if (!this.field_70170_p.field_72995_K) {
            VMNetworkManager.instance().sendToAllTracking((IMessage)new CPacketUpdateEntity(this), (Entity)this);
        }
    }

    private void attemptStart() {
        if (!this.field_70170_p.field_72995_K && this.hasFuel() && this.field_70146_Z.nextFloat() <= MathHelper.func_76131_a((float)(this.health / this.getActualStats().maxHealth), (float)0.05f, (float)0.95f)) {
            this.isStarted = true;
            WorldServer server = (WorldServer)this.field_70170_p;
            for (EntityPlayerMP playerMP : server.func_175661_b(EntityPlayerMP.class, p -> p.field_71093_bK == this.field_71093_bK)) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(this.soundPack.start(), SoundCategory.MASTER, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, 1.0f));
            }
            this.sync();
        }
    }

    public void initiateStart() {
        if (!this.isStarted && this.startCooldown == 0) {
            this.startCooldown = 22;
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.soundPack.starting(), SoundCategory.MASTER, 1.0f, 1.0f);
        }
    }

    public int getStartCooldown() {
        return this.startCooldown;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isEcoMode() {
        return this.ecoMode;
    }

    public void setEcoMode(boolean ecoMode) {
        this.ecoMode = ecoMode;
    }

    @Override
    public int[] getCombinations() {
        return this.lockManager.getCombinations();
    }

    @Override
    public boolean shouldBreakLockpick(Random random) {
        return random.nextFloat() < 0.4f;
    }

    @Override
    public void handleUnlock(EntityPlayer player, World world) {
        this.lockManager.handleUnlock();
        this.sync();
    }

    @Override
    public SPacketLockpickAttempt createLockpickPacket(int index, int offset) {
        return SPacketLockpickAttempt.lockpickVehicle(index, offset, this.func_145782_y());
    }

    public void func_70071_h_() {
        this.updateVehicle();
        if (!this.field_70122_E) {
            this.field_70181_x -= 0.1;
        }
        super.func_70071_h_();
        this.distanceTraveled += Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) / 1000.0;
        if (this.field_70170_p.field_72995_K && this.prevState != this.currentState) {
            this.vehicleStateChanged();
        }
        this.prevSpeed = this.currentSpeed;
        this.prevState = this.currentState;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float rotationP = MathHelper.func_76142_g((float)(entityToUpdate.field_70125_A - this.field_70125_A));
        float modifiedP = MathHelper.func_76131_a((float)rotationP, (float)-10.0f, (float)90.0f);
        entityToUpdate.field_70127_C += modifiedP - rotationP;
        entityToUpdate.field_70125_A += modifiedP - rotationP;
    }

    public Entity func_184179_bs() {
        if (this.func_184188_bt().size() > 0 && this.func_184188_bt().get(0) instanceof EntityPlayer) {
            return (Entity)this.func_184188_bt().get(0);
        }
        return null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.func_184188_bt().contains(source.func_76346_g())) {
            this.health -= amount;
        }
        return true;
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K && this.func_184219_q((Entity)player) && player.func_184187_bx() == null) {
                if (this.func_184228_n((Entity)player)) {
                    player.func_184220_m((Entity)this);
                    return true;
                }
                player.func_146105_b((ITextComponent)new TextComponentString("This vehicle is locked"), true);
            }
        } else {
            if (stack.func_77973_b() instanceof IVehicleAction) {
                ((IVehicleAction)stack.func_77973_b()).apply(player, this.field_70170_p, stack, this);
                return true;
            }
            if (this.hasInventory() && !this.field_70170_p.field_72995_K && this.lockManager.isUnlocked()) {
                player.openGui((Object)VehicleMod.instance, 2, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
        }
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return super.func_184228_n(entityIn) && this.lockManager.isUnlocked();
    }

    public boolean func_70067_L() {
        return true;
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeFloat(this.health);
        buf.writeFloat(this.fuel);
        buf.writeDouble(this.distanceTraveled);
        buf.writeInt(this.texture.ordinal());
        buf.writeBoolean(this.ecoMode);
        buf.writeBoolean(this.isStarted);
        buf.writeInt(this.startCooldown);
        NBTTagCompound data = new NBTTagCompound();
        this.upgrades.writeToNBT(data);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)data);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.lockManager.serializeNBT());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.lightController.serializeNBT());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.neonHandler.serializeNBT());
        NBTTagCompound nitro = new NBTTagCompound();
        nitro.func_74782_a("tag", (NBTBase)this.nitroHandler.serializeNBT());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nitro);
    }

    public void readSpawnData(ByteBuf buf) {
        this.health = buf.readFloat();
        this.fuel = buf.readFloat();
        this.distanceTraveled = buf.readDouble();
        this.texture = VehicleTexture.values()[buf.readInt()];
        this.ecoMode = buf.readBoolean();
        this.isStarted = buf.readBoolean();
        this.startCooldown = buf.readInt();
        this.upgrades.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
        this.lockManager.deserializeNBT(ByteBufUtils.readTag((ByteBuf)buf));
        this.lightController.deserializeNBT(ByteBufUtils.readTag((ByteBuf)buf));
        this.neonHandler.deserializeNBT(ByteBufUtils.readTag((ByteBuf)buf));
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.nitroHandler.deserializeNBT(nbt.func_150295_c("tag", 10));
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (this.func_184188_bt().size() == 0) {
            this.isStarted = false;
        }
    }

    protected void func_70088_a() {
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            int id = this.func_184188_bt().indexOf(passenger);
            double x = this.getPassengerOffsetX(id);
            double z = this.getPassengerOffsetZ(id);
            Vec3d vec = new Vec3d(x, 0.0, z).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec.field_72450_a, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v + vec.field_72449_c);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("health", this.health);
        compound.func_74776_a("fuel", this.fuel);
        compound.func_74776_a("speed", this.currentSpeed);
        compound.func_74768_a("textureid", this.texture.ordinal());
        compound.func_74757_a("ecoMode", this.ecoMode);
        compound.func_74757_a("started", this.isStarted);
        compound.func_74768_a("startCooldown", this.startCooldown);
        compound.func_74780_a("traveledDist", this.distanceTraveled);
        if (this.hasInventory()) {
            NBTTagList invNBT = new NBTTagList();
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                NBTTagCompound dataNBT = new NBTTagCompound();
                NBTTagCompound itemStackNBT = new NBTTagCompound();
                stack.func_77955_b(itemStackNBT);
                dataNBT.func_74768_a("position", i);
                dataNBT.func_74782_a("stack", (NBTBase)itemStackNBT);
                invNBT.func_74742_a((NBTBase)dataNBT);
            }
            compound.func_74782_a("inventory", (NBTBase)invNBT);
        }
        compound.func_74782_a("lock", (NBTBase)this.lockManager.serializeNBT());
        this.upgrades.writeToNBT(compound);
        compound.func_74782_a("lightController", (NBTBase)this.lightController.serializeNBT());
        compound.func_74782_a("nitro", (NBTBase)this.nitroHandler.serializeNBT());
        compound.func_74782_a("neons", (NBTBase)this.neonHandler.serializeNBT());
        this.writeExtraData(compound);
    }

    protected void writeExtraData(NBTTagCompound compound) {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.health = compound.func_74760_g("health");
        this.fuel = compound.func_74760_g("fuel");
        this.currentSpeed = compound.func_74760_g("speed");
        this.texture = VehicleTexture.values()[compound.func_74762_e("textureid")];
        this.ecoMode = compound.func_74767_n("ecoMode");
        this.isStarted = compound.func_74767_n("started");
        this.startCooldown = compound.func_74762_e("startCooldown");
        this.distanceTraveled = compound.func_74769_h("traveledDist");
        if (compound.func_74764_b("inventory")) {
            NBTTagList list = compound.func_150295_c("inventory", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound itemStackNBT = list.func_150305_b(i);
                int index = itemStackNBT.func_74762_e("position");
                ItemStack stack = new ItemStack(itemStackNBT.func_74775_l("stack"));
                this.inventory.func_70299_a(index, stack);
            }
        }
        this.lockManager.deserializeNBT(compound.func_150297_b("lock", 10) ? compound.func_74775_l("lock") : new NBTTagCompound());
        this.upgrades.readFromNBT(compound);
        this.lightController.deserializeNBT(compound.func_150297_b("lightController", 10) ? compound.func_74775_l("lightController") : new NBTTagCompound());
        this.nitroHandler.deserializeNBT(compound.func_150297_b("nitro", 9) ? compound.func_150295_c("nitro", 10) : new NBTTagList());
        this.neonHandler.deserializeNBT(compound.func_150297_b("neons", 10) ? compound.func_74775_l("neons") : new NBTTagCompound());
        this.readExtraData(compound);
    }

    protected void readExtraData(NBTTagCompound compound) {
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.maximumAmountOfPassengers();
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    public static class VehicleContainer
    extends InventoryBasic {
        public VehicleContainer(EntityVehicle vehicle, int slots) {
            super(vehicle.func_145748_c_() + " container", false, slots);
        }
    }
}

