/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.entity.vehicle;

import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.EnumVehicleState;
import dev.toma.vehiclemod.util.DevUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LightController
implements INBTSerializable<NBTTagCompound> {
    private boolean lights = true;
    private TurnLightStatus turnLightStatus = TurnLightStatus.OFF;

    @SideOnly(value=Side.CLIENT)
    public boolean areLightsOn(EntityVehicle vehicle) {
        return this.lights;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isReversing(EntityVehicle vehicle) {
        if (vehicle.func_184179_bs() == Minecraft.func_71410_x().field_71439_g) {
            return vehicle.currentSpeed <= vehicle.prevSpeed && vehicle.currentSpeed < 0.0f && vehicle.inputBack;
        }
        return vehicle.currentSpeed < 0.0f && vehicle.currentSpeed <= vehicle.prevSpeed;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isBraking(EntityVehicle vehicle) {
        if (vehicle.func_184179_bs() == Minecraft.func_71410_x().field_71439_g) {
            return vehicle.inputBack && vehicle.currentSpeed >= 0.0f;
        }
        return vehicle.currentSpeed > 0.0f && vehicle.currentState == EnumVehicleState.BRAKING;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("lights", this.lights);
        nbt.func_74768_a("turnStatus", this.turnLightStatus.ordinal());
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.lights = nbt.func_74767_n("lights");
        this.turnLightStatus = DevUtil.getEnumFromNBT("turnStatus", nbt, TurnLightStatus.class);
    }

    public void setLightState(boolean lights) {
        this.lights = lights;
    }

    public void setTurnLightStatus(TurnLightStatus status) {
        this.turnLightStatus = this.turnLightStatus == status ? TurnLightStatus.OFF : status;
    }

    public boolean getLightFlag() {
        return this.lights;
    }

    public TurnLightStatus getTurnLightStatus() {
        return this.turnLightStatus;
    }

    public static enum TurnLightStatus {
        OFF,
        RIGHT,
        LEFT,
        WARNING;

    }
}

