/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.entity.vehicle;

import dev.toma.vehiclemod.common.ILockpickable;
import dev.toma.vehiclemod.common.entity.vehicle.EnumCarLockType;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class LockManager
implements Predicate<UUID>,
INBTSerializable<NBTTagCompound> {
    protected EnumCarLockType carLockType;
    protected UUID linkedUUID;
    private boolean unlocked;
    private int[] combinations;

    public LockManager(EnumCarLockType carLockType) {
        this.setCarLockType(carLockType, false);
        this.linkedUUID = UUID.randomUUID();
    }

    public int[] getCombinations() {
        return this.combinations;
    }

    public void handleUnlock() {
        this.setUnlocked(true);
        this.linkedUUID = UUID.randomUUID();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("lockType", (byte)this.carLockType.ordinal());
        nbt.func_74757_a("unlocked", this.unlocked);
        nbt.func_74778_a("key", this.linkedUUID.toString());
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.carLockType = EnumCarLockType.values()[nbt.func_74771_c("lockType")];
        this.unlocked = nbt.func_74767_n("unlocked");
        this.linkedUUID = nbt.func_150297_b("key", 8) ? UUID.fromString(nbt.func_74779_i("key")) : UUID.randomUUID();
    }

    @Override
    public boolean test(UUID uuid) {
        return this.linkedUUID.equals(uuid);
    }

    public void setUnlocked(boolean unlocked) {
        this.unlocked = unlocked;
        ILockpickable.shuffle(this.combinations);
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public void setCarLockType(EnumCarLockType carLockType, boolean isNatural) {
        this.carLockType = carLockType;
        this.combinations = new int[carLockType.getPinCount(isNatural)];
        for (int i = 0; i < this.combinations.length; ++i) {
            this.combinations[i] = i;
        }
        ILockpickable.shuffle(this.combinations);
        this.linkedUUID = UUID.randomUUID();
    }

    public EnumCarLockType getCarLockType() {
        return this.carLockType;
    }

    public UUID getLinkedUUID() {
        return this.linkedUUID;
    }
}

