/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.entity.vehicle;

import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.PositionManager;
import dev.toma.vehiclemod.common.inventory.InventoryNeons;
import dev.toma.vehiclemod.util.DevUtil;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.INBTSerializable;

public class NeonHandler
implements INBTSerializable<NBTTagCompound> {
    private final EntityVehicle vehicle;
    private InventoryNeons neons;

    public NeonHandler(EntityVehicle vehicle) {
        this.vehicle = vehicle;
        this.neons = new InventoryNeons(vehicle);
    }

    public ItemStack getPulserUpgrade() {
        return this.neons.func_70301_a(0);
    }

    public ItemStack getNeon(Direction direction) {
        return this.neons.func_70301_a(1 + direction.ordinal());
    }

    public NBTTagCompound serializeNBT() {
        return DevUtil.inventoryToNBTCompound((IInventory)this.neons);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        DevUtil.loadInventoryFromNBTCompound((IInventory)this.neons, nbt);
    }

    public InventoryNeons getNeons() {
        return this.neons;
    }

    public static enum Direction {
        FRONT(PositionManager::getFrontNeon, false, false),
        RIGHT(PositionManager::getRightNeon, true, false),
        BACK(PositionManager::getBackNeon, false, true),
        LEFT(PositionManager::getLeftNeon, true, true);

        final Function<PositionManager, Vec3d> position;
        final boolean vertical;
        final boolean invert;

        private Direction(Function<PositionManager, Vec3d> position, boolean vertical, boolean invert) {
            this.position = position;
            this.vertical = vertical;
            this.invert = invert;
        }

        public Vec3d getPosition(PositionManager manager) {
            return this.position.apply(manager);
        }

        public boolean isVertical() {
            return this.vertical;
        }

        public boolean shouldInvert() {
            return this.invert;
        }
    }
}

