/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.entity.vehicle;

import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.items.ItemNitroCan;
import dev.toma.vehiclemod.init.VMSounds;
import dev.toma.vehiclemod.util.DevUtil;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class NitroHandler
implements INBTSerializable<NBTTagList> {
    private final InventoryNitro inventory;
    private final EntityVehicle vehicle;
    private int useTicksLeft;
    private int startDelay;
    private int slotID;
    private boolean cloudsActive;

    public NitroHandler(EntityVehicle vehicle) {
        this.vehicle = vehicle;
        this.inventory = new InventoryNitro();
    }

    public void setCloudState(boolean state) {
        this.cloudsActive = state;
    }

    public boolean areCloudsActive() {
        return this.cloudsActive;
    }

    public void initiateUse(Entity entity, int slotID) {
        this.startDelay = 25;
        this.slotID = slotID;
        if (entity.field_70170_p.field_72995_K) {
            entity.func_184185_a(VMSounds.NITRO_START, 1.0f, 1.0f);
        }
    }

    public void tick(Entity entity) {
        if (this.useTicksLeft > 0) {
            --this.useTicksLeft;
            if (this.useTicksLeft == 0 && entity.field_70170_p.field_72995_K) {
                entity.func_184185_a(VMSounds.NITRO_END, 1.0f, 1.0f);
            }
        }
        if (this.startDelay > 0 && --this.startDelay == 0 && this.hasNitro(this.slotID)) {
            if (this.vehicle.field_70170_p.field_72995_K) {
                VehicleMod.proxy.playNitroSound(this.vehicle);
            }
            ItemStack stack = this.inventory.func_70301_a(this.slotID);
            this.useTicksLeft = ((ItemNitroCan)stack.func_77973_b()).getUseTicks();
            stack.func_77964_b(1);
        }
    }

    public boolean hasNitro(int slotID) {
        ItemStack stack = this.inventory.func_70301_a(slotID);
        return stack.func_77973_b() instanceof ItemNitroCan && stack.func_77952_i() < stack.func_77958_k();
    }

    public InventoryBasic getInventory() {
        return this.inventory;
    }

    public int getActiveSlot() {
        return this.slotID;
    }

    public boolean isNitroActive() {
        return this.useTicksLeft > 0;
    }

    public NBTTagList serializeNBT() {
        return DevUtil.inventoryToNBT((IInventory)this.inventory);
    }

    public void deserializeNBT(NBTTagList nbt) {
        DevUtil.loadInventoryFromNBT((IInventory)this.inventory, nbt);
    }

    public int getFirstUsableNitroSlot() {
        for (int i = 0; i < 5; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemNitroCan) || stack.func_77952_i() >= stack.func_77958_k()) continue;
            return i;
        }
        return -1;
    }

    public EntityVehicle getVehicle() {
        return this.vehicle;
    }

    public class InventoryNitro
    extends InventoryBasic {
        public InventoryNitro() {
            super("inventory.nitro", false, 12);
        }

        public int func_70297_j_() {
            return 1;
        }

        public void func_70296_d() {
            super.func_70296_d();
            EntityVehicle vehicle = NitroHandler.this.vehicle;
            if (!vehicle.field_70170_p.field_72995_K) {
                vehicle.sync();
            }
        }
    }
}

