/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.entity.vehicle;

import dev.toma.vehiclemod.Registries;
import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.client.particle.Particles;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.NeonHandler;
import dev.toma.vehiclemod.common.items.ItemNitroCloud;
import dev.toma.vehiclemod.util.DevUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PositionManager {
    private final Vec3d engine;
    private final Vec3d[] exhausts;
    private final Vec3d neonFront;
    private final Vec3d neonBack;
    private final Vec3d neonRight;
    private final Vec3d neonLeft;
    private final boolean neonsDisabled;
    private final Map<NeonHandler.Direction, Double> directionDoubleMap;
    private final CloudExit[] nitroClouds;

    public PositionManager(Builder builder) {
        this.engine = builder.engine;
        this.exhausts = builder.exhausts;
        this.neonFront = builder.neonFront;
        this.neonBack = builder.neonBack;
        this.neonRight = builder.neonRight;
        this.neonLeft = builder.neonLeft;
        this.neonsDisabled = builder.neonsDisabled;
        this.directionDoubleMap = builder.map;
        this.nitroClouds = builder.cloudExits.toArray(new CloudExit[0]);
    }

    public boolean hasCustomLength(NeonHandler.Direction direction) {
        return this.directionDoubleMap.containsKey((Object)direction);
    }

    public double getLength(NeonHandler.Direction direction) {
        return DevUtil.getSafe(this.directionDoubleMap, direction, 0.0);
    }

    public void tickParticles(EntityVehicle vehicle, World world, float healthPct, boolean engineFlag, boolean nitro, double x, double y, double z, float yaw) {
        boolean nitroCloud;
        if (healthPct <= 0.5f) {
            Vec3d eng = this.rotateVectorYaw(this.engine, yaw);
            world.func_175682_a(EnumParticleTypes.SMOKE_LARGE, true, x + eng.field_72450_a, y + eng.field_72448_b, z + eng.field_72449_c, 0.0, 0.1, 0.0, new int[0]);
        }
        if (engineFlag) {
            for (Vec3d vec3d : this.exhausts) {
                Vec3d ex = this.rotateVectorYaw(vec3d, yaw);
                world.func_175682_a(EnumParticleTypes.SMOKE_NORMAL, true, x + ex.field_72450_a, y + ex.field_72448_b, z + ex.field_72449_c, 0.0, 0.02, 0.0, new int[0]);
                if (!nitro) continue;
                VehicleMod.proxy.spawnParticle(Particles.NITRO_FLAME, world, x + ex.field_72450_a, y + ex.field_72448_b, z + ex.field_72449_c, 0.0, 0.0, 0.0, 1);
            }
        }
        if (nitroCloud = vehicle.getNitroHandler().areCloudsActive()) {
            boolean litUp = vehicle.getNitroHandler().getInventory().func_70301_a(11).func_77973_b() == Registries.VMItems.NITRO_LED;
            for (int i = 0; i < vehicle.getNitroCloudSpraySlotCount(); ++i) {
                ItemStack stack = vehicle.getNitroHandler().getInventory().func_70301_a(5 + i);
                if (stack.func_190926_b()) continue;
                ItemNitroCloud cloud = (ItemNitroCloud)stack.func_77973_b();
                CloudExit exit = this.nitroClouds[i];
                Vec3d pos = this.rotateVectorYaw(exit.getPosition(), yaw);
                Vec3d mot = this.rotateVectorYaw(exit.getMotion(), yaw);
                int clr = litUp ? cloud.getColor() | 0x1000000 : cloud.getColor();
                VehicleMod.proxy.spawnParticle(Particles.NITRO_CLOUD, world, x + pos.field_72450_a, y + pos.field_72448_b, z + pos.field_72449_c, mot.field_72450_a, mot.field_72448_b, mot.field_72449_c, clr);
            }
        }
    }

    public Vec3d getFrontNeon() {
        return this.neonFront;
    }

    public Vec3d getBackNeon() {
        return this.neonBack;
    }

    public Vec3d getRightNeon() {
        return this.neonRight;
    }

    public Vec3d getLeftNeon() {
        return this.neonLeft;
    }

    public CloudExit[] getNitroClouds() {
        return this.nitroClouds;
    }

    public Vec3d rotateVectorYaw(Vec3d input, float yaw) {
        return input.func_178785_b(-yaw * ((float)Math.PI / 180) - 1.5707964f);
    }

    public boolean areNeonsDisabled() {
        return this.neonsDisabled;
    }

    public static class CloudExit {
        Vec3d position;
        Vec3d motion;

        CloudExit(Vec3d position, Vec3d motion) {
            this.position = position;
            this.motion = motion;
        }

        public Vec3d getMotion() {
            return this.motion;
        }

        public Vec3d getPosition() {
            return this.position;
        }
    }

    public static class Builder {
        private Vec3d engine;
        private Vec3d[] exhausts;
        private Vec3d neonFront;
        private Vec3d neonBack;
        private Vec3d neonRight;
        private Vec3d neonLeft;
        private boolean neonsDisabled;
        private Map<NeonHandler.Direction, Double> map = new HashMap<NeonHandler.Direction, Double>();
        private List<CloudExit> cloudExits = new ArrayList<CloudExit>();

        Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder engine(double x, double y, double z) {
            this.engine = new Vec3d(x, y, z);
            return this;
        }

        public Builder exhaust(double x, double y, double z) {
            return this.exhaust(new Vec3d(x, y, z));
        }

        public Builder exhaust(Vec3d ... vecs) {
            this.exhausts = vecs;
            return this;
        }

        public Builder frontNeon(double n) {
            this.neonFront = new Vec3d(0.0, 0.0, n);
            return this;
        }

        public Builder backNeon(double n) {
            this.neonBack = new Vec3d(0.0, 0.0, -n);
            return this;
        }

        public Builder rightNeon(double n) {
            this.neonRight = new Vec3d(n, 0.0, 0.0);
            return this;
        }

        public Builder rightNeon(double x, double z) {
            this.neonRight = new Vec3d(x, 0.0, z);
            return this;
        }

        public Builder leftNeon(double n) {
            this.neonLeft = new Vec3d(-n, 0.0, 0.0);
            return this;
        }

        public Builder leftNeon(double x, double z) {
            this.neonLeft = new Vec3d(-x, 0.0, z);
            return this;
        }

        public Builder sideNeons(double n) {
            this.rightNeon(n);
            this.leftNeon(n);
            return this;
        }

        public Builder sideNeons(double x, double z) {
            this.rightNeon(x, z);
            this.leftNeon(x, z);
            return this;
        }

        public Builder frontLength(double length) {
            return this.length(NeonHandler.Direction.FRONT, length);
        }

        public Builder backLength(double length) {
            return this.length(NeonHandler.Direction.BACK, length);
        }

        public Builder sideLength(double length) {
            this.length(NeonHandler.Direction.RIGHT, length);
            this.length(NeonHandler.Direction.LEFT, length);
            return this;
        }

        public Builder length(NeonHandler.Direction direction, double length) {
            this.map.put(direction, length);
            return this;
        }

        public Builder disable() {
            this.neonsDisabled = true;
            return this;
        }

        public Builder nitroExit(double x, double y, double z, double motionX, double motionY, double motionZ) {
            this.cloudExits.add(new CloudExit(new Vec3d(x, y, z), new Vec3d(motionX, motionY, motionZ)));
            return this;
        }

        public PositionManager build() {
            return new PositionManager(this);
        }
    }
}

