/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.entity.vehicle;

import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.items.ItemPerk;
import dev.toma.vehiclemod.common.items.ItemVehicleUpgrade;
import dev.toma.vehiclemod.common.tunning.IStatApplicator;
import dev.toma.vehiclemod.common.tunning.StatPackage;
import dev.toma.vehiclemod.config.VehicleStats;
import dev.toma.vehiclemod.util.DevUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class VehicleUpgrades {
    private final SortedMap<ItemVehicleUpgrade.Type, Integer> upgradeMap;
    private final ItemPerk[] perks = new ItemPerk[3];
    private final VehicleStats configStats;
    private VehicleStats modifiedStats;
    float health;
    float topSpeed;
    float acceleration;
    float braking;
    float handling;
    float fuelCons;
    float fuelCap;
    float nitroPower;

    public VehicleUpgrades(VehicleStats stats) {
        this(stats, new int[9]);
    }

    public VehicleUpgrades(VehicleStats stats, int[] defaults) {
        this.configStats = stats;
        this.setDefaults();
        this.upgradeMap = DevUtil.make(new TreeMap(Comparator.comparingInt(Enum::ordinal)), map -> {
            for (int i = 0; i < ItemVehicleUpgrade.Type.values().length; ++i) {
                ItemVehicleUpgrade.Type type = ItemVehicleUpgrade.Type.values()[i];
                map.put(type, defaults[i]);
            }
        });
        this.recalculate();
    }

    public boolean canUpgradeWith(ItemVehicleUpgrade upgrade) {
        ItemVehicleUpgrade.Type type = upgrade.getType();
        int level = (Integer)this.upgradeMap.get((Object)type);
        int toSet = upgrade.getLevel();
        return toSet > level;
    }

    public void upgrade(ItemVehicleUpgrade upgrade, EntityPlayer player) {
        if (this.canUpgradeWith(upgrade)) {
            this.upgradeMap.put(upgrade.getType(), upgrade.getLevel());
        }
        EntityVehicle vehicle = null;
        if (player.func_184187_bx() instanceof EntityVehicle) {
            vehicle = (EntityVehicle)player.func_184187_bx();
        }
        float prevMaxHealth = this.getActualStats().maxHealth;
        float pct = vehicle != null ? vehicle.health / prevMaxHealth : 1.0f;
        this.recalculate();
        float actualMax = this.getActualStats().maxHealth;
        if (prevMaxHealth != actualMax && vehicle != null) {
            vehicle.health = actualMax * pct;
        }
    }

    private void recalculate() {
        this.setDefaults();
        for (ItemVehicleUpgrade.Type type : ItemVehicleUpgrade.Type.values()) {
            int level = (Integer)this.upgradeMap.get((Object)type);
            if (level <= 0) continue;
            StatPackage statPackage = type.getPackage();
            statPackage.forEachModifier(modifier -> {
                IStatApplicator applicator = modifier.getType().getApplicator();
                applicator.applyOnStat(this, modifier.getValues()[level - 1]);
            });
        }
        for (int i = 0; i < this.perks.length; ++i) {
            if (!this.hasPerk(i)) continue;
            ItemPerk perk = this.getPerk(i);
            IStatApplicator applicator = perk.getModifierType().getApplicator();
            applicator.applyOnStat(this, perk.getValue());
        }
        float health = this.configStats.maxHealth * this.health;
        float acceleration = this.configStats.acceleration * this.acceleration;
        float topSpeed = this.configStats.maxSpeed * this.topSpeed;
        float braking = this.configStats.brakeSpeed * this.braking;
        float handling = this.configStats.turnSpeed * this.handling;
        float fuelCons = this.configStats.fuelConsumption * (1.0f + (1.0f - this.fuelCons));
        float fuelCap = (float)this.configStats.fuelCapacity * this.fuelCap;
        this.modifiedStats = new VehicleStats(health, topSpeed, acceleration, braking, handling, this.configStats.maxTurningAngle, fuelCons, (int)fuelCap);
    }

    public VehicleStats getActualStats() {
        return this.modifiedStats != null ? this.modifiedStats : this.configStats;
    }

    public void addHealth(float toAdd) {
        this.health += toAdd;
    }

    public void addTopSpeed(float toAdd) {
        this.topSpeed += toAdd;
    }

    public void addAcceleration(float toAdd) {
        this.acceleration += toAdd;
    }

    public void addBraking(float toAdd) {
        this.braking += toAdd;
    }

    public void addHandling(float toAdd) {
        this.handling += toAdd;
    }

    public void addFuelCons(float toAdd) {
        this.fuelCons += toAdd;
    }

    public void addFuelCap(float toAdd) {
        this.fuelCap += toAdd;
    }

    public void addNitroPower(float toAdd) {
        this.nitroPower += toAdd;
    }

    public ItemPerk getPerk(int id) {
        return this.perks[id];
    }

    public void setPerk(int id, ItemPerk perk) {
        this.perks[id] = perk;
        this.recalculate();
    }

    public boolean hasPerk(int id) {
        return this.getPerk(id) != null;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ItemVehicleUpgrade.Type, Integer> entry : this.upgradeMap.entrySet()) {
            list.func_74742_a((NBTBase)new NBTTagInt(entry.getValue().intValue()));
        }
        nbt.func_74782_a("upgrades", (NBTBase)list);
        NBTTagList perks = new NBTTagList();
        for (int i = 0; i < this.perks.length; ++i) {
            ItemPerk perk = this.perks[i];
            if (perk == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("key", (byte)i);
            compound.func_74778_a("value", perk.getRegistryName().toString());
            perks.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("perks", (NBTBase)perks);
    }

    public void readFromNBT(NBTTagCompound compound) {
        int i;
        NBTTagList list;
        if (compound.func_150297_b("upgrades", 9)) {
            list = compound.func_150295_c("upgrades", 3);
            for (i = 0; i < list.func_74745_c(); ++i) {
                int v = list.func_186858_c(i);
                this.upgradeMap.put(ItemVehicleUpgrade.Type.values()[i], v);
            }
        }
        if (compound.func_150297_b("perks", 9)) {
            list = compound.func_150295_c("perks", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                byte index = nbt.func_74771_c("key");
                ResourceLocation location = new ResourceLocation(nbt.func_74779_i("value"));
                Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
                if (!(item instanceof ItemPerk)) continue;
                this.perks[index] = (ItemPerk)item;
            }
        }
        this.recalculate();
    }

    public Map<ItemVehicleUpgrade.Type, Integer> getUpgradeMap() {
        return this.upgradeMap;
    }

    public float getNitroPower() {
        return this.nitroPower;
    }

    private void setDefaults() {
        this.health = 1.0f;
        this.topSpeed = 1.0f;
        this.acceleration = 1.0f;
        this.braking = 1.0f;
        this.handling = 1.0f;
        this.fuelCons = 1.0f;
        this.fuelCap = 1.0f;
        this.nitroPower = 0.2f;
    }
}

