/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.fluids;

import dev.toma.vehiclemod.Registries;
import dev.toma.vehiclemod.common.fluids.FluidType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class FluidEntry
implements INBTSerializable<NBTTagCompound> {
    public static final FluidEntry EMPTY = new FluidEntry((FluidType)null, 0);
    final int limit;
    FluidType type;
    int amount;

    public FluidEntry(FluidType type, int limit) {
        this.type = type;
        this.limit = limit;
    }

    public FluidEntry(NBTTagCompound nbt, int limit) {
        this.limit = limit;
        this.deserializeNBT(nbt);
    }

    public float getFilledPct() {
        return (float)this.amount / (float)this.limit;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.type == null;
    }

    public boolean canMix(FluidType type) {
        return this.type == type && !this.isEmpty();
    }

    public void mix(FluidEntry entry) {
        this.add(entry.getAmount());
    }

    public FluidType getType() {
        return this.type;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        if (this.amount <= 0) {
            this.type = null;
        }
    }

    public void add(int amount) {
        this.setAmount(Math.min(this.limit, this.amount + Math.abs(amount)));
    }

    public void reduce(int amount) {
        this.setAmount(Math.max(0, this.amount - Math.abs(amount)));
    }

    public int getAmount() {
        return this.amount;
    }

    public int getLimit() {
        return this.limit;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("key", this.type.getRegistryName().toString());
        nbt.func_74768_a("amount", this.amount);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.type = (FluidType)Registries.FLUID_TYPES.getValue(new ResourceLocation(nbt.func_74779_i("key")));
        this.amount = nbt.func_74762_e("amount");
    }
}

