/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.fluids;

import dev.toma.vehiclemod.common.fluids.FluidEntry;
import dev.toma.vehiclemod.common.items.ItemNitroCan;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public interface FluidItemBehavior {
    @Nullable
    public Item getFluidItem();

    public boolean canProcess(ItemStack var1, int var2);

    public void process(ItemStack var1, FluidEntry var2, int var3, IInventory var4);

    public static class Nitro
    implements FluidItemBehavior {
        @Override
        public Item getFluidItem() {
            return null;
        }

        @Override
        public boolean canProcess(ItemStack stack, int amount) {
            return stack.func_77973_b() instanceof ItemNitroCan && stack.func_77952_i() == 1 && amount > 0;
        }

        @Override
        public void process(ItemStack stack, FluidEntry entry, int slotID, IInventory inventory) {
            stack.func_77964_b(0);
            entry.reduce(((ItemNitroCan)stack.func_77973_b()).getCapacity());
        }
    }

    public static class Bucket
    implements FluidItemBehavior {
        private final Item out;

        public Bucket(Item out) {
            this.out = out;
        }

        @Override
        public Item getFluidItem() {
            return this.out;
        }

        @Override
        public boolean canProcess(ItemStack stack, int amount) {
            return stack.func_77973_b() == Items.field_151133_ar && amount >= 10000;
        }

        @Override
        public void process(ItemStack stack, FluidEntry entry, int slotID, IInventory inventory) {
            inventory.func_70299_a(slotID, new ItemStack(this.out));
            entry.reduce(10000);
        }
    }
}

