/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.fluids;

import dev.toma.vehiclemod.common.fluids.FluidItemBehavior;
import dev.toma.vehiclemod.common.fluids.FluidProcessResult;
import java.util.function.Supplier;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidType
extends IForgeRegistryEntry.Impl<FluidType> {
    private ITextComponent displayName;
    private final int fluidColor;
    private final FluidProcessResult result;
    private final FluidItemBehavior fluidItemBehavior;

    FluidType(Builder builder) {
        this.fluidColor = builder.color;
        this.result = builder.result;
        this.fluidItemBehavior = builder.fluidItemBehavior;
    }

    public ITextComponent getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new TextComponentTranslation("fluid." + this.getRegistryName().toString(), new Object[0]);
        }
        return this.displayName;
    }

    public boolean hasFluidHolder() {
        return this.fluidItemBehavior != null && this.fluidItemBehavior.getFluidItem() != null;
    }

    public boolean hasFluidItemBehavior() {
        return this.fluidItemBehavior != null;
    }

    public FluidItemBehavior getBehavior() {
        return this.fluidItemBehavior;
    }

    public boolean hasResult() {
        return this.result != null;
    }

    public int getFluidColor() {
        return this.fluidColor;
    }

    public FluidProcessResult getProcessResult() {
        return this.result;
    }

    public static class Builder {
        private int color;
        private FluidProcessResult result;
        private FluidItemBehavior fluidItemBehavior;

        public Builder fluidColor(int colorRGB) {
            this.color = colorRGB;
            return this;
        }

        public Builder processInto(Supplier<FluidType> type, int resultAmount, int requiredAmount, int processTime) {
            this.result = new FluidProcessResult(type, resultAmount, requiredAmount, processTime);
            return this;
        }

        public Builder behavior(FluidItemBehavior behavior) {
            this.fluidItemBehavior = behavior;
            return this;
        }

        public FluidType build() {
            return new FluidType(this);
        }
    }
}

