/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.items;

import dev.toma.vehiclemod.Registries;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.LockManager;
import dev.toma.vehiclemod.common.items.VMItem;
import dev.toma.vehiclemod.init.VMSounds;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemCarKey
extends VMItem {
    public ItemCarKey(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public static ItemStack createKeysFor(EntityVehicle vehicle, EntityPlayer player) {
        ItemStack stack = new ItemStack((Item)Registries.VMItems.CAR_KEY);
        stack.func_151001_c(vehicle.func_145748_c_().func_150254_d());
        ItemCarKey.setUUID(stack, vehicle.lockManager.getLinkedUUID());
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        UUID uuid = ItemCarKey.getStoredUUID(stack);
        int keyRange = 30;
        List nearbyVehicles = worldIn.func_72872_a(EntityVehicle.class, playerIn.func_174813_aQ().func_186662_g((double)keyRange));
        for (EntityVehicle vehicle : nearbyVehicles) {
            LockManager manager = vehicle.lockManager;
            if (!manager.test(uuid)) continue;
            manager.setUnlocked(!manager.isUnlocked());
            worldIn.func_184148_a(null, vehicle.field_70165_t, vehicle.field_70163_u, vehicle.field_70161_v, manager.isUnlocked() ? VMSounds.CAR_UNLOCKED : VMSounds.CAR_LOCKED, SoundCategory.MASTER, 2.0f, 1.0f);
            break;
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    private static UUID getStoredUUID(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("vehicle", 8) ? UUID.fromString(stack.func_77978_p().func_74779_i("vehicle")) : null;
    }

    private static void setUUID(ItemStack stack, UUID uuid) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        nbt.func_74778_a("vehicle", uuid.toString());
    }
}

