/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.items;

import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.items.ItemVehicleAccessory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemRepairKit
extends ItemVehicleAccessory {
    private final Tier tier;

    public ItemRepairKit(String name, Tier tier) {
        super(tier.name().toLowerCase() + "_" + name, tier.getRepairTime());
        this.func_77625_d(10);
        this.tier = tier;
    }

    @Override
    public String getActionMessage() {
        return "Repairing";
    }

    @Override
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving.func_184218_aH() && entityLiving.func_184187_bx() instanceof EntityVehicle) {
            ((EntityVehicle)entityLiving.func_184187_bx()).repair(this.tier.getAmount());
            stack.func_190918_g(1);
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Time: " + this.tier.getRepairTime() + "s");
        tooltip.add("Amount: " + this.tier.getAmount() + "HP");
    }

    public static enum Tier {
        IRON(50, 80),
        GOLD(30, 60),
        DIAMOND(40, 150),
        EMERALD(25, 120),
        REDSTONE(10, 15),
        OBSIDIAN(90, 225);

        int repairTime;
        int amount;

        private Tier(int time, int amount) {
            this.repairTime = time;
            this.amount = amount;
        }

        public int getRepairTime() {
            return this.repairTime;
        }

        public int getAmount() {
            return this.amount;
        }
    }
}

