/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.items;

import dev.toma.vehiclemod.common.items.VMItem;
import dev.toma.vehiclemod.common.tunning.StatModifierType;
import dev.toma.vehiclemod.common.tunning.StatPackage;
import dev.toma.vehiclemod.util.DevUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemVehicleUpgrade
extends VMItem {
    private final Type type;
    private final int level;

    public ItemVehicleUpgrade(Type type, int level) {
        super(type.name().toLowerCase() + "_" + level);
        this.type = type;
        this.level = level;
        this.func_77625_d(1);
    }

    public Type getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Attributes:");
        this.type.getPackage().forEachModifier(mod -> mod.getType().addToTooltip(tooltip, mod.getValue(this.level - 1)));
    }

    public static enum Type {
        ENGINE(new StatPackage.Builder().attribute().type(StatModifierType.TOP_SPEED).values(0.04f, 0.07f, 0.1f, 0.15f, 0.2f, 0.25f, 0.3f).build().attribute().type(StatModifierType.FUEL_CONSUMPTION).values(-0.03f, -0.07f, -0.11f, -0.17f, -0.25f, -0.32f, -0.4f).build().createPackage()),
        TURBO(new StatPackage.Builder().attribute().type(StatModifierType.ACCELERATION).values(0.06f, 0.1f, 0.15f, 0.2f, 0.26f, 0.32f, 0.4f).build().attribute().type(StatModifierType.FUEL_CONSUMPTION).values(-0.02f, -0.04f, -0.06f, -0.1f, -0.15f, -0.2f, -0.25f).build().createPackage()),
        TRANSMISSION(new StatPackage.Builder().attribute().type(StatModifierType.TOP_SPEED).values(0.02f, 0.05f, 0.08f, 0.11f, 0.14f, 0.17f, 0.2f).build().attribute().type(StatModifierType.ACCELERATION).values(0.02f, 0.05f, 0.08f, 0.11f, 0.14f, 0.17f, 0.2f).build().createPackage()),
        ECU(new StatPackage.Builder().attribute().type(StatModifierType.TOP_SPEED).values(0.02f, 0.03f, 0.05f, 0.08f, 0.1f, 0.13f, 0.15f).build().attribute().type(StatModifierType.ACCELERATION).values(0.03f, 0.06f, 0.09f, 0.13f, 0.18f, 0.24f, 0.3f).build().attribute().type(StatModifierType.DURABILITY).values(-0.05f, -0.1f, -0.15f, -0.2f, -0.25f, -0.3f, -0.4f).build().createPackage()),
        FUEL_TANK(new StatPackage.Builder().attribute().type(StatModifierType.FUEL_CAPACITY).values(0.1f, 0.2f, 0.35f, 0.5f, 0.65f, 0.8f, 1.0f).build().createPackage()),
        BODY(new StatPackage.Builder().attribute().type(StatModifierType.DURABILITY).values(0.15f, 0.25f, 0.4f, 0.5f, 0.65f, 0.8f, 1.0f).build().attribute().type(StatModifierType.HANDLING).values(0.03f, 0.05f, 0.07f, 0.1f, 0.13f, 0.16f, 0.2f).build().createPackage()),
        SUSPENSION(new StatPackage.Builder().attribute().type(StatModifierType.HANDLING).values(0.05f, 0.1f, 0.15f, 0.21f, 0.27f, 0.33f, 0.4f).build().createPackage()),
        BRAKES(new StatPackage.Builder().attribute().type(StatModifierType.BRAKING).values(0.08f, 0.15f, 0.22f, 0.3f, 0.39f, 0.49f, 0.6f).build().createPackage()),
        TIRES(new StatPackage.Builder().attribute().type(StatModifierType.HANDLING).values(0.05f, 0.09f, 0.14f, 0.2f, 0.27f, 0.35f, 0.45f).build().attribute().type(StatModifierType.BRAKING).values(0.03f, 0.05f, 0.08f, 0.11f, 0.15f, 0.2f, 0.25f).build().createPackage());

        static final Map<Integer, EnumDyeColor> LEVEL_TO_COLOR_MAP;
        final StatPackage statPackage;
        final String niceName;

        private Type(StatPackage statPackage) {
            this.statPackage = statPackage;
            String[] words = this.name().toLowerCase().split("_");
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < words.length; ++i) {
                String word = words[i];
                boolean isLast = i == words.length - 1;
                builder.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
                if (isLast) continue;
                builder.append(" ");
            }
            this.niceName = builder.toString();
        }

        public String getNiceName() {
            return this.niceName;
        }

        public StatPackage getPackage() {
            return this.statPackage;
        }

        public static EnumDyeColor getColor(int level) {
            return DevUtil.getSafe(LEVEL_TO_COLOR_MAP, level, EnumDyeColor.BLACK);
        }

        static {
            LEVEL_TO_COLOR_MAP = DevUtil.make(new HashMap(), map -> {
                map.put(1, EnumDyeColor.GRAY);
                map.put(2, EnumDyeColor.YELLOW);
                map.put(3, EnumDyeColor.GREEN);
                map.put(4, EnumDyeColor.BLUE);
                map.put(5, EnumDyeColor.PURPLE);
                map.put(6, EnumDyeColor.ORANGE);
                map.put(7, EnumDyeColor.RED);
            });
        }
    }
}

