/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.tileentity;

import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.common.ILockpickable;
import dev.toma.vehiclemod.common.blocks.BlockMechanicPackage;
import dev.toma.vehiclemod.common.items.ItemPerk;
import dev.toma.vehiclemod.common.items.ItemVehicleUpgrade;
import dev.toma.vehiclemod.common.tileentity.TileEntityInventory;
import dev.toma.vehiclemod.network.packets.SPacketLockpickAttempt;
import dev.toma.vehiclemod.util.function.LazyLoad;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TileEntityMechanicPackage
extends TileEntityInventory
implements ILockpickable {
    private static final LazyLoad<Map<Integer, List<ItemVehicleUpgrade>>> tunningLoot = new LazyLoad<Map>(TileEntityMechanicPackage::loadTunningLoot);
    private static final LazyLoad<Map<Integer, List<ItemPerk>>> perkLoot = new LazyLoad<Map>(TileEntityMechanicPackage::loadPerkLoot);
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int[] combinations;

    public NBTTagCompound func_189517_E_() {
        return this.serializeNBT();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public void setInventory(NonNullList<ItemStack> inventory) {
        this.inventory = inventory;
    }

    @Override
    public String getKeyForName() {
        return "mechanic_package";
    }

    public void fill(BlockMechanicPackage.Variant variant) {
        if (!this.func_145837_r() && !this.field_145850_b.field_72995_K) {
            int i;
            float[] levelChances = variant.getLevelChances();
            Random random = VehicleMod.random;
            block0: for (int i2 = 0; i2 < variant.getPartCount(); ++i2) {
                float f = random.nextFloat();
                for (int j = 6; j >= 0; --j) {
                    float f1 = levelChances[j];
                    if (f <= f1) {
                        int level = j + 1;
                        List<ItemVehicleUpgrade> list = tunningLoot.get().get(level);
                        ItemVehicleUpgrade upgrade = list.get(random.nextInt(list.size()));
                        this.func_70299_a(i2, new ItemStack((Item)upgrade));
                        continue block0;
                    }
                    f -= f1;
                }
            }
            float f = random.nextFloat();
            for (i = 9; i > 6; --i) {
                float f1 = levelChances[i];
                if (f <= f1) {
                    int level = i - 7;
                    List<ItemPerk> list = perkLoot.get().get(level);
                    ItemPerk perk = list.get(random.nextInt(list.size()));
                    this.func_70299_a(2, new ItemStack((Item)perk));
                    break;
                }
                f -= f1;
            }
            this.combinations = new int[variant.getButtons()];
            for (i = 0; i < this.combinations.length; ++i) {
                this.combinations[i] = i;
            }
            ILockpickable.shuffle(this.combinations);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74783_a("combinations", this.combinations);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.combinations = compound.func_74759_k("combinations");
    }

    @Override
    public int[] getCombinations() {
        if (this.combinations.length == 0) {
            this.generateCombinations();
        }
        return this.combinations;
    }

    @Override
    public boolean shouldBreakLockpick(Random random) {
        return random.nextBoolean();
    }

    @Override
    public void handleUnlock(EntityPlayer player, World world) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            player.func_191521_c(stack.func_77946_l());
        }
        world.func_175655_b(this.field_174879_c, false);
    }

    @Override
    public SPacketLockpickAttempt createLockpickPacket(int index, int offset) {
        return SPacketLockpickAttempt.lockpickPackage(index, offset, this.func_174877_v());
    }

    static Map<Integer, List<ItemVehicleUpgrade>> loadTunningLoot() {
        List list = ForgeRegistries.ITEMS.getValuesCollection().stream().filter(i -> i instanceof ItemVehicleUpgrade).map(i -> (ItemVehicleUpgrade)((Object)i)).collect(Collectors.toList());
        HashMap<Integer, List<ItemVehicleUpgrade>> map = new HashMap<Integer, List<ItemVehicleUpgrade>>();
        for (ItemVehicleUpgrade upgrade : list) {
            map.computeIfAbsent(upgrade.getLevel(), i -> new ArrayList()).add(upgrade);
        }
        return map;
    }

    static Map<Integer, List<ItemPerk>> loadPerkLoot() {
        List perks = ForgeRegistries.ITEMS.getValuesCollection().stream().filter(i -> i instanceof ItemPerk).map(i -> (ItemPerk)((Object)i)).collect(Collectors.toList());
        HashMap<Integer, List<ItemPerk>> map = new HashMap<Integer, List<ItemPerk>>();
        for (ItemPerk perk : perks) {
            int index = TileEntityMechanicPackage.getPerkCategory(perk);
            map.computeIfAbsent(index, i -> new ArrayList()).add(perk);
        }
        return map;
    }

    static int getPerkCategory(ItemPerk perk) {
        String name = perk.getRegistryName().func_110623_a();
        if (name.contains("gold")) {
            return 2;
        }
        if (name.contains("silver")) {
            return 1;
        }
        return 0;
    }

    void generateCombinations() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockMechanicPackage) {
            BlockMechanicPackage.Variant variant = ((BlockMechanicPackage)state.func_177230_c()).getVariant();
            this.combinations = new int[variant.getButtons()];
            for (int i = 0; i < this.combinations.length; ++i) {
                this.combinations[i] = i;
            }
            ILockpickable.shuffle(this.combinations);
        } else {
            this.combinations = new int[1];
        }
    }
}

