/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.tileentity;

import dev.toma.vehiclemod.Registries;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.tileentity.TileEntityInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;

public class TileEntityPetrolPump
extends TileEntityInventory
implements ITickable {
    public static float CAPACITY = 1500.0f;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    public float storedAmount;
    @Nullable
    public EntityVehicle pairedVehicle;
    public boolean transfer;

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public void setInventory(NonNullList<ItemStack> inventory) {
        this.inventory = inventory;
    }

    @Override
    public String getKeyForName() {
        return "petrol_pump";
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("stored", this.storedAmount);
        compound.func_74757_a("transfer", this.transfer);
        if (this.pairedVehicle != null) {
            compound.func_74768_a("vehicleID", this.pairedVehicle.func_145782_y());
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        Entity entity;
        super.func_145839_a(compound);
        this.storedAmount = compound.func_74760_g("stored");
        this.transfer = compound.func_74767_n("transfer");
        if (this.field_145850_b == null) {
            return;
        }
        Entity entity2 = entity = compound.func_74764_b("vehicleID") ? this.field_145850_b.func_73045_a(compound.func_74762_e("vehicleID")) : null;
        if (entity instanceof EntityVehicle) {
            this.pairedVehicle = (EntityVehicle)entity;
        }
    }

    public void func_73660_a() {
        if (this.func_70301_a(0).func_77973_b() == Registries.VMItems.BUCKET_OF_FUEL && this.storedAmount < CAPACITY && this.func_70301_a(1).func_190916_E() < 16) {
            this.func_70301_a(0).func_190918_g(1);
            this.func_70299_a(1, new ItemStack(Items.field_151133_ar, this.func_70301_a(1).func_190916_E() + 1));
            this.storedAmount = Math.min(CAPACITY, this.storedAmount + 10.0f);
        }
        if (this.pairedVehicle != null) {
            if (this.canReach()) {
                if (this.transfer && this.pairedVehicle.fuel < (float)this.pairedVehicle.getActualStats().fuelCapacity && this.storedAmount > 0.0f) {
                    this.pairedVehicle.fuel += 0.1f;
                    this.storedAmount -= 0.1f;
                } else {
                    this.transfer = false;
                }
            } else {
                this.pairedVehicle = null;
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_73046_m().func_184103_al().func_181057_v().forEach(entityPlayerMP -> entityPlayerMP.field_71135_a.func_147359_a((Packet)this.func_189518_D_()));
                }
            }
        }
    }

    public void pair(EnumFacing facing) {
        BlockPos pos = this.func_174877_v().func_177967_a(facing, 2);
        this.pairedVehicle = this.nearestVehicle(pos);
    }

    @Nullable
    private EntityVehicle nearestVehicle(BlockPos pos) {
        List list = this.func_145831_w().func_72872_a(EntityVehicle.class, Block.field_185505_j.func_186670_a(pos).func_186662_g(2.0));
        double latest = Double.MAX_VALUE;
        EntityVehicle vehicle = null;
        for (EntityVehicle v : list) {
            double d = this.distanceTo(v, pos);
            if (!(d < latest) || !(d < 3.0)) continue;
            latest = d;
            vehicle = v;
        }
        return vehicle;
    }

    private double distanceTo(Entity entity, BlockPos pos) {
        return Math.sqrt(this.sqr(entity.field_70165_t - (double)pos.func_177958_n() + 0.5) + this.sqr(entity.field_70161_v - (double)pos.func_177952_p() + 0.5));
    }

    private double sqr(double val) {
        return val * val;
    }

    private boolean canReach() {
        double dist = this.distanceTo(this.pairedVehicle, this.field_174879_c);
        return dist < 5.0;
    }
}

