/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.tileentity;

import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.common.ILockpickable;
import dev.toma.vehiclemod.common.items.ITunerPackageEntry;
import dev.toma.vehiclemod.common.tileentity.TileEntityInventory;
import dev.toma.vehiclemod.network.packets.SPacketLockpickAttempt;
import dev.toma.vehiclemod.util.ArgWeightedRandom;
import dev.toma.vehiclemod.util.function.LazyLoad;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TileEntityTunerPackage
extends TileEntityInventory
implements ILockpickable {
    private static final LazyLoad<IntHashMap<Map<ITunerPackageEntry.Category, List<Item>>>> LOOT_POOL = new LazyLoad<IntHashMap>(TileEntityTunerPackage::genLootPool);
    private static final ArgWeightedRandom<ITunerPackageEntry.Category, Integer> CATEGORIES = new ArgWeightedRandom<ITunerPackageEntry.Category, Integer>(ITunerPackageEntry.Category::getChance, ITunerPackageEntry.Category.values());
    private int[] combinations;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);

    public void fill(int tier) {
        if (!this.func_145837_r() && !this.field_145850_b.field_72995_K) {
            int i;
            for (i = 0; i < 2; ++i) {
                ITunerPackageEntry.Category category = CATEGORIES.getRandom(tier);
                List pool = ((Map)LOOT_POOL.get().func_76041_a(tier)).getOrDefault((Object)category, Collections.emptyList());
                if (pool.isEmpty()) {
                    VehicleMod.logger.error("Found empty loot pool (T:{},C:{})", (Object)tier, (Object)category);
                    continue;
                }
                Item item = (Item)TileEntityTunerPackage.getRandom(pool, VehicleMod.random);
                this.func_70299_a(i, new ItemStack(item));
            }
            this.combinations = new int[6 + tier];
            for (i = 0; i < this.combinations.length; ++i) {
                this.combinations[i] = i;
            }
            ILockpickable.shuffle(this.combinations);
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.serializeNBT();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public void setInventory(NonNullList<ItemStack> inventory) {
        this.inventory = inventory;
    }

    @Override
    public String getKeyForName() {
        return "tuner_package";
    }

    @Override
    public int[] getCombinations() {
        return this.combinations;
    }

    @Override
    public SPacketLockpickAttempt createLockpickPacket(int index, int offset) {
        return SPacketLockpickAttempt.lockpickPackage(index, offset, this.field_174879_c);
    }

    @Override
    public void handleUnlock(EntityPlayer player, World world) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            player.func_191521_c(stack.func_77946_l());
        }
        world.func_175655_b(this.field_174879_c, false);
    }

    @Override
    public boolean shouldBreakLockpick(Random random) {
        return random.nextBoolean();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74783_a("combinations", this.combinations);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.combinations = compound.func_74759_k("combinations");
    }

    static <I extends Item> IntHashMap<Map<ITunerPackageEntry.Category, List<Item>>> genLootPool() {
        List items = ForgeRegistries.ITEMS.getValuesCollection().stream().filter(item -> item instanceof ITunerPackageEntry).map(it -> it).collect(Collectors.toList());
        IntHashMap lootPool = new IntHashMap();
        for (Item i : items) {
            int tier = ((ITunerPackageEntry)i).getTier();
            ITunerPackageEntry.Category category = ((ITunerPackageEntry)i).getCategory();
            TileEntityTunerPackage.lookup(lootPool, tier, HashMap::new).computeIfAbsent(category, cat -> new ArrayList()).add(i);
        }
        return lootPool;
    }

    static <T> T lookup(IntHashMap<T> map, int hashEntry, Supplier<T> factory) {
        Object t = map.func_76041_a(hashEntry);
        if (t == null) {
            t = factory.get();
            map.func_76038_a(hashEntry, t);
        }
        return (T)t;
    }

    static <T> T getRandom(List<T> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }
}

