/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.tunning;

import dev.toma.vehiclemod.common.tunning.IStatApplicator;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class StatModifierType {
    public static final StatModifierType TOP_SPEED = StatModifierType.create("Top speed", IStatApplicator.TOP_SPEED);
    public static final StatModifierType ACCELERATION = StatModifierType.create("Acceleration", IStatApplicator.ACCELERATION);
    public static final StatModifierType BRAKING = StatModifierType.create("Braking", IStatApplicator.BRAKING);
    public static final StatModifierType HANDLING = StatModifierType.create("Handling", IStatApplicator.HANDLING);
    public static final StatModifierType DURABILITY = StatModifierType.create("Durability", IStatApplicator.DURABILITY);
    public static final StatModifierType FUEL_CONSUMPTION = StatModifierType.create("Fuel consumption", IStatApplicator.FUEL_CONSUMPTION, true);
    public static final StatModifierType FUEL_CAPACITY = StatModifierType.create("Fuel capacity", IStatApplicator.FUEL_CAPACITY);
    public static final StatModifierType NITRO_POWER = StatModifierType.create("Nitro power", IStatApplicator.NITRO_PW);
    final String name;
    final IStatApplicator applicator;
    final boolean isBad;

    public static StatModifierType create(String name, IStatApplicator applicator) {
        return StatModifierType.create(name, applicator, false);
    }

    public static StatModifierType create(String name, IStatApplicator applicator, boolean isBad) {
        return new StatModifierType(name, applicator, isBad);
    }

    StatModifierType(String name, IStatApplicator applicator, boolean isBad) {
        this.name = name;
        this.applicator = applicator;
        this.isBad = isBad;
    }

    public void addToTooltip(List<String> tooltips, float value) {
        boolean flag;
        boolean bl = flag = value > 0.0f;
        if (this.isBad) {
            int v = -((int)(value * 100.0f));
            tooltips.add(this.getName() + ": " + (v > 0 ? TextFormatting.RED : TextFormatting.GREEN) + (flag ? "" : "+") + v + "%");
        } else {
            int v = (int)(value * 100.0f);
            tooltips.add(this.getName() + ": " + (v > 0 ? TextFormatting.GREEN : TextFormatting.RED) + (flag ? "+" : "") + v + "%");
        }
    }

    public IStatApplicator getApplicator() {
        return this.applicator;
    }

    public String getName() {
        return this.name;
    }
}

