/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.common.world;

import dev.toma.vehiclemod.Registries;
import dev.toma.vehiclemod.common.blocks.BlockMechanicPackage;
import dev.toma.vehiclemod.common.blocks.BlockTunerPackage;
import dev.toma.vehiclemod.common.tileentity.TileEntityMechanicPackage;
import dev.toma.vehiclemod.common.tileentity.TileEntityTunerPackage;
import dev.toma.vehiclemod.config.VMConfig;
import dev.toma.vehiclemod.util.DevUtil;
import dev.toma.vehiclemod.util.WeightedRandom;
import dev.toma.vehiclemod.util.function.LazyLoad;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class PackageGenerator
implements IWorldGenerator {
    private static final LazyLoad<IntHashMap<BlockTunerPackage>> TIER_TO_BLOCK_MAP = new LazyLoad<IntHashMap>(() -> DevUtil.make(new IntHashMap(), map -> {
        map.func_76038_a(0, (Object)Registries.VMBlocks.BRONZE_TUNER_PACKAGE);
        map.func_76038_a(1, (Object)Registries.VMBlocks.SILVER_TUNER_PACKAGE);
        map.func_76038_a(2, (Object)Registries.VMBlocks.GOLDEN_TUNER_PACKAGE);
        map.func_76038_a(3, (Object)Registries.VMBlocks.PLATINUM_TUNER_PACKAGE);
    }));
    public static final WeightedRandom<BlockMechanicPackage.Variant> VARIANT = new WeightedRandom<BlockMechanicPackage.Variant>(BlockMechanicPackage.Variant::getSpawnChance, BlockMechanicPackage.Variant.values());
    public static final WeightedRandom<PackageSpawner> PACKAGE = new WeightedRandom.NullableWeightedRandom<PackageSpawner>(PackageSpawner::getChance, new PackageSpawner[]{new PackageSpawner(VMConfig.worldConfig.mechanicPackageSpawnChance, (pos, world, random) -> {
        BlockMechanicPackage.Variant variant = VARIANT.getRandom();
        world.func_180501_a(pos, variant.getPackage().func_176223_P(), 18);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMechanicPackage) {
            ((TileEntityMechanicPackage)tileEntity).fill(variant);
        }
    }), new PackageSpawner(VMConfig.worldConfig.tunerPackageSpawnChance, (pos, world, random) -> {
        int tier = VARIANT.getRandom().ordinal();
        IBlockState state = ((BlockTunerPackage)((Object)((Object)TIER_TO_BLOCK_MAP.get().func_76041_a(tier)))).func_176223_P();
        world.func_180501_a(pos, state, 18);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityTunerPackage) {
            ((TileEntityTunerPackage)tileEntity).fill(tier);
        }
    })}, total -> Float.valueOf(1.0f - (float)total.intValue() / 100.0f));

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        int y;
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        PackageSpawner spawner = PACKAGE.getRandom();
        if (spawner == null) {
            return;
        }
        int x = (chunkX << 4) + random.nextInt(16);
        BlockPos pos = new BlockPos(x, y = world.func_189649_b(x, z = (chunkZ << 4) + random.nextInt(16)), z);
        Material material = world.func_180495_p(pos.func_177977_b()).func_185904_a();
        if (material == Material.field_151584_j) {
            pos = PackageGenerator.findGround(world, pos);
            material = world.func_180495_p(pos.func_177977_b()).func_185904_a();
        }
        if (!DevUtil.MATERIAL_VALIDATOR.test(material)) {
            return;
        }
        spawner.getGenerator().runGenerator(pos, world, random);
    }

    static BlockPos findGround(World world, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(pos);
        while (mutableBlockPos.func_177956_o() > 1) {
            mutableBlockPos.func_185336_p(mutableBlockPos.func_177956_o() - 1);
            BlockPos down = mutableBlockPos.func_177977_b();
            if (world.func_175623_d(down) || world.func_180495_p(down).func_185904_a() == Material.field_151584_j) continue;
            break;
        }
        return mutableBlockPos.func_185334_h();
    }

    public static interface Generator {
        public void runGenerator(BlockPos var1, World var2, Random var3);
    }

    public static class PackageSpawner {
        private final int chance;
        private final Generator generator;

        public PackageSpawner(int chance, Generator generator) {
            this.chance = chance;
            this.generator = generator;
        }

        public int getChance() {
            return this.chance;
        }

        public Generator getGenerator() {
            return this.generator;
        }
    }
}

