/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.config;

import dev.toma.vehiclemod.common.items.ItemPerk;
import dev.toma.vehiclemod.common.items.ItemVehicleUpgrade;
import dev.toma.vehiclemod.common.tunning.StatModifier;
import dev.toma.vehiclemod.common.tunning.StatModifierType;
import dev.toma.vehiclemod.common.tunning.StatPackage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class VehicleStats {
    @Config.Ignore
    public static float topSpeedMin = 500.0f;
    @Config.Ignore
    public static float topSpeedMax;
    @Config.Ignore
    public static float accelerationMin;
    @Config.Ignore
    public static float accelerationMax;
    @Config.Ignore
    public static float handlingMin;
    @Config.Ignore
    public static float handlingMax;
    @Config.Ignore
    public static float brakingMin;
    @Config.Ignore
    public static float brakingMax;
    @Config.Ignore
    protected static List<VehicleStats> trackingList;
    @Config.Name(value="Max Health")
    @Config.RequiresMcRestart
    public float maxHealth;
    @Config.Name(value="Max Speed")
    @Config.RequiresMcRestart
    public float maxSpeed;
    @Config.Name(value="Acceleration")
    @Config.RequiresMcRestart
    public float acceleration;
    @Config.Name(value="Turning Speed")
    @Config.RequiresMcRestart
    public float turnSpeed;
    @Config.Name(value="Max Turning Angle")
    @Config.RequiresMcRestart
    public float maxTurningAngle;
    @Config.Name(value="Braking Speed")
    @Config.RequiresMcRestart
    public float brakeSpeed;
    @Config.Name(value="Fuel Consumption")
    @Config.RequiresMcRestart
    public float fuelConsumption;
    @Config.Name(value="Fuel Capacity")
    @Config.RangeInt(min=10)
    @Config.RequiresMcRestart
    public int fuelCapacity;
    @Config.Name(value="TPP Camera Offset")
    public Vector3i cameraOff;

    public VehicleStats(float maxHP, float maxSpeed, float acceleration, float brakeSpeed, float turningSpeed, float maxAngle, float fuelConsumption, int capacity, Vector3i offset) {
        this.maxHealth = maxHP;
        this.maxSpeed = maxSpeed;
        this.acceleration = acceleration;
        this.turnSpeed = turningSpeed;
        this.maxTurningAngle = maxAngle;
        this.brakeSpeed = brakeSpeed;
        this.fuelConsumption = fuelConsumption;
        this.fuelCapacity = capacity;
        this.cameraOff = offset;
    }

    public VehicleStats(float maxHP, float maxSpeed, float acceleration, float brakeSpeed, float turningSpeed, float maxAngle, float fuelConsumption, int capacity) {
        this(maxHP, maxSpeed, acceleration, brakeSpeed, turningSpeed, maxAngle, fuelConsumption, capacity, new Vector3i(0, 0, 0));
    }

    public VehicleStats track() {
        trackingList.add(this);
        this.calculateRanges();
        return this;
    }

    public static void initiateValueRefresh() {
        topSpeedMin = 500.0f;
        accelerationMin = 500.0f;
        handlingMin = 500.0f;
        brakingMin = 500.0f;
        topSpeedMax = 0.0f;
        accelerationMax = 0.0f;
        handlingMax = 0.0f;
        brakingMax = 0.0f;
        trackingList.forEach(VehicleStats::calculateRanges);
    }

    private void calculateRanges() {
        List<ItemPerk> perks = ForgeRegistries.ITEMS.getValuesCollection().stream().filter(it -> it instanceof ItemPerk && it.getRegistryName().func_110623_a().contains("gold")).map(i -> (ItemPerk)((Object)i)).collect(Collectors.toList());
        float f0 = VehicleStats.getTotalModifierWith(StatModifierType.TOP_SPEED, perks);
        if (this.maxSpeed < topSpeedMin) {
            topSpeedMin = this.maxSpeed;
        } else if (this.maxSpeed * f0 > topSpeedMax) {
            topSpeedMax = this.maxSpeed * f0;
        }
        float f1 = VehicleStats.getTotalModifierWith(StatModifierType.ACCELERATION, perks);
        if (this.acceleration < accelerationMin) {
            accelerationMin = this.acceleration;
        } else if (this.acceleration * f1 > accelerationMax) {
            accelerationMax = this.acceleration * f1;
        }
        float f2 = VehicleStats.getTotalModifierWith(StatModifierType.HANDLING, perks);
        if (this.turnSpeed < handlingMin) {
            handlingMin = this.turnSpeed;
        } else if (this.turnSpeed * f2 > handlingMax) {
            handlingMax = this.turnSpeed * f2;
        }
        float f3 = VehicleStats.getTotalModifierWith(StatModifierType.BRAKING, perks);
        if (this.brakeSpeed < brakingMin) {
            brakingMin = this.brakeSpeed;
        } else if (this.brakeSpeed * f3 > brakingMax) {
            brakingMax = this.brakeSpeed * f3;
        }
    }

    private static float getTotalModifierWith(StatModifierType modifierType, List<ItemPerk> perks) {
        float f = 1.0f;
        for (ItemVehicleUpgrade.Type type : ItemVehicleUpgrade.Type.values()) {
            StatPackage statPackage = type.getPackage();
            for (StatModifier modifier : statPackage.getModifiers()) {
                if (modifier.getType() != modifierType) continue;
                f += modifier.getValue(6);
            }
        }
        for (ItemPerk perk : perks) {
            if (perk.getModifierType() != modifierType) continue;
            f += perk.getValue() * 3.0f;
        }
        return f;
    }

    static {
        accelerationMin = 500.0f;
        handlingMin = 500.0f;
        brakingMin = 500.0f;
        trackingList = new ArrayList<VehicleStats>();
    }

    public static class Vector3i {
        @Config.Name(value="X")
        public int x;
        @Config.Name(value="Y")
        public int y;
        @Config.Name(value="Z")
        public int z;

        public Vector3i(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public void toBuffer(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
        }

        public void fromBuffer(ByteBuf buf) {
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
        }
    }
}

