/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.network.packets;

import dev.toma.vehiclemod.client.CarSound;
import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.ISpecialVehicle;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CPacketSendSpecialVehicleStatus
implements IMessage {
    EnumState state;
    int entityID;

    public CPacketSendSpecialVehicleStatus() {
    }

    public <V extends EntityVehicle> CPacketSendSpecialVehicleStatus(EnumState state, V vehicle) {
        this.state = state;
        this.entityID = vehicle.func_145782_y();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.state.ordinal());
        buf.writeInt(this.entityID);
    }

    public void fromBytes(ByteBuf buf) {
        this.state = EnumState.values()[buf.readInt()];
        this.entityID = buf.readInt();
    }

    public static enum EnumState {
        START_TRACKING,
        STOP_TRACKING;

    }

    public static class Handler
    implements IMessageHandler<CPacketSendSpecialVehicleStatus, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(CPacketSendSpecialVehicleStatus message, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> {
                WorldClient world = mc.field_71441_e;
                Entity entity = world.func_73045_a(message.entityID);
                if (entity instanceof ISpecialVehicle) {
                    ISpecialVehicle vehicle = (ISpecialVehicle)entity;
                    SoundHandler handler = mc.func_147118_V();
                    switch (message.state) {
                        case START_TRACKING: {
                            CarSound sound = vehicle.getPlayingSound();
                            if (sound != null) {
                                handler.func_147683_b((ISound)sound);
                            }
                            if (!vehicle.isEffectActive()) break;
                            CarSound sirenSound = new CarSound(vehicle.getSpecialEffectSound(), (EntityVehicle)((Object)vehicle));
                            vehicle.setPlayingSound(sirenSound);
                            handler.func_147682_a((ISound)sirenSound);
                            break;
                        }
                        case STOP_TRACKING: {
                            CarSound actualSound = vehicle.getPlayingSound();
                            if (actualSound != null) {
                                handler.func_147683_b((ISound)actualSound);
                            }
                            vehicle.setPlayingSound(null);
                        }
                    }
                }
            });
            return null;
        }
    }
}

