/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.network.packets;

import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.EnumVehicleState;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CPacketVehicleData
implements IMessage {
    private int vehicleID;
    private float currentSpeed;
    private float turnModifier;
    private float health;
    private float fuel;
    private EnumVehicleState state;

    public CPacketVehicleData() {
    }

    public CPacketVehicleData(EntityVehicle vehicle) {
        this.vehicleID = vehicle.func_145782_y();
        this.currentSpeed = vehicle.currentSpeed;
        this.turnModifier = vehicle.turnModifier;
        this.health = vehicle.health;
        this.fuel = vehicle.fuel;
        this.state = vehicle.currentState;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.vehicleID);
        buf.writeFloat(this.currentSpeed);
        buf.writeFloat(this.turnModifier);
        buf.writeFloat(this.health);
        buf.writeFloat(this.fuel);
        buf.writeInt(this.state.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        this.vehicleID = buf.readInt();
        this.currentSpeed = buf.readFloat();
        this.turnModifier = buf.readFloat();
        this.health = buf.readFloat();
        this.fuel = buf.readFloat();
        this.state = EnumVehicleState.values()[buf.readInt()];
    }

    public static class Handler
    implements IMessageHandler<CPacketVehicleData, IMessage> {
        public IMessage onMessage(CPacketVehicleData message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                Minecraft.func_71410_x().func_152344_a(() -> Handler.handle(message));
            }
            return null;
        }

        public static void handle(CPacketVehicleData p) {
            World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
            Entity e = world.func_73045_a(p.vehicleID);
            if (e != null && e instanceof EntityVehicle) {
                EntityVehicle car = (EntityVehicle)e;
                car.currentSpeed = p.currentSpeed;
                car.turnModifier = p.turnModifier;
                car.health = p.health;
                car.fuel = p.fuel;
                car.currentState = p.state;
            }
        }
    }
}

