/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.network.packets;

import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import dev.toma.vehiclemod.common.entity.vehicle.LightController;
import dev.toma.vehiclemod.network.VMNetworkManager;
import dev.toma.vehiclemod.network.packets.CPacketSendLightStatus;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SPacketChangeLightStatus
implements IMessage {
    EnumAction action;
    int entityID;
    boolean state;
    LightController.TurnLightStatus status;

    public SPacketChangeLightStatus() {
    }

    private SPacketChangeLightStatus(EnumAction action, EntityVehicle vehicle, boolean state, LightController.TurnLightStatus status) {
        this.action = action;
        this.entityID = vehicle.func_145782_y();
        this.state = state;
        this.status = status;
    }

    public static SPacketChangeLightStatus headlights(EntityVehicle vehicle, boolean state) {
        return new SPacketChangeLightStatus(EnumAction.HEADLIGHTS, vehicle, state, null);
    }

    public static SPacketChangeLightStatus turnStatus(EntityVehicle vehicle, LightController.TurnLightStatus status) {
        return new SPacketChangeLightStatus(EnumAction.INDICATOR, vehicle, false, status);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.entityID);
        switch (this.action) {
            case HEADLIGHTS: {
                buf.writeBoolean(this.state);
                break;
            }
            case INDICATOR: {
                buf.writeInt(this.status.ordinal());
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.action = EnumAction.values()[buf.readInt()];
        this.entityID = buf.readInt();
        switch (this.action) {
            case HEADLIGHTS: {
                this.state = buf.readBoolean();
                break;
            }
            case INDICATOR: {
                this.status = LightController.TurnLightStatus.values()[buf.readInt()];
            }
        }
    }

    static enum EnumAction {
        HEADLIGHTS,
        INDICATOR;

    }

    public static class Handler
    implements IMessageHandler<SPacketChangeLightStatus, IMessage> {
        public IMessage onMessage(SPacketChangeLightStatus message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> {
                WorldServer server = player.func_71121_q();
                Entity entity = server.func_73045_a(message.entityID);
                if (entity instanceof EntityVehicle) {
                    LightController controller = ((EntityVehicle)entity).lightController;
                    switch (message.action) {
                        case HEADLIGHTS: {
                            controller.setLightState(message.state);
                            break;
                        }
                        case INDICATOR: {
                            controller.setTurnLightStatus(message.status);
                        }
                    }
                    VMNetworkManager.instance().sendToAllTracking((IMessage)new CPacketSendLightStatus(message.entityID, controller.serializeNBT()), entity);
                }
            });
            return null;
        }
    }
}

