/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.network.packets;

import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.common.blocks.fuel.TileEntityFuelMaker;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SPacketFuelMakerAction
implements IMessage {
    private BlockPos pos;
    private int actionID;
    private boolean shiftClick;

    public SPacketFuelMakerAction() {
    }

    public SPacketFuelMakerAction(BlockPos pos, int actionID, boolean shiftClick) {
        this.pos = pos;
        this.actionID = actionID;
        this.shiftClick = shiftClick;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.actionID);
        buf.writeBoolean(this.shiftClick);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.actionID = buf.readInt();
        this.shiftClick = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<SPacketFuelMakerAction, IMessage> {
        public IMessage onMessage(SPacketFuelMakerAction message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> {
                WorldServer server = player.func_71121_q();
                if (!server.func_175667_e(message.pos)) {
                    return;
                }
                TileEntity te = server.func_175625_s(message.pos);
                if (te instanceof TileEntityFuelMaker) {
                    TileEntityFuelMaker fuelMaker = (TileEntityFuelMaker)te;
                    try {
                        fuelMaker.runAction(message.actionID, message.shiftClick);
                    }
                    catch (IllegalArgumentException ex) {
                        VehicleMod.logger.fatal("Received invalid FuelMaker packet from " + player.func_70005_c_());
                        player.field_71135_a.func_194028_b((ITextComponent)new TextComponentString("You sent invalid FuelMaker packet"));
                    }
                }
            });
            return null;
        }
    }
}

