/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.network.packets;

import dev.toma.vehiclemod.Registries;
import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.common.ILockpickable;
import dev.toma.vehiclemod.init.VMSounds;
import dev.toma.vehiclemod.util.DateTimeHelper;
import io.netty.buffer.ByteBuf;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SPacketLockpickAttempt
implements IMessage {
    private LockpickType type;
    private int index;
    private int offset;
    private BlockPos pos;
    private int vehicleID;

    public SPacketLockpickAttempt() {
    }

    private SPacketLockpickAttempt(LockpickType type, int index, int offset, BlockPos pos) {
        this.type = type;
        this.index = index;
        this.offset = offset;
        this.pos = pos;
    }

    private SPacketLockpickAttempt(LockpickType type, int index, int offset, int id) {
        this.type = type;
        this.index = index;
        this.offset = offset;
        this.vehicleID = id;
    }

    public static SPacketLockpickAttempt lockpickPackage(int index, int offset, BlockPos pos) {
        return new SPacketLockpickAttempt(LockpickType.PACKAGE, index, offset, pos);
    }

    public static SPacketLockpickAttempt lockpickVehicle(int index, int offset, int vehicleID) {
        return new SPacketLockpickAttempt(LockpickType.VEHICLE, index, offset, vehicleID);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.index);
        buf.writeInt(this.offset);
        switch (this.type) {
            case PACKAGE: {
                buf.writeInt(this.pos.func_177958_n());
                buf.writeInt(this.pos.func_177956_o());
                buf.writeInt(this.pos.func_177952_p());
                break;
            }
            case VEHICLE: {
                buf.writeInt(this.vehicleID);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.type = LockpickType.values()[buf.readInt()];
        this.index = buf.readInt();
        this.offset = buf.readInt();
        switch (this.type) {
            case PACKAGE: {
                this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
                break;
            }
            case VEHICLE: {
                this.vehicleID = buf.readInt();
            }
        }
    }

    public static enum LockpickType {
        PACKAGE((msg, world) -> {
            BlockPos pos = ((SPacketLockpickAttempt)msg).pos;
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof ILockpickable) {
                return (ILockpickable)tileEntity;
            }
            return null;
        }),
        VEHICLE((msg, world) -> {
            int id = ((SPacketLockpickAttempt)msg).vehicleID;
            Entity entity = world.func_73045_a(id);
            if (entity instanceof ILockpickable) {
                return (ILockpickable)entity;
            }
            return null;
        });

        private final BiFunction<SPacketLockpickAttempt, World, ILockpickable> function;

        private LockpickType(BiFunction<SPacketLockpickAttempt, World, ILockpickable> function) {
            this.function = function;
        }

        public ILockpickable get(SPacketLockpickAttempt msg, World world) {
            return this.function.apply(msg, world);
        }
    }

    public static class Handler
    implements IMessageHandler<SPacketLockpickAttempt, IMessage> {
        public IMessage onMessage(SPacketLockpickAttempt message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> {
                if (player.func_184614_ca().func_77973_b() != Registries.VMItems.LOCKPICK) {
                    player.func_71053_j();
                    return;
                }
                World world = player.field_70170_p;
                ILockpickable lockpickable = message.type.get(message, world);
                if (lockpickable == null) {
                    player.func_71053_j();
                    return;
                }
                int[] combinations = lockpickable.getCombinations();
                if (combinations == null) {
                    player.func_71053_j();
                    return;
                }
                int offset = message.offset;
                if (offset < 0 || offset >= combinations.length) {
                    return;
                }
                int correct = combinations[offset];
                int pressed = message.index;
                if (correct != pressed) {
                    player.func_71053_j();
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, DateTimeHelper.isAprilFools() ? VMSounds.LOCKPICK_FAILED_AF : VMSounds.LOCKPICK_FAILED, SoundCategory.MASTER, 1.0f, 1.0f);
                    if (lockpickable.shouldBreakLockpick(VehicleMod.random)) {
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187635_cQ, SoundCategory.MASTER, 1.0f, 1.0f);
                        player.func_184614_ca().func_190918_g(1);
                    }
                } else if (message.offset == combinations.length - 1) {
                    player.func_71053_j();
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, VMSounds.LOCK_UNLOCKED, SoundCategory.MASTER, 1.0f, 1.0f);
                    lockpickable.handleUnlock((EntityPlayer)player, world);
                } else {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, VMSounds.LOCKPICK_SUCCESS, SoundCategory.MASTER, 1.0f, 1.0f);
                }
            });
            return null;
        }
    }
}

