/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.network.packets;

import dev.toma.vehiclemod.common.entity.vehicle.EntityVehicle;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SPacketVehicleAction
implements IMessage {
    Action action;
    boolean eco;
    int nitroSlot;

    public SPacketVehicleAction() {
    }

    public SPacketVehicleAction(Action action, boolean eco, int nitroSlot) {
        this.action = action;
        this.eco = eco;
        this.nitroSlot = nitroSlot;
    }

    public static SPacketVehicleAction start() {
        return new SPacketVehicleAction(Action.START, false, 0);
    }

    public static SPacketVehicleAction eco(boolean state) {
        return new SPacketVehicleAction(Action.ECO, state, 0);
    }

    public static SPacketVehicleAction nitro(int slotID) {
        return new SPacketVehicleAction(Action.NITRO, false, slotID);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        switch (this.action) {
            case ECO: {
                buf.writeBoolean(this.eco);
                break;
            }
            case NITRO: {
                buf.writeInt(this.nitroSlot);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.action = Action.values()[buf.readInt()];
        switch (this.action) {
            case ECO: {
                this.eco = buf.readBoolean();
                break;
            }
            case NITRO: {
                this.nitroSlot = buf.readInt();
            }
        }
    }

    public static enum Action {
        START,
        ECO,
        NITRO;

    }

    public static class Handler
    implements IMessageHandler<SPacketVehicleAction, IMessage> {
        public IMessage onMessage(SPacketVehicleAction message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> {
                WorldServer server = player.func_71121_q();
                Entity entity = player.func_184187_bx();
                if (entity instanceof EntityVehicle && entity.func_184179_bs() == player) {
                    EntityVehicle vehicle = (EntityVehicle)entity;
                    switch (message.action) {
                        case START: {
                            if (vehicle.getStartCooldown() != 0 || vehicle.isStarted()) break;
                            vehicle.initiateStart();
                            vehicle.sync();
                            break;
                        }
                        case ECO: {
                            vehicle.setEcoMode(message.eco);
                            vehicle.sync();
                            break;
                        }
                        case NITRO: {
                            vehicle.getNitroHandler().initiateUse((Entity)player, message.nitroSlot);
                        }
                    }
                }
            });
            return null;
        }
    }
}

