/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;

public class ArgWeightedRandom<T, P> {
    protected static Random random = new Random();
    protected final T[] values;
    protected final BiFunction<T, P, Integer> toIntFunction;
    private final Map<P, Integer> cache;

    public ArgWeightedRandom(BiFunction<T, P, Integer> toIntFunction, T[] values) {
        this.toIntFunction = toIntFunction;
        this.values = values;
        this.cache = new HashMap<P, Integer>();
    }

    public T getRandom(P in) {
        int total = this.getTotalValue(in);
        int weight = random.nextInt(total);
        for (int idx = this.values.length - 1; idx >= 0; --idx) {
            T t = this.values[idx];
            if ((weight -= this.toIntFunction.apply(t, in).intValue()) >= 0) continue;
            return t;
        }
        return null;
    }

    private int getTotalValue(P p) {
        Integer integer = this.cache.get(p);
        if (integer == null) {
            int res = this.gatherAll(p);
            this.cache.put(p, res);
            return res;
        }
        return integer;
    }

    private int gatherAll(P p) {
        int i = 0;
        for (T t : this.values) {
            i += this.toIntFunction.apply(t, p).intValue();
        }
        return i;
    }
}

