/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.vehiclemod.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.toma.vehiclemod.VehicleMod;
import dev.toma.vehiclemod.common.items.ItemVehicleUpgrade;
import dev.toma.vehiclemod.util.function.ComparableFunction;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class DevUtil {
    private static final ModelCreator CREATOR = new ModelCreator();
    public static final Predicate<Material> MATERIAL_VALIDATOR = mat -> mat == Material.field_151578_c || mat == Material.field_151577_b || mat == Material.field_151595_p || mat == Material.field_151576_e;

    public static ModelCreator creator() {
        return CREATOR;
    }

    public static <E extends Enum<E>> E getEnumFromNBT(String key, NBTTagCompound nbt, Class<E> eClass) {
        Enum[] es = (Enum[])eClass.getEnumConstants();
        return (E)(nbt.func_150297_b(key, 3) ? es[MathHelper.func_76125_a((int)nbt.func_74762_e(key), (int)0, (int)(es.length - 1))] : es[0]);
    }

    public static float[] getRGB(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public static float[] getRGBA(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b, a};
    }

    public static <K, V> V getSafe(Map<K, V> map, K key, V fallback) {
        V v = map.get(key);
        return v != null ? v : fallback;
    }

    public static <T> T make(T t, Consumer<T> consumer) {
        consumer.accept(t);
        return t;
    }

    public static <T> boolean contains(T t, T[] array, ComparableFunction<T> function) {
        for (T entry : array) {
            if (!function.compare(t, entry)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T t, Collection<T> collection, ComparableFunction<T> function) {
        for (T entry : collection) {
            if (!function.compare(t, entry)) continue;
            return true;
        }
        return false;
    }

    public static NBTTagList inventoryToNBT(IInventory inventory) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("index", i);
            compound.func_74782_a("item", (NBTBase)stack.serializeNBT());
            list.func_74742_a((NBTBase)compound);
        }
        return list;
    }

    public static NBTTagCompound inventoryToNBTCompound(IInventory inventory) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("inventory", (NBTBase)DevUtil.inventoryToNBT(inventory));
        return compound;
    }

    public static void loadInventoryFromNBT(IInventory inventory, NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            int index = nbt.func_74762_e("index");
            ItemStack stack = new ItemStack(nbt.func_74775_l("item"));
            inventory.func_70299_a(index, stack);
        }
    }

    public static void loadInventoryFromNBTCompound(IInventory inventory, NBTTagCompound compound) {
        if (compound.func_150297_b("inventory", 9)) {
            DevUtil.loadInventoryFromNBT(inventory, compound.func_150295_c("inventory", 10));
        }
    }

    public static boolean isDev() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    public static void drawImage2D(Minecraft mc, ResourceLocation location, int x, int y, int width, int height, double uStart, double vStart, double uEnd, double vEnd) {
        mc.func_110434_K().func_110577_a(location);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(uStart, vEnd).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(uEnd, vEnd).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(uEnd, vStart).func_181675_d();
        bufferBuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a(uStart, vStart).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawImage2D(Minecraft mc, ResourceLocation location, int x, int y, int width, int height) {
        DevUtil.drawImage2D(mc, location, x, y, width, height, 0.0, 0.0, 1.0, 1.0);
    }

    public static void drawImage2D(Minecraft mc, ResourceLocation location) {
        ScaledResolution resolution = new ScaledResolution(mc);
        DevUtil.drawImage2D(mc, location, 0, 0, resolution.func_78326_a(), resolution.func_78328_b());
    }

    public static void drawColor(int x1, int y1, int x2, int y2, float r, float g, float b, float a) {
        DevUtil.drawColor(x1, y1, x2, y2, 0.0, r, g, b, a);
    }

    public static void drawColor(int x1, int y1, int x2, int y2, double z, float r, float g, float b, float a) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_181662_b((double)x1, (double)y2, z).func_181666_a(r, g, b, a).func_181675_d();
        builder.func_181662_b((double)x2, (double)y2, z).func_181666_a(r, g, b, a).func_181675_d();
        builder.func_181662_b((double)x2, (double)y1, z).func_181666_a(r, g, b, a).func_181675_d();
        builder.func_181662_b((double)x1, (double)y1, z).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static final class ModelCreator {
        final File itemModelFolder = new File("D:/mcmods/1.12.2/vehicle-mod/src/main/resources/assets/vehiclemod/models/item");
        final Gson gson = new GsonBuilder().setPrettyPrinting().create();

        public void createPartFiles() {
            ForgeRegistries.ITEMS.getValuesCollection().stream().filter(i -> i instanceof ItemVehicleUpgrade).map(i -> (ItemVehicleUpgrade)((Object)i)).forEach(this::create);
        }

        void create(ItemVehicleUpgrade upgrade) {
            try {
                ResourceLocation name = upgrade.getRegistryName();
                File file = new File(this.itemModelFolder, name.func_110623_a() + ".json");
                if (!file.exists() && file.createNewFile()) {
                    JsonObject main = new JsonObject();
                    main.addProperty("parent", "item/generated");
                    JsonObject texture = new JsonObject();
                    texture.addProperty("layer0", "vehiclemod:items/" + name.func_110623_a());
                    main.add("textures", (JsonElement)texture);
                    FileWriter writer = new FileWriter(file);
                    writer.write(this.gson.toJson((JsonElement)main));
                    writer.close();
                    VehicleMod.logger.info("Created item model file for {}", (Object)name);
                }
            }
            catch (Exception e) {
                VehicleMod.logger.fatal("Error creating item model file for {}", (Object)upgrade.getRegistryName());
            }
        }
    }
}

