/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.textures;

import com.google.common.collect.Lists;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureUtilLegacy;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_376;
import net.minecraft.class_377;
import net.minecraft.class_390;
import net.minecraft.class_757;

public class FontRendererWithAtlas
extends class_327
implements class_3302 {
    private int[] charWidthArray = new int[256];
    public int FONT_HEIGHT = 9;
    public Random fontRandom = new Random();
    private int[] colorCode = new int[32];
    private final class_2960 locationFontTexture;
    private Sprite fontIcon = null;
    private Sprite blankIcon = null;
    private int ref = 0;
    private final class_1060 renderEngine;
    private float posX;
    private float posY;
    private float red;
    private float blue;
    private float green;
    private float alpha;
    private int textColor;
    private boolean randomStyle;
    private boolean boldStyle;
    private boolean italicStyle;
    private boolean underlineStyle;
    private boolean strikethroughStyle;
    private class_287 vertexBuffer;

    public FontRendererWithAtlas(class_1060 renderEngine, class_2960 locationFontTexture) {
        super(identifierx -> (class_377)class_156.method_654((Object)new class_377(renderEngine, locationFontTexture), fontStorage -> fontStorage.method_2004((List)Lists.newArrayList((Object[])new class_390[]{new class_376()}))));
        this.locationFontTexture = locationFontTexture;
        this.renderEngine = renderEngine;
        renderEngine.method_22813(this.locationFontTexture);
        for (int colorCodeIndex = 0; colorCodeIndex < 32; ++colorCodeIndex) {
            int var6 = (colorCodeIndex >> 3 & 1) * 85;
            int red = (colorCodeIndex >> 2 & 1) * 170 + var6;
            int green = (colorCodeIndex >> 1 & 1) * 170 + var6;
            int blue = (colorCodeIndex >> 0 & 1) * 170 + var6;
            if (colorCodeIndex == 6) {
                red += 85;
            }
            if (colorCodeIndex >= 16) {
                red /= 4;
                green /= 4;
                blue /= 4;
            }
            this.colorCode[colorCodeIndex] = (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        }
        this.vertexBuffer = class_289.method_1348().method_1349();
    }

    public void onResourceManagerReload(class_3300 resourceManager) {
        this.readFontTexture();
    }

    private void readFontTexture() {
        BufferedImage fontImage;
        try {
            fontImage = TextureUtilLegacy.readBufferedImage(class_310.method_1551().method_1478().method_14486(this.locationFontTexture).method_14482());
        }
        catch (IOException var17) {
            throw new RuntimeException(var17);
        }
        if (fontImage.getWidth() > 512 || fontImage.getHeight() > 512) {
            int maxDim = Math.max(fontImage.getWidth(), fontImage.getHeight());
            float scaleBy = 512.0f / (float)maxDim;
            int type = fontImage.getType();
            if (type == 13) {
                type = 6;
            }
            int newWidth = Math.max(1, (int)((float)fontImage.getWidth() * scaleBy));
            int newHeight = Math.max(1, (int)((float)fontImage.getHeight() * scaleBy));
            BufferedImage tmp = new BufferedImage(newWidth, newHeight, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.drawImage(fontImage, 0, 0, newWidth, newHeight, null);
            g2.dispose();
            fontImage = tmp;
        }
        int sheetWidth = fontImage.getWidth();
        int sheetHeight = fontImage.getHeight();
        int[] sheetImageData = new int[sheetWidth * sheetHeight];
        fontImage.getRGB(0, 0, sheetWidth, sheetHeight, sheetImageData, 0, sheetWidth);
        int characterHeight = sheetHeight / 16;
        int characterWidth = sheetWidth / 16;
        int padding = 1;
        float scale = 8.0f / (float)characterWidth;
        for (int characterIndex = 0; characterIndex < 256; ++characterIndex) {
            int characterX = characterIndex % 16;
            int characterY = characterIndex / 16;
            if (characterIndex == 32) {
                this.charWidthArray[characterIndex] = 3 + padding;
            }
            int thisCharacterWidth = characterWidth - 1;
            boolean onlyBlankPixels = true;
            while (thisCharacterWidth >= 0 && onlyBlankPixels) {
                int pixelX = characterX * characterWidth + thisCharacterWidth;
                for (int characterPixelYPos = 0; characterPixelYPos < characterHeight && onlyBlankPixels; ++characterPixelYPos) {
                    int pixelY = (characterY * characterWidth + characterPixelYPos) * sheetWidth;
                    if ((sheetImageData[pixelX + pixelY] >> 24 & 0xFF) == 0) continue;
                    onlyBlankPixels = false;
                }
                if (!onlyBlankPixels) continue;
                --thisCharacterWidth;
            }
            this.charWidthArray[characterIndex] = (int)(0.5 + (double)((float)(++thisCharacterWidth) * scale)) + padding;
        }
    }

    public void setSprites(Sprite text, Sprite blank) {
        this.fontIcon = text;
        this.blankIcon = blank;
    }

    public void setFontRef(int ref) {
        this.ref = ref;
    }

    private float renderCharAtPos(int charIndex, char character, boolean shadow) {
        return character == ' ' ? 4.0f : this.renderDefaultChar(charIndex, shadow);
    }

    private float renderDefaultChar(int charIndex, boolean shadow) {
        float sheetWidth = (float)(this.fontIcon.originX + this.fontIcon.width) / this.fontIcon.getMaxU();
        float sheetHeight = (float)(this.fontIcon.originY + this.fontIcon.height) / this.fontIcon.getMaxV();
        float fontScaleX = (float)(this.fontIcon.width - 2) / 128.0f;
        float fontScaleY = (float)(this.fontIcon.height - 2) / 128.0f;
        float charXPosInSheet = (float)(charIndex % 16 * 8) * fontScaleX + (float)this.fontIcon.originX + 1.0f;
        float charYPosInSheet = (float)(charIndex / 16 * 8) * fontScaleY + (float)this.fontIcon.originY + 1.0f;
        float shadowOffset = shadow ? 1.0f : 0.0f;
        float charWidth = (float)this.charWidthArray[charIndex] - 0.01f;
        this.vertexBuffer.method_22912((double)(this.posX + shadowOffset), (double)this.posY, 0.0).method_22913(charXPosInSheet / sheetWidth, charYPosInSheet / sheetHeight).method_22915(this.red, this.blue, this.green, this.alpha).method_1344();
        this.vertexBuffer.method_22912((double)(this.posX - shadowOffset), (double)(this.posY + 7.99f), 0.0).method_22913(charXPosInSheet / sheetWidth, (charYPosInSheet + 7.99f * fontScaleY) / sheetHeight).method_22915(this.red, this.blue, this.green, this.alpha).method_1344();
        this.vertexBuffer.method_22912((double)(this.posX + charWidth - 1.0f - shadowOffset), (double)(this.posY + 7.99f), 0.0).method_22913((charXPosInSheet + (charWidth - 1.0f) * fontScaleX) / sheetWidth, (charYPosInSheet + 7.99f * fontScaleY) / sheetHeight).method_22915(this.red, this.blue, this.green, this.alpha).method_1344();
        this.vertexBuffer.method_22912((double)(this.posX + charWidth - 1.0f + shadowOffset), (double)this.posY, 0.0).method_22913((charXPosInSheet + (charWidth - 1.0f) * fontScaleX) / sheetWidth, charYPosInSheet / sheetHeight).method_22915(this.red, this.blue, this.green, this.alpha).method_1344();
        return this.charWidthArray[charIndex];
    }

    public int drawStringWithShadow(String text, float x, float y, int color) {
        return this.drawString(text, x, y, color, true);
    }

    public int drawString(String text, int x, int y, int color) {
        return this.drawString(text, x, y, color, false);
    }

    public int drawString(String text, float x, float y, int color, boolean shadow) {
        int var6;
        this.resetStyles();
        RenderSystem.setShader(class_757::method_34543);
        this.vertexBuffer.method_23477();
        this.vertexBuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        if (shadow) {
            var6 = this.renderString(text, x + 1.0f, y + 1.0f, color, true);
            var6 = Math.max(var6, this.renderString(text, x, y, color, false));
        } else {
            var6 = this.renderString(text, x, y, color, false);
        }
        this.vertexBuffer.method_1326();
        class_286.method_1309((class_287)this.vertexBuffer);
        return var6;
    }

    private void resetStyles() {
        this.randomStyle = false;
        this.boldStyle = false;
        this.italicStyle = false;
        this.underlineStyle = false;
        this.strikethroughStyle = false;
    }

    private void renderStringAtPos(String text, boolean shadow) {
        for (int textIndex = 0; textIndex < text.length(); ++textIndex) {
            char character = text.charAt(textIndex);
            if (character == '\u00a7' && textIndex + 1 < text.length()) {
                int formatCode = "0123456789abcdefklmnor".indexOf(text.toLowerCase().charAt(textIndex + 1));
                if (formatCode < 16) {
                    int color;
                    this.randomStyle = false;
                    this.boldStyle = false;
                    this.strikethroughStyle = false;
                    this.underlineStyle = false;
                    this.italicStyle = false;
                    if (formatCode < 0 || formatCode > 15) {
                        formatCode = 15;
                    }
                    if (shadow) {
                        formatCode += 16;
                    }
                    this.textColor = color = this.colorCode[formatCode];
                } else if (formatCode == 16) {
                    this.randomStyle = true;
                } else if (formatCode == 17) {
                    this.boldStyle = true;
                } else if (formatCode == 18) {
                    this.strikethroughStyle = true;
                } else if (formatCode == 19) {
                    this.underlineStyle = true;
                } else if (formatCode == 20) {
                    this.italicStyle = true;
                } else if (formatCode == 21) {
                    this.randomStyle = false;
                    this.boldStyle = false;
                    this.strikethroughStyle = false;
                    this.underlineStyle = false;
                    this.italicStyle = false;
                    GLShim.glColor4f(this.red, this.blue, this.green, this.alpha);
                }
                ++textIndex;
                continue;
            }
            int charIndex = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(character);
            if (charIndex == -1) continue;
            float sheetWidth = (float)(this.blankIcon.originX + this.blankIcon.width) / this.blankIcon.getMaxU();
            float sheetHeight = (float)(this.blankIcon.originY + this.blankIcon.height) / this.blankIcon.getMaxV();
            float u = (float)(this.blankIcon.originX + 4) / sheetWidth;
            float v = (float)(this.blankIcon.originY + 4) / sheetHeight;
            if (this.randomStyle) {
                int randomCharIndex;
                while (this.charWidthArray[charIndex] != this.charWidthArray[randomCharIndex = this.fontRandom.nextInt(this.charWidthArray.length)]) {
                }
                charIndex = randomCharIndex;
            }
            float offset = 1.0f;
            float widthOfRenderedChar = this.renderCharAtPos(charIndex, character, this.italicStyle);
            if (this.boldStyle) {
                this.posX += offset;
                this.renderCharAtPos(charIndex, character, this.italicStyle);
                this.posX -= offset;
                widthOfRenderedChar += 1.0f;
            }
            if (this.strikethroughStyle) {
                this.vertexBuffer.method_22912((double)this.posX, (double)(this.posY + (float)(this.FONT_HEIGHT / 2)), 0.0).method_22913(u, v).method_22915(this.red, this.blue, this.green, this.alpha).method_1344();
                this.vertexBuffer.method_22912((double)(this.posX + widthOfRenderedChar), (double)(this.posY + (float)(this.FONT_HEIGHT / 2)), 0.0).method_22913(u, v).method_22915(this.red, this.blue, this.green, this.alpha).method_1344();
                this.vertexBuffer.method_22912((double)(this.posX + widthOfRenderedChar), (double)(this.posY + (float)(this.FONT_HEIGHT / 2) - 1.0f), 0.0).method_22913(u, v).method_22915(this.red, this.blue, this.green, this.alpha).method_1344();
                this.vertexBuffer.method_22912((double)this.posX, (double)(this.posY + (float)(this.FONT_HEIGHT / 2) - 1.0f), 0.0).method_22913(u, v).method_22915(this.red, this.blue, this.green, this.alpha).method_1344();
            }
            if (this.underlineStyle) {
                int l = this.underlineStyle ? -1 : 0;
                this.vertexBuffer.method_22912((double)(this.posX + (float)l), (double)(this.posY + (float)this.FONT_HEIGHT), 0.0).method_22913(u, v).method_22915(this.red, this.blue, this.green, this.alpha).method_1344();
                this.vertexBuffer.method_22912((double)(this.posX + widthOfRenderedChar), (double)(this.posY + (float)this.FONT_HEIGHT), 0.0).method_22913(u, v).method_22915(this.red, this.blue, this.green, this.alpha).method_1344();
                this.vertexBuffer.method_22912((double)(this.posX + widthOfRenderedChar), (double)(this.posY + (float)this.FONT_HEIGHT - 1.0f), 0.0).method_22913(u, v).method_22915(this.red, this.blue, this.green, this.alpha).method_1344();
                this.vertexBuffer.method_22912((double)(this.posX + (float)l), (double)(this.posY + (float)this.FONT_HEIGHT - 1.0f), 0.0).method_22913(u, v).method_22915(this.red, this.blue, this.green, this.alpha).method_1344();
            }
            this.posX += (float)((int)widthOfRenderedChar);
        }
    }

    private int renderString(String text, float x, float y, int color, boolean shadow) {
        if (text == null) {
            return 0;
        }
        if ((color & 0xFC000000) == 0) {
            color |= 0xFF000000;
        }
        if (shadow) {
            color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        }
        this.red = (float)(color >> 16 & 0xFF) / 255.0f;
        this.blue = (float)(color >> 8 & 0xFF) / 255.0f;
        this.green = (float)(color & 0xFF) / 255.0f;
        this.alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        this.posX = x;
        this.posY = y;
        this.renderStringAtPos(text, shadow);
        return (int)this.posX;
    }

    public int getStringWidth(String string) {
        if (string == null) {
            return 0;
        }
        int totalWidth = 0;
        boolean includeSpace = false;
        for (int charIndex = 0; charIndex < string.length(); ++charIndex) {
            char character = string.charAt(charIndex);
            float characterWidth = this.getCharWidth(character);
            if (characterWidth < 0.0f && charIndex < string.length() - 1) {
                if ((character = string.charAt(++charIndex)) != 'l' && character != 'L') {
                    if (character == 'r' || character == 'R') {
                        includeSpace = false;
                    }
                } else {
                    includeSpace = true;
                }
                characterWidth = 0.0f;
            }
            totalWidth = (int)((float)totalWidth + characterWidth);
            if (!includeSpace || !(characterWidth > 0.0f)) continue;
            ++totalWidth;
        }
        return totalWidth;
    }

    public float getCharWidth(char character) {
        if (character == '\u00a7') {
            return -1.0f;
        }
        if (character == ' ') {
            return 4.0f;
        }
        int indexInDefaultSheet = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(character);
        return character > '\u0000' && indexInDefaultSheet != -1 ? (float)this.charWidthArray[indexInDefaultSheet] : 0.0f;
    }

    public CompletableFuture method_25931(class_3302.class_4045 var1, class_3300 var2, class_3695 var3, class_3695 var4, Executor var5, Executor var6) {
        return null;
    }
}

