/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.textures.IIconCreator;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.BackgroundImageInfo;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.MessageUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mamiyaotaru.voxelmap.util.WaypointContainer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import net.minecraft.class_1937;
import net.minecraft.class_2535;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4587;
import net.minecraft.class_5218;
import net.minecraft.class_634;
import net.minecraft.class_642;
import net.minecraft.class_746;

public class WaypointManager
implements IWaypointManager {
    IVoxelMap master;
    private class_310 game;
    public MapSettingsManager options = null;
    TextureAtlas textureAtlas;
    TextureAtlas textureAtlasChooser;
    private boolean loaded = false;
    private boolean needSave = false;
    private ArrayList<Waypoint> wayPts = new ArrayList();
    private Waypoint highlightedWaypoint = null;
    private String worldName = "";
    private String currentSubWorldName = "";
    private String currentSubWorldHash = "";
    private String currentSubworldDescriptor = "";
    private String currentSubworldDescriptorNoCodes = "";
    private boolean multiworld = false;
    private boolean gotAutoSubworldName = false;
    private DimensionContainer currentDimension = null;
    private TreeSet<String> knownSubworldNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private HashSet<String> oldNorthWorldNames = new HashSet();
    private HashMap<String, String> worldSeeds = new HashMap();
    private BackgroundImageInfo backgroundImageInfo = null;
    private WaypointContainer waypointContainer = null;
    private File settingsFile;
    private Long lastNewWorldNameTime = 0L;
    private Object waypointLock = new Object();

    public WaypointManager(IVoxelMap master) {
        this.master = master;
        this.options = master.getMapOptions();
        this.textureAtlas = new TextureAtlas("waypoints");
        this.textureAtlas.method_4527(false, false);
        this.textureAtlasChooser = new TextureAtlas("chooser");
        this.textureAtlasChooser.method_4527(false, false);
        this.waypointContainer = new WaypointContainer(this.options);
    }

    @Override
    public void onResourceManagerReload(class_3300 resourceManager) {
        final ArrayList images = new ArrayList();
        IIconCreator iconCreator = new IIconCreator(){

            @Override
            public void addIcons(TextureAtlas textureAtlas) {
                class_310 mc = class_310.method_1551();
                for (class_2960 candidate : mc.method_1478().method_14488("images", asset -> asset.endsWith(".png"))) {
                    if (!candidate.method_12836().equals("voxelmap") || !candidate.method_12832().contains("images/waypoints")) continue;
                    images.add(candidate);
                }
                Sprite markerIcon = textureAtlas.registerIconForResource(new class_2960("voxelmap", "images/waypoints/marker.png"), class_310.method_1551().method_1478());
                Sprite markerIconSmall = textureAtlas.registerIconForResource(new class_2960("voxelmap", "images/waypoints/markersmall.png"), class_310.method_1551().method_1478());
                for (class_2960 resourceLocation : images) {
                    Sprite icon = textureAtlas.registerIconForResource(resourceLocation, class_310.method_1551().method_1478());
                    String name = resourceLocation.toString();
                    if (name.toLowerCase().contains("waypoints/waypoint") && !name.toLowerCase().contains("small")) {
                        textureAtlas.registerMaskedIcon(name.replace(".png", "Small.png"), icon);
                        textureAtlas.registerMaskedIcon(name.replace("waypoints/waypoint", "waypoints/marker"), markerIcon);
                        textureAtlas.registerMaskedIcon(name.replace("waypoints/waypoint", "waypoints/marker").replace(".png", "Small.png"), markerIconSmall);
                        continue;
                    }
                    if (!name.toLowerCase().contains("waypoints/marker") || name.toLowerCase().contains("small")) continue;
                    textureAtlas.registerMaskedIcon(name.replace(".png", "Small.png"), icon);
                }
            }
        };
        this.textureAtlas.loadTextureAtlas(iconCreator);
        GLShim.glTexParameteri(3553, 10241, 9729);
        GLShim.glTexParameteri(3553, 10240, 9729);
        this.textureAtlasChooser.reset();
        int expectedSize = 32;
        for (class_2960 resourceLocation : images) {
            String name = resourceLocation.toString();
            if (!name.toLowerCase().contains("waypoints/waypoint") || name.toLowerCase().contains("small")) continue;
            try {
                class_3298 imageResource = resourceManager.method_14486(resourceLocation);
                BufferedImage bufferedImage = ImageIO.read(imageResource.method_14482());
                imageResource.close();
                float scale = (float)expectedSize / (float)bufferedImage.getWidth();
                bufferedImage = ImageUtils.scaleImage(bufferedImage, scale);
                this.textureAtlasChooser.registerIconForBufferedImage(name, bufferedImage);
            }
            catch (IOException var11) {
                this.textureAtlasChooser.registerIconForResource(resourceLocation, class_310.method_1551().method_1478());
            }
        }
        this.textureAtlasChooser.stitch();
    }

    @Override
    public TextureAtlas getTextureAtlas() {
        return this.textureAtlas;
    }

    @Override
    public TextureAtlas getTextureAtlasChooser() {
        return this.textureAtlasChooser;
    }

    public ArrayList getWaypoints() {
        return this.wayPts;
    }

    @Override
    public void newWorld(class_1937 world) {
        if (world == null) {
            this.currentDimension = null;
        } else {
            String mapName;
            this.game = class_310.method_1551();
            if (this.game.method_1496()) {
                mapName = this.getMapName();
            } else {
                mapName = this.getServerName();
                if (mapName != null) {
                    mapName = mapName.toLowerCase();
                }
            }
            if (!this.worldName.equals(mapName) && mapName != null && !mapName.equals("")) {
                this.currentDimension = null;
                this.worldName = mapName;
                this.master.getDimensionManager().populateDimensions(world);
                this.loadWaypoints();
            }
            this.master.getDimensionManager().enteredWorld(world);
            DimensionContainer dim = this.master.getDimensionManager().getDimensionContainerByWorld(world);
            this.enteredDimension(dim);
            this.setSubWorldDescriptor("");
        }
    }

    public String getMapName() {
        return this.game.method_1576().method_27050(class_5218.field_24188).normalize().toFile().getName();
    }

    public String getServerName() {
        Object serverName = "";
        try {
            class_642 serverData = this.game.method_1558();
            if (serverData != null) {
                boolean isOnLAN = serverData.method_2994();
                if (isOnLAN) {
                    System.out.println("LAN server detected!");
                    serverName = serverData.field_3752;
                } else {
                    serverName = serverData.field_3761;
                }
            } else if (this.game.method_1589()) {
                System.out.println("REALMS server detected!");
                serverName = "Realms";
            } else {
                class_634 netHandler = this.game.method_1562();
                class_2535 networkManager = netHandler.method_2872();
                InetSocketAddress socketAddress = (InetSocketAddress)networkManager.method_10755();
                serverName = socketAddress.getHostString() + ":" + socketAddress.getPort();
            }
        }
        catch (Exception var6) {
            System.err.println("error getting ServerData");
            var6.printStackTrace();
        }
        return serverName;
    }

    @Override
    public String getCurrentWorldName() {
        return this.worldName;
    }

    @Override
    public void handleDeath() {
        HashSet<Waypoint> toDel = new HashSet<Waypoint>();
        for (Waypoint pt : this.wayPts) {
            if (pt.name.equals("Latest Death")) {
                pt.name = "Previous Death";
            }
            if (!pt.name.startsWith("Previous Death")) continue;
            if (this.options.deathpoints == 2) {
                int num = 0;
                try {
                    if (pt.name.length() > 15) {
                        num = Integer.parseInt(pt.name.substring(15));
                    }
                }
                catch (Exception var6) {
                    num = 0;
                }
                pt.red -= (pt.red - 0.5f) / 8.0f;
                pt.green -= (pt.green - 0.5f) / 8.0f;
                pt.blue -= (pt.blue - 0.5f) / 8.0f;
                pt.name = "Previous Death " + (num + 1);
                continue;
            }
            toDel.add(pt);
        }
        if (this.options.deathpoints != 2 && toDel.size() > 0) {
            for (Waypoint pt : toDel) {
                this.deleteWaypoint(pt);
            }
        }
        if (this.options.deathpoints != 0) {
            class_746 thePlayer = class_310.method_1551().field_1724;
            TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
            dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByWorld((class_1937)class_310.method_1551().field_1687));
            double dimensionScale = thePlayer.field_6002.method_8597().method_31110();
            this.addWaypoint(new Waypoint("Latest Death", (int)((double)GameVariableAccessShim.xCoord() * dimensionScale), (int)((double)GameVariableAccessShim.zCoord() * dimensionScale), GameVariableAccessShim.yCoord() - 1, true, 1.0f, 1.0f, 1.0f, "Skull", this.getCurrentSubworldDescriptor(false), dimensions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enteredDimension(DimensionContainer dimension) {
        this.highlightedWaypoint = null;
        if (dimension == this.currentDimension) {
            this.multiworld = true;
        }
        this.currentDimension = dimension;
        Object object = this.waypointLock;
        synchronized (object) {
            this.waypointContainer = new WaypointContainer(this.options);
            for (Waypoint pt : this.wayPts) {
                pt.inDimension = pt.dimensions.size() == 0 || pt.dimensions.contains(dimension);
                this.waypointContainer.addWaypoint(pt);
            }
            this.waypointContainer.setHighlightedWaypoint(this.highlightedWaypoint);
        }
        this.loadBackgroundMapImage();
    }

    @Override
    public void setOldNorth(boolean oldNorth) {
        String oldNorthWorldName = "";
        oldNorthWorldName = this.knownSubworldNames.size() == 0 ? "all" : this.getCurrentSubworldDescriptor(false);
        if (oldNorth) {
            this.oldNorthWorldNames.add(oldNorthWorldName);
        } else {
            this.oldNorthWorldNames.remove(oldNorthWorldName);
        }
        this.saveWaypoints();
    }

    @Override
    public TreeSet getKnownSubworldNames() {
        return this.knownSubworldNames;
    }

    @Override
    public boolean receivedAutoSubworldName() {
        return this.gotAutoSubworldName;
    }

    @Override
    public boolean isMultiworld() {
        return this.multiworld || this.game.method_1589();
    }

    @Override
    public synchronized void setSubworldName(String name, boolean fromServer) {
        boolean notNull;
        boolean bl = notNull = !name.equals("");
        if (notNull || System.currentTimeMillis() - this.lastNewWorldNameTime > 2000L) {
            if (notNull) {
                if (fromServer) {
                    this.gotAutoSubworldName = true;
                }
                if (!name.equals(this.currentSubWorldName)) {
                    System.out.println("New world name: " + TextUtils.scrubCodes(name));
                }
                this.lastNewWorldNameTime = System.currentTimeMillis();
            }
            this.currentSubWorldName = name;
            this.setSubWorldDescriptor(this.currentSubWorldName);
        }
    }

    @Override
    public synchronized void setSubworldHash(String hash) {
        this.currentSubWorldHash = hash;
        if (this.currentSubWorldName.equals("")) {
            this.setSubWorldDescriptor(this.currentSubWorldHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSubWorldDescriptor(String descriptor) {
        boolean serverSaysOldNorth = false;
        if (descriptor.endsWith("\u00a7o\u00a7n")) {
            descriptor = descriptor.substring(0, descriptor.length() - 4);
            serverSaysOldNorth = true;
        }
        this.currentSubworldDescriptor = descriptor;
        this.currentSubworldDescriptorNoCodes = TextUtils.scrubCodes(this.currentSubworldDescriptor);
        this.newSubworldName(this.currentSubworldDescriptorNoCodes);
        String currentSubWorldDescriptorScrubbed = TextUtils.scrubName(this.currentSubworldDescriptorNoCodes);
        Object object = this.waypointLock;
        synchronized (object) {
            for (Waypoint pt : this.wayPts) {
                if (currentSubWorldDescriptorScrubbed != "" && pt.world != "" && !currentSubWorldDescriptorScrubbed.equals(pt.world)) {
                    pt.inWorld = false;
                    continue;
                }
                pt.inWorld = true;
            }
        }
        if (serverSaysOldNorth) {
            if (this.currentSubworldDescriptorNoCodes.equals("")) {
                this.oldNorthWorldNames.add("all");
            } else {
                this.oldNorthWorldNames.add(this.currentSubworldDescriptorNoCodes);
            }
        }
        this.master.getMapOptions().oldNorth = this.oldNorthWorldNames.contains(this.currentSubworldDescriptorNoCodes);
    }

    private void newSubworldName(String name) {
        if (name != null && !name.equals("")) {
            this.multiworld = true;
            if (this.knownSubworldNames.add(name)) {
                if (this.loaded) {
                    this.saveWaypoints();
                } else {
                    this.needSave = true;
                }
            }
        }
        this.loadBackgroundMapImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeSubworldName(String oldName, String newName) {
        if (!newName.equals(oldName) && this.knownSubworldNames.remove(oldName)) {
            File newCachedRegionFileDir;
            boolean success;
            this.knownSubworldNames.add(newName);
            Object object = this.waypointLock;
            synchronized (object) {
                for (Waypoint pt : this.wayPts) {
                    if (!pt.world.equals(oldName)) continue;
                    pt.world = newName;
                }
            }
            this.master.getPersistentMap().renameSubworld(oldName, newName);
            String worldName = this.getCurrentWorldName();
            String worldNamePathPart = TextUtils.scrubNameFile(worldName);
            String subWorldNamePathPart = TextUtils.scrubNameFile(oldName) + "/";
            File oldCachedRegionFileDir = new File(class_310.method_1551().field_1697, "/mods/mamiyaotaru/voxelmap/cache/" + worldNamePathPart + "/" + subWorldNamePathPart);
            if (oldCachedRegionFileDir.exists() && oldCachedRegionFileDir.isDirectory() && !(success = oldCachedRegionFileDir.renameTo(newCachedRegionFileDir = new File(class_310.method_1551().field_1697, "/mods/mamiyaotaru/voxelmap/cache/" + worldNamePathPart + "/" + (subWorldNamePathPart = TextUtils.scrubNameFile(newName) + "/"))))) {
                System.out.println("Failed renaming " + oldCachedRegionFileDir.getPath() + " to " + newCachedRegionFileDir.getPath());
            }
            if (oldName.equals(this.getCurrentSubworldDescriptor(false))) {
                this.setSubworldName(newName, false);
            }
            this.saveWaypoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSubworld(String name) {
        if (this.knownSubworldNames.remove(name)) {
            Object object = this.waypointLock;
            synchronized (object) {
                for (Waypoint pt : this.wayPts) {
                    if (!pt.world.equals(name)) continue;
                    pt.world = "";
                    pt.inWorld = true;
                }
            }
            this.saveWaypoints();
            this.lastNewWorldNameTime = 0L;
            this.setSubworldName("", false);
        }
        if (this.knownSubworldNames.size() == 0) {
            this.multiworld = false;
        }
    }

    @Override
    public String getCurrentSubworldDescriptor(boolean withCodes) {
        return withCodes ? this.currentSubworldDescriptor : this.currentSubworldDescriptorNoCodes;
    }

    @Override
    public String getWorldSeed() {
        String seed;
        String key = "all";
        if (this.knownSubworldNames.size() > 0) {
            key = this.getCurrentSubworldDescriptor(false);
        }
        if ((seed = this.worldSeeds.get(key)) == null) {
            seed = "";
        }
        return seed;
    }

    @Override
    public void setWorldSeed(String newSeed) {
        String worldName = "all";
        if (this.knownSubworldNames.size() > 0) {
            worldName = this.getCurrentSubworldDescriptor(false);
        }
        this.worldSeeds.put(worldName, newSeed);
        this.saveWaypoints();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveWaypoints() {
        int portSepLoc;
        String worldNameSave = this.getCurrentWorldName();
        if (worldNameSave.endsWith(":25565") && (portSepLoc = worldNameSave.lastIndexOf(":")) != -1) {
            worldNameSave = worldNameSave.substring(0, portSepLoc);
        }
        worldNameSave = TextUtils.scrubNameFile(worldNameSave);
        File saveDir = new File(class_310.method_1551().field_1697, "/voxelmap/");
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        this.settingsFile = new File(saveDir, worldNameSave + ".points");
        try {
            void var6_11;
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.settingsFile), StandardCharsets.UTF_8));
            Object knownSubworldsString = "";
            for (String string : this.knownSubworldNames) {
                knownSubworldsString = (String)knownSubworldsString + TextUtils.scrubName(string) + ",";
            }
            out.println("subworlds:" + (String)knownSubworldsString);
            Object oldNorthWorldsString = "";
            for (String oldNorthWorldName : this.oldNorthWorldNames) {
                oldNorthWorldsString = (String)oldNorthWorldsString + TextUtils.scrubName(oldNorthWorldName) + ",";
            }
            out.println("oldNorthWorlds:" + (String)oldNorthWorldsString);
            String string = "";
            for (Map.Entry<String, String> entry : this.worldSeeds.entrySet()) {
                String string2 = (String)var6_11 + TextUtils.scrubName(entry.getKey()) + "#" + entry.getValue() + ",";
            }
            out.println("seeds:" + (String)var6_11);
            for (Waypoint pt : this.wayPts) {
                if (pt.name.startsWith("^")) continue;
                Object dimensionsString = "";
                for (DimensionContainer dimension : pt.dimensions) {
                    dimensionsString = (String)dimensionsString + dimension.getStorageName() + "#";
                }
                if (((String)dimensionsString).equals("")) {
                    dimensionsString = (String)dimensionsString + AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByResourceLocation(class_2874.field_24753.method_29177()).getStorageName();
                }
                out.println("name:" + TextUtils.scrubName(pt.name) + ",x:" + pt.x + ",z:" + pt.z + ",y:" + pt.y + ",enabled:" + Boolean.toString(pt.enabled) + ",red:" + pt.red + ",green:" + pt.green + ",blue:" + pt.blue + ",suffix:" + pt.imageSuffix + ",world:" + TextUtils.scrubName(pt.world) + ",dimensions:" + (String)dimensionsString);
            }
            out.close();
        }
        catch (Exception var12) {
            MessageUtils.chatInfo("\u00a7EError Saving Waypoints");
            var12.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWaypoints() {
        this.loaded = false;
        this.multiworld = false;
        this.gotAutoSubworldName = false;
        this.currentDimension = null;
        this.setSubWorldDescriptor("");
        this.knownSubworldNames.clear();
        this.oldNorthWorldNames.clear();
        this.worldSeeds.clear();
        Object object = this.waypointLock;
        synchronized (object) {
            int portSepLoc;
            boolean loaded = false;
            this.wayPts = new ArrayList();
            String worldNameStandard = this.getCurrentWorldName();
            if (worldNameStandard.endsWith(":25565") && (portSepLoc = worldNameStandard.lastIndexOf(":")) != -1) {
                worldNameStandard = worldNameStandard.substring(0, portSepLoc);
            }
            if (!(loaded = this.loadWaypointsExtensible(worldNameStandard = TextUtils.scrubNameFile(worldNameStandard)))) {
                MessageUtils.chatInfo("\u00a7ENo waypoints exist for this world/server.");
            }
        }
        this.loaded = true;
        if (this.needSave) {
            this.needSave = false;
            this.saveWaypoints();
        }
        this.multiworld = this.multiworld || this.knownSubworldNames.size() > 0;
    }

    private boolean loadWaypointsExtensible(String worldNameStandard) {
        File settingsFileNew = new File(class_310.method_1551().field_1697, "/voxelmap/" + worldNameStandard + ".points");
        File settingsFileOld = new File(class_310.method_1551().field_1697, "/mods/mamiyaotaru/voxelmap/" + worldNameStandard + ".points");
        if (!settingsFileOld.exists() && !settingsFileNew.exists()) {
            return false;
        }
        this.settingsFile = !settingsFileOld.exists() ? settingsFileNew : (!settingsFileNew.exists() ? settingsFileOld : settingsFileNew);
        if (this.settingsFile.exists()) {
            try {
                String[] worldSeedPairs;
                String[] oldNorthWorlds;
                String[] subWorlds;
                Properties properties = new Properties();
                FileReader fr = new FileReader(this.settingsFile);
                properties.load(fr);
                String subWorldsS = properties.getProperty("subworlds", "");
                for (String subWorld : subWorlds = subWorldsS.split(",")) {
                    if (subWorld.equals("")) continue;
                    this.knownSubworldNames.add(TextUtils.descrubName(subWorld));
                }
                String oldNorthWorldsS = properties.getProperty("oldNorthWorlds", "");
                for (String oldNorthWorld : oldNorthWorlds = oldNorthWorldsS.split(",")) {
                    if (oldNorthWorld.equals("")) continue;
                    this.oldNorthWorldNames.add(TextUtils.descrubName(oldNorthWorld));
                }
                String worldSeedsS = properties.getProperty("seeds", "");
                for (String pair : worldSeedPairs = worldSeedsS.split(",")) {
                    String[] worldSeedPair = pair.split("#");
                    if (worldSeedPair.length != 2) continue;
                    this.worldSeeds.put(worldSeedPair[0], worldSeedPair[1]);
                }
                fr.close();
            }
            catch (IOException properties) {
                // empty catch block
            }
            try {
                String sCurrentLine;
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.settingsFile), StandardCharsets.UTF_8));
                while ((sCurrentLine = in.readLine()) != null) {
                    try {
                        String[] pairs = sCurrentLine.split(",");
                        if (pairs.length <= 1) continue;
                        String name = "";
                        int x = 0;
                        int z = 0;
                        int y = -1;
                        boolean enabled = false;
                        float red = 0.5f;
                        float green = 0.0f;
                        float blue = 0.0f;
                        String suffix = "";
                        String world = "";
                        TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
                        for (String pair : pairs) {
                            String[] dimensionStrings;
                            int splitIndex = pair.indexOf(":");
                            if (splitIndex == -1) continue;
                            String key = pair.substring(0, splitIndex).toLowerCase().trim();
                            String value = pair.substring(splitIndex + 1).trim();
                            if (key.equals("name")) {
                                name = TextUtils.descrubName(value);
                                continue;
                            }
                            if (key.equals("x")) {
                                x = Integer.parseInt(value);
                                continue;
                            }
                            if (key.equals("z")) {
                                z = Integer.parseInt(value);
                                continue;
                            }
                            if (key.equals("y")) {
                                y = Integer.parseInt(value);
                                continue;
                            }
                            if (key.equals("enabled")) {
                                enabled = Boolean.parseBoolean(value);
                                continue;
                            }
                            if (key.equals("red")) {
                                red = Float.parseFloat(value);
                                continue;
                            }
                            if (key.equals("green")) {
                                green = Float.parseFloat(value);
                                continue;
                            }
                            if (key.equals("blue")) {
                                blue = Float.parseFloat(value);
                                continue;
                            }
                            if (key.equals("suffix")) {
                                suffix = value;
                                continue;
                            }
                            if (key.equals("world")) {
                                world = TextUtils.descrubName(value);
                                continue;
                            }
                            if (!key.equals("dimensions")) continue;
                            for (String dimensionString : dimensionStrings = value.split("#")) {
                                dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByIdentifier(dimensionString));
                            }
                            if (dimensions.size() != 0) continue;
                            dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByResourceLocation(class_2874.field_24753.method_29177()));
                        }
                        if (name.equals("")) continue;
                        this.loadWaypoint(name, x, z, y, enabled, red, green, blue, suffix, world, dimensions);
                        if (world.equals("")) continue;
                        this.knownSubworldNames.add(TextUtils.descrubName(world));
                    }
                    catch (Exception exception) {}
                }
                in.close();
                return true;
            }
            catch (Exception var25) {
                MessageUtils.chatInfo("\u00a7EError Loading Waypoints");
                System.err.println("waypoint load error: " + var25.getLocalizedMessage());
                var25.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private void loadWaypoint(String name, int x, int z, int y, boolean enabled, float red, float green, float blue, String suffix, String world, TreeSet dimensions) {
        Waypoint newWaypoint = new Waypoint(name, x, z, y, enabled, red, green, blue, suffix, world, dimensions);
        if (!this.wayPts.contains(newWaypoint)) {
            this.wayPts.add(newWaypoint);
        }
    }

    @Override
    public void deleteWaypoint(Waypoint point) {
        this.waypointContainer.removeWaypoint(point);
        this.wayPts.remove(point);
        this.saveWaypoints();
        if (point == this.highlightedWaypoint) {
            this.setHighlightedWaypoint(null, false);
        }
    }

    @Override
    public void addWaypoint(Waypoint newWaypoint) {
        this.wayPts.add(newWaypoint);
        this.waypointContainer.addWaypoint(newWaypoint);
        this.saveWaypoints();
        if (this.highlightedWaypoint != null && this.highlightedWaypoint.getX() == newWaypoint.getX() && this.highlightedWaypoint.getZ() == newWaypoint.getZ()) {
            this.setHighlightedWaypoint(newWaypoint, false);
        }
    }

    @Override
    public void setHighlightedWaypoint(Waypoint waypoint, boolean toggle) {
        if (toggle && waypoint == this.highlightedWaypoint) {
            this.highlightedWaypoint = null;
        } else {
            if (waypoint != null && !this.wayPts.contains(waypoint)) {
                waypoint.red = 2.0f;
                waypoint.blue = 0.0f;
                waypoint.green = 0.0f;
            }
            this.highlightedWaypoint = waypoint;
        }
        this.waypointContainer.setHighlightedWaypoint(this.highlightedWaypoint);
    }

    @Override
    public Waypoint getHighlightedWaypoint() {
        return this.highlightedWaypoint;
    }

    @Override
    public void renderWaypoints(float partialTicks, class_4587 matrixStack, boolean beacons, boolean signs, boolean withDepth, boolean withoutDepth) {
        if (this.waypointContainer != null) {
            this.waypointContainer.renderWaypoints(partialTicks, matrixStack, beacons, signs, withDepth, withoutDepth);
        }
    }

    private void loadBackgroundMapImage() {
        if (this.backgroundImageInfo != null) {
            GLUtils.glah(this.backgroundImageInfo.glid);
            this.backgroundImageInfo = null;
        }
        try {
            Object path = this.getCurrentWorldName();
            String subworldDescriptor = this.getCurrentSubworldDescriptor(false);
            if (subworldDescriptor != null && !subworldDescriptor.equals("")) {
                path = (String)path + "/" + subworldDescriptor;
            }
            path = (String)path + "/" + this.currentDimension.getStorageName();
            InputStream is = this.game.method_1478().method_14486(new class_2960("voxelmap", "images/backgroundmaps/" + (String)path + "/map.png")).method_14482();
            BufferedImage image = ImageIO.read(is);
            is.close();
            BufferedImage mapImage = new BufferedImage(((Image)image).getWidth(null), ((Image)image).getHeight(null), 2);
            Graphics2D gfx = mapImage.createGraphics();
            gfx.drawImage((Image)image, 0, 0, null);
            gfx.dispose();
            is = this.game.method_1478().method_14486(new class_2960("voxelmap", "images/backgroundmaps/" + (String)path + "/map.txt")).method_14482();
            InputStreamReader isr = new InputStreamReader(is);
            Properties mapProperties = new Properties();
            mapProperties.load(isr);
            String left = mapProperties.getProperty("left");
            String right = mapProperties.getProperty("right");
            String top = mapProperties.getProperty("top");
            String bottom = mapProperties.getProperty("bottom");
            String width = mapProperties.getProperty("width");
            String height = mapProperties.getProperty("height");
            String scale = mapProperties.getProperty("scale");
            if (left != null && top != null && width != null && height != null) {
                this.backgroundImageInfo = new BackgroundImageInfo(mapImage, Integer.parseInt(left), Integer.parseInt(top), Integer.parseInt(width), Integer.parseInt(height));
            } else if (left != null && top != null && scale != null) {
                this.backgroundImageInfo = new BackgroundImageInfo(mapImage, Integer.parseInt(left), Integer.parseInt(top), Float.parseFloat(scale));
            } else if (left != null && top != null && right != null && bottom != null) {
                int widthInt = Integer.parseInt(right) - Integer.parseInt(left);
                int heightInt = Integer.parseInt(right) - Integer.parseInt(left);
                this.backgroundImageInfo = new BackgroundImageInfo(mapImage, Integer.parseInt(left), Integer.parseInt(top), widthInt, heightInt);
            }
            isr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public BackgroundImageInfo getBackgroundImageInfo() {
        return this.backgroundImageInfo;
    }
}

