/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiSelectPlayer;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.util.ArrayList;
import java.util.Random;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public class CommandUtils {
    private static final String NEW_WAYPOINT_COMMAND = "/newWaypoint ";
    private static final int NEW_WAYPOINT_COMMAND_LENGTH = "/newWaypoint ".length();
    private static final String TELEPORT_COMMAND = "/ztp ";
    private static final int TELEPORT_COMMAND_LENGTH = "/ztp ".length();
    private static Random generator = new Random();
    public static Pattern pattern = Pattern.compile("\\[(\\w+\\s*:\\s*[-#]?[^\\[\\]]+)(,\\s*\\w+\\s*:\\s*[-#]?[^\\[\\]]+)+\\]", 2);

    public static boolean checkForWaypoints(class_2561 chat) {
        String message = chat.getString();
        ArrayList waypointStrings = CommandUtils.getWaypointStrings(message);
        if (waypointStrings.size() <= 0) {
            return true;
        }
        ArrayList<class_2585> textComponents = new ArrayList<class_2585>();
        int count = 0;
        for (String waypointString : waypointStrings) {
            int waypointStringLocation = message.indexOf(waypointString);
            if (waypointStringLocation > count) {
                textComponents.add(new class_2585(message.substring(count, waypointStringLocation)));
            }
            class_2585 clickableWaypoint = new class_2585(waypointString);
            class_2583 chatStyle = clickableWaypoint.method_10866();
            chatStyle = chatStyle.method_10958(new class_2558(class_2558.class_2559.field_11750, NEW_WAYPOINT_COMMAND + waypointString.substring(1, waypointString.length() - 1)));
            chatStyle = chatStyle.method_10977(class_124.field_1075);
            class_2585 hover = new class_2585(I18nUtils.getString("minimap.waypointshare.tooltip1", new Object[0]) + "\n" + I18nUtils.getString("minimap.waypointshare.tooltip2", new Object[0]));
            chatStyle = chatStyle.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hover));
            clickableWaypoint.method_10862(chatStyle);
            textComponents.add(clickableWaypoint);
            count = waypointStringLocation + waypointString.length();
        }
        if (count < message.length() - 1) {
            textComponents.add(new class_2585(message.substring(count, message.length())));
        }
        class_2585 finalTextComponent = new class_2585("");
        for (class_2585 textComponent : textComponents) {
            finalTextComponent.method_10852((class_2561)textComponent);
        }
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)finalTextComponent);
        return false;
    }

    public static ArrayList getWaypointStrings(String message) {
        ArrayList<String> list = new ArrayList<String>();
        if (message.contains("[") && message.contains("]")) {
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                String match = matcher.group();
                if (CommandUtils.createWaypointFromChat(match.substring(1, match.length() - 1)) == null) continue;
                list.add(match);
            }
        }
        return list;
    }

    private static Waypoint createWaypointFromChat(String details) {
        Waypoint waypoint = null;
        String[] pairs = details.split(",");
        try {
            String name = "";
            Integer x = null;
            Integer z = null;
            Integer y = 64;
            boolean enabled = true;
            float red = generator.nextFloat();
            float green = generator.nextFloat();
            float blue = generator.nextFloat();
            String suffix = "";
            String world = "";
            TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
            for (int t = 0; t < pairs.length; ++t) {
                int splitIndex = pairs[t].indexOf(":");
                if (splitIndex == -1) continue;
                String key = pairs[t].substring(0, splitIndex).toLowerCase().trim();
                String value = pairs[t].substring(splitIndex + 1).trim();
                if (key.equals("name")) {
                    name = TextUtils.descrubName(value);
                    continue;
                }
                if (key.equals("x")) {
                    x = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("z")) {
                    z = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("y")) {
                    y = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("enabled")) {
                    enabled = Boolean.parseBoolean(value);
                    continue;
                }
                if (key.equals("red")) {
                    red = Float.parseFloat(value);
                    continue;
                }
                if (key.equals("green")) {
                    green = Float.parseFloat(value);
                    continue;
                }
                if (key.equals("blue")) {
                    blue = Float.parseFloat(value);
                    continue;
                }
                if (key.equals("color")) {
                    int color = Integer.decode(value);
                    red = (float)(color >> 16 & 0xFF) / 255.0f;
                    green = (float)(color >> 8 & 0xFF) / 255.0f;
                    blue = (float)(color >> 0 & 0xFF) / 255.0f;
                    continue;
                }
                if (!key.equals("suffix") && !key.equals("icon")) {
                    if (key.equals("world")) {
                        world = TextUtils.descrubName(value);
                        continue;
                    }
                    if (key.equals("dimensions")) {
                        String[] dimensionStrings = value.split("#");
                        for (int s = 0; s < dimensionStrings.length; ++s) {
                            dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByIdentifier(dimensionStrings[s]));
                        }
                        continue;
                    }
                    if (!key.equals("dimension") && !key.equals("dim")) continue;
                    dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByIdentifier(value));
                    continue;
                }
                suffix = value;
            }
            if (world == "") {
                world = AbstractVoxelMap.getInstance().getWaypointManager().getCurrentSubworldDescriptor(false);
            }
            if (dimensions.size() == 0) {
                dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByWorld((class_1937)class_310.method_1551().field_1687));
            }
            if (x != null && z != null) {
                if (dimensions.size() == 1 && ((DimensionContainer)dimensions.first()).type.method_31110() != 1.0) {
                    double dimensionScale = ((DimensionContainer)dimensions.first()).type.method_31110();
                    x = (int)((double)x.intValue() * dimensionScale);
                    z = (int)((double)z.intValue() * dimensionScale);
                }
                waypoint = new Waypoint(name, x, z, y, enabled, red, green, blue, suffix, world, dimensions);
            }
        }
        catch (NumberFormatException var20) {
            waypoint = null;
        }
        return waypoint;
    }

    public static void waypointClicked(String command) {
        boolean control = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)class_3675.method_15981((String)"key.keyboard.left.control").method_1444()) || class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)class_3675.method_15981((String)"key.keyboard.right.control").method_1444());
        String details = command.substring(NEW_WAYPOINT_COMMAND_LENGTH);
        Waypoint newWaypoint = CommandUtils.createWaypointFromChat(details);
        if (newWaypoint != null) {
            for (Waypoint existingWaypoint : AbstractVoxelMap.getInstance().getWaypointManager().getWaypoints()) {
                if (newWaypoint.getX() != existingWaypoint.getX() || newWaypoint.getZ() != existingWaypoint.getZ()) continue;
                if (control) {
                    class_310.method_1551().method_1507((class_437)new GuiAddWaypoint(null, AbstractVoxelMap.getInstance(), existingWaypoint, true));
                } else {
                    AbstractVoxelMap.getInstance().getWaypointManager().setHighlightedWaypoint(existingWaypoint, false);
                }
                return;
            }
            if (control) {
                class_310.method_1551().method_1507((class_437)new GuiAddWaypoint(null, AbstractVoxelMap.getInstance(), newWaypoint, false));
            } else {
                AbstractVoxelMap.getInstance().getWaypointManager().setHighlightedWaypoint(newWaypoint, false);
            }
        }
    }

    public static void sendWaypoint(Waypoint waypoint) {
        class_2960 resourceLocation = AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByWorld((class_1937)class_310.method_1551().field_1687).resourceLocation;
        int color = ((int)(waypoint.red * 255.0f) & 0xFF) << 16 | ((int)(waypoint.green * 255.0f) & 0xFF) << 8 | (int)(waypoint.blue * 255.0f) & 0xFF;
        Object hexColor = Integer.toHexString(color);
        while (((String)hexColor).length() < 6) {
            hexColor = "0" + (String)hexColor;
        }
        hexColor = "#" + (String)hexColor;
        String world = AbstractVoxelMap.getInstance().getWaypointManager().getCurrentSubworldDescriptor(false);
        if (waypoint.world != null && waypoint.world != "") {
            world = waypoint.world;
        }
        String suffix = waypoint.imageSuffix;
        Object[] args = new Object[]{TextUtils.scrubNameRegex(waypoint.name), waypoint.getX(), waypoint.getY(), waypoint.getZ(), resourceLocation.toString()};
        Object message = String.format("[name:%s, x:%s, y:%s, z:%s, dim:%s", args);
        if (world != null && !world.equals("")) {
            message = (String)message + ", world:" + world;
        }
        if (suffix != null && !suffix.equals("")) {
            message = (String)message + ", icon:" + suffix;
        }
        message = (String)message + "]";
        class_310.method_1551().method_1507((class_437)new GuiSelectPlayer(null, AbstractVoxelMap.getInstance(), (String)message, true));
    }

    public static void sendCoordinate(int x, int y, int z) {
        String message = String.format("[x:%s, y:%s, z:%s]", x, y, z);
        class_310.method_1551().method_1507((class_437)new GuiSelectPlayer(null, AbstractVoxelMap.getInstance(), message, false));
    }

    public static void teleport(String command) {
        String details = command.substring(TELEPORT_COMMAND_LENGTH);
        for (Waypoint wp : AbstractVoxelMap.getInstance().getWaypointManager().getWaypoints()) {
            boolean mp;
            if (!wp.name.equalsIgnoreCase(details) || !wp.inDimension || !wp.inWorld) continue;
            boolean bl = mp = !class_310.method_1551().method_1496();
            int y = wp.getY() > class_310.method_1551().field_1687.method_31607() ? wp.getY() : (!class_310.method_1551().field_1724.field_6002.method_8597().method_27998() ? class_310.method_1551().field_1687.method_31600() : 64);
            class_310.method_1551().field_1724.method_3142("/tp " + class_310.method_1551().field_1724.method_5477().getString() + " " + wp.getX() + " " + y + " " + wp.getZ());
            if (mp) {
                class_310.method_1551().field_1724.method_3142("/tppos " + wp.getX() + " " + y + " " + wp.getZ());
            }
            return;
        }
    }

    public static int getSafeHeight(int x, int y, int z, class_1937 worldObj) {
        boolean inNetherDimension = worldObj.method_8597().method_27998();
        class_2338 blockPos = new class_2338(x, y, z);
        worldObj.method_22350(blockPos);
        worldObj.method_8398().method_12121(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4, class_2806.field_12803, true);
        if (inNetherDimension) {
            int safeY = -1;
            for (int t = 0; t < 127; ++t) {
                if (y + t < 127 && CommandUtils.isBlockStandable(worldObj, x, y + t, z) && CommandUtils.isBlockOpen(worldObj, x, y + t + 1, z) && CommandUtils.isBlockOpen(worldObj, x, y + t + 2, z)) {
                    safeY = y + t + 1;
                    t = 128;
                }
                if (y - t <= 0 || !CommandUtils.isBlockStandable(worldObj, x, y - t, z) || !CommandUtils.isBlockOpen(worldObj, x, y - t + 1, z) || !CommandUtils.isBlockOpen(worldObj, x, y - t + 2, z)) continue;
                safeY = y - t + 1;
                t = 128;
            }
            y = safeY;
        } else if (y <= 0) {
            y = worldObj.method_8624(class_2902.class_2903.field_13203, x, z) + 1;
        }
        return y;
    }

    private static boolean isBlockStandable(class_1937 worldObj, int par1, int par2, int par3) {
        class_2338 blockPos = new class_2338(par1, par2, par3);
        class_2680 blockState = worldObj.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        return block == null ? false : blockState.method_26207().method_15804();
    }

    private static boolean isBlockOpen(class_1937 worldObj, int par1, int par2, int par3) {
        class_2338 blockPos = new class_2338(par1, par2, par3);
        class_2680 blockState = worldObj.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        return block == null ? true : !blockState.method_26228((class_1922)worldObj, blockPos);
    }
}

