/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.Map;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.Radar;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSimple;
import com.mamiyaotaru.voxelmap.SettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IDimensionManager;
import com.mamiyaotaru.voxelmap.interfaces.IMap;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.interfaces.ISettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.persistent.PersistentMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.DimensionManager;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.MapUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.TickCounter;
import com.mamiyaotaru.voxelmap.util.WorldUpdateListener;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import net.minecraft.class_3902;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VoxelMap
extends AbstractVoxelMap
implements class_3302 {
    public static MapSettingsManager mapOptions = null;
    public static RadarSettingsManager radarOptions = null;
    private PersistentMapSettingsManager persistentMapOptions = null;
    private IMap map = null;
    private IRadar radar = null;
    private IRadar radarSimple = null;
    private PersistentMap persistentMap = null;
    private ISettingsAndLightingChangeNotifier settingsAndLightingChangeNotifier = null;
    private WorldUpdateListener worldUpdateListener = null;
    private IColorManager colorManager = null;
    private IWaypointManager waypointManager = null;
    private IDimensionManager dimensionManager = null;
    private class_638 world;
    private String worldName = "";
    private static String passMessage = null;
    private static final Logger logger = LogManager.getLogger((String)"VoxelMap");

    public VoxelMap() {
        instance = this;
    }

    public void lateInit(boolean showUnderMenus, boolean isFair) {
        GLUtils.textureManager = class_310.method_1551().method_1531();
        mapOptions = new MapSettingsManager();
        VoxelMap.mapOptions.showUnderMenus = showUnderMenus;
        radarOptions = new RadarSettingsManager();
        mapOptions.addSecondaryOptionsManager(radarOptions);
        this.persistentMapOptions = new PersistentMapSettingsManager();
        mapOptions.addSecondaryOptionsManager(this.persistentMapOptions);
        BiomeRepository.loadBiomeColors();
        this.colorManager = new ColorManager(this);
        this.waypointManager = new WaypointManager(this);
        this.dimensionManager = new DimensionManager(this);
        this.persistentMap = new PersistentMap(this);
        mapOptions.loadAll();
        try {
            if (isFair) {
                VoxelMap.radarOptions.radarAllowed = false;
                VoxelMap.radarOptions.radarMobsAllowed = false;
                VoxelMap.radarOptions.radarPlayersAllowed = false;
            } else {
                VoxelMap.radarOptions.radarAllowed = true;
                VoxelMap.radarOptions.radarMobsAllowed = true;
                VoxelMap.radarOptions.radarPlayersAllowed = true;
                this.radar = new Radar(this);
                this.radarSimple = new RadarSimple(this);
            }
        }
        catch (Exception var4) {
            System.err.println("Failed creating radar " + var4.getLocalizedMessage());
            var4.printStackTrace();
            VoxelMap.radarOptions.radarAllowed = false;
            VoxelMap.radarOptions.radarMobsAllowed = false;
            VoxelMap.radarOptions.radarPlayersAllowed = false;
            this.radar = null;
            this.radarSimple = null;
        }
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            VoxelMap.radarOptions.radarPlayersAllowed = VoxelMap.radarOptions.radarAllowed = Boolean.valueOf(true);
            VoxelMap.radarOptions.radarMobsAllowed = VoxelMap.radarOptions.radarAllowed;
            VoxelMap.mapOptions.cavesAllowed = true;
        });
        this.map = new Map(this);
        this.settingsAndLightingChangeNotifier = new SettingsAndLightingChangeNotifier();
        this.worldUpdateListener = new WorldUpdateListener();
        this.worldUpdateListener.addListener(this.map);
        this.worldUpdateListener.addListener(this.persistentMap);
        class_3304 resourceManager = (class_3304)class_310.method_1551().method_1478();
        resourceManager.method_14477((class_3302)this);
        this.apply((class_3300)resourceManager);
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 resourceManager, class_3695 loadProfiler, class_3695 applyProfiler, Executor loadExecutor, Executor applyExecutor) {
        return synchronizer.method_18352((Object)class_3902.field_17274).thenRunAsync(() -> this.apply(resourceManager), applyExecutor);
    }

    private void apply(class_3300 resourceManager) {
        this.waypointManager.onResourceManagerReload(resourceManager);
        if (this.radar != null) {
            this.radar.onResourceManagerReload(resourceManager);
        }
        if (this.radarSimple != null) {
            this.radarSimple.onResourceManagerReload(resourceManager);
        }
        this.colorManager.onResourceManagerReload(resourceManager);
    }

    public void onTickInGame(class_4587 matrixStack, class_310 mc) {
        this.map.onTickInGame(matrixStack, mc);
        if (passMessage != null) {
            mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)passMessage));
            passMessage = null;
        }
    }

    public void onTick(class_310 mc) {
        if (GameVariableAccessShim.getWorld() != null && !GameVariableAccessShim.getWorld().equals(this.world) || this.world != null && !this.world.equals(GameVariableAccessShim.getWorld())) {
            this.world = GameVariableAccessShim.getWorld();
            this.waypointManager.newWorld((class_1937)this.world);
            this.persistentMap.newWorld(this.world);
            if (this.world != null) {
                MapUtils.reset();
                class_2540 buffer = new class_2540(Unpooled.buffer());
                buffer.writeBytes("worldinfo:world_id".getBytes(StandardCharsets.UTF_8));
                buffer.writeByte(0);
                buffer.writeBytes("voxelmap:settings".getBytes(StandardCharsets.UTF_8));
                mc.method_1562().method_2883((class_2596)new class_2817(new class_2960("minecraft:register"), buffer));
                ByteBuf wIdRequestBuf = Unpooled.buffer((int)3);
                wIdRequestBuf.writeByte(0);
                wIdRequestBuf.writeByte(42);
                wIdRequestBuf.writeByte(0);
                mc.field_1724.field_3944.method_2883((class_2596)new class_2817(new class_2960("worldinfo:world_id"), new class_2540(wIdRequestBuf)));
                mc.field_1724.method_3117();
                java.util.Map skinMap = mc.method_1582().method_4654(mc.field_1724.method_7334());
                if (skinMap.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    mc.method_1582().method_4656((MinecraftProfileTexture)skinMap.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                }
                if (!this.worldName.equals(this.waypointManager.getCurrentWorldName())) {
                    this.worldName = this.waypointManager.getCurrentWorldName();
                }
                this.map.newWorld(this.world);
            }
        }
        TickCounter.onTick();
        this.persistentMap.onTick(mc);
    }

    public static void checkPermissionMessages(class_2561 message) {
        String msg = TextUtils.asFormattedString(message);
        if ((msg = msg.replaceAll("\u00a7r", "")).contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7d")) {
            VoxelMap.mapOptions.cavesAllowed = false;
            VoxelMap.getLogger().info("Server disabled cavemapping.");
        }
        if (msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7e")) {
            VoxelMap.radarOptions.radarAllowed = false;
            VoxelMap.radarOptions.radarPlayersAllowed = false;
            VoxelMap.radarOptions.radarMobsAllowed = false;
            VoxelMap.getLogger().info("Server disabled radar.");
        }
        if (msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7f")) {
            VoxelMap.mapOptions.cavesAllowed = true;
            VoxelMap.getLogger().info("Server enabled cavemapping.");
        }
        if (msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a70")) {
            VoxelMap.radarOptions.radarAllowed = true;
            VoxelMap.radarOptions.radarPlayersAllowed = true;
            VoxelMap.radarOptions.radarMobsAllowed = true;
            VoxelMap.getLogger().info("Server enabled radar.");
        }
    }

    @Override
    public MapSettingsManager getMapOptions() {
        return mapOptions;
    }

    @Override
    public RadarSettingsManager getRadarOptions() {
        return radarOptions;
    }

    @Override
    public PersistentMapSettingsManager getPersistentMapOptions() {
        return this.persistentMapOptions;
    }

    @Override
    public IMap getMap() {
        return this.map;
    }

    @Override
    public ISettingsAndLightingChangeNotifier getSettingsAndLightingChangeNotifier() {
        return this.settingsAndLightingChangeNotifier;
    }

    @Override
    public IRadar getRadar() {
        if (VoxelMap.radarOptions.showRadar) {
            if (VoxelMap.radarOptions.radarMode == 1) {
                return this.radarSimple;
            }
            if (VoxelMap.radarOptions.radarMode == 2) {
                return this.radar;
            }
        }
        return null;
    }

    @Override
    public IColorManager getColorManager() {
        return this.colorManager;
    }

    @Override
    public IWaypointManager getWaypointManager() {
        return this.waypointManager;
    }

    @Override
    public IDimensionManager getDimensionManager() {
        return this.dimensionManager;
    }

    @Override
    public IPersistentMap getPersistentMap() {
        return this.persistentMap;
    }

    @Override
    public void setPermissions(boolean hasFullRadarPermission, boolean hasPlayersOnRadarPermission, boolean hasMobsOnRadarPermission, boolean hasCavemodePermission) {
        VoxelMap.radarOptions.radarAllowed = hasFullRadarPermission;
        VoxelMap.radarOptions.radarPlayersAllowed = hasPlayersOnRadarPermission;
        VoxelMap.radarOptions.radarMobsAllowed = hasMobsOnRadarPermission;
        VoxelMap.mapOptions.cavesAllowed = hasCavemodePermission;
    }

    @Override
    public synchronized void newSubWorldName(String name, boolean fromServer) {
        this.waypointManager.setSubworldName(name, fromServer);
        this.map.newWorldName();
    }

    @Override
    public synchronized void newSubWorldHash(String hash) {
        this.waypointManager.setSubworldHash(hash);
    }

    @Override
    public String getWorldSeed() {
        if (class_310.method_1551().method_1496()) {
            String seed = "";
            try {
                seed = Long.toString(class_310.method_1551().method_1576().method_3847(class_1937.field_25179).method_8412());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return seed;
        }
        return this.waypointManager.getWorldSeed();
    }

    @Override
    public void setWorldSeed(String newSeed) {
        if (!class_310.method_1551().method_1496()) {
            this.waypointManager.setWorldSeed(newSeed);
        }
    }

    @Override
    public void sendPlayerMessageOnMainThread(String s) {
        passMessage = s;
    }

    @Override
    public WorldUpdateListener getWorldUpdateListener() {
        return this.worldUpdateListener;
    }

    public static Logger getLogger() {
        return logger;
    }
}

