/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.fabricmod;

import com.google.gson.Gson;
import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2658;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_7591;

public class FabricModVoxelMap
implements ClientModInitializer {
    public static FabricModVoxelMap instance;
    private boolean initialized = false;
    private VoxelMap master = null;

    public void onInitializeClient() {
        instance = this;
        this.master = new VoxelMap();
    }

    public void lateInit() {
        this.initialized = true;
        this.master.lateInit(true, false);
        Runtime.getRuntime().addShutdownHook(new Thread(this::onShutDown));
    }

    public void clientTick(class_310 client) {
        if (!this.initialized) {
            boolean OK;
            boolean bl = OK = class_310.method_1551() != null && client.method_1478() != null && client.method_1531() != null;
            if (OK) {
                this.lateInit();
            }
        }
        if (this.initialized) {
            this.master.onTick(client);
        }
    }

    public void renderOverlay(class_4587 matrixStack) {
        if (!this.initialized) {
            this.lateInit();
        }
        try {
            this.master.onTickInGame(matrixStack, class_310.method_1551());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean onChat(class_2561 chat, class_7591 indicator) {
        return CommandUtils.checkForWaypoints(chat, indicator);
    }

    public boolean onSendChatMessage(String message) {
        if (message.startsWith("newWaypoint")) {
            CommandUtils.waypointClicked(message);
            return false;
        }
        if (message.startsWith("ztp")) {
            CommandUtils.teleport(message);
            return false;
        }
        return true;
    }

    public static void onRenderHand(float partialTicks, long timeSlice, class_4587 matrixStack, boolean beacons, boolean signs, boolean withDepth, boolean withoutDepth) {
        try {
            FabricModVoxelMap.instance.master.getWaypointManager().renderWaypoints(partialTicks, matrixStack, beacons, signs, withDepth, withoutDepth);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onShutDown() {
        System.out.print("Saving all world maps");
        FabricModVoxelMap.instance.master.getPersistentMap().purgeCachedRegions();
        FabricModVoxelMap.instance.master.getMapOptions().saveAll();
        BiomeRepository.saveBiomeColors();
        long shutdownTime = System.currentTimeMillis();
        while (ThreadManager.executorService.getQueue().size() + ThreadManager.executorService.getActiveCount() > 0 && System.currentTimeMillis() - shutdownTime < 10000L) {
            System.out.print(".");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println();
    }

    public boolean handleCustomPayload(class_2658 packet) {
        if (packet != null && packet.method_11456() != null) {
            class_2540 buffer = packet.method_11458();
            String channelName = packet.method_11456().toString();
            if (channelName.equals("worldinfo:world_id")) {
                byte length;
                buffer.readByte();
                byte b = buffer.readByte();
                if (b == 42) {
                    length = buffer.readByte();
                } else {
                    if (b == 0) {
                        VoxelMap.getLogger().warn("Received unknown world_id packet");
                        return true;
                    }
                    VoxelMap.getLogger().warn("Assuming legacy world_id packet. The support might be removed in the future versions.");
                    length = b;
                }
                byte[] bytes = new byte[length];
                buffer.readBytes(bytes);
                String subWorldName = new String(bytes, StandardCharsets.UTF_8);
                this.master.newSubWorldName(subWorldName, true);
                return true;
            }
            if (channelName.equals("voxelmap:settings")) {
                buffer.readByte();
                Map settings = (Map)new Gson().fromJson(buffer.method_19772(), Map.class);
                block14: for (Map.Entry entry : settings.entrySet()) {
                    String setting = (String)entry.getKey();
                    Object value = entry.getValue();
                    switch (setting) {
                        case "worldName": {
                            if (value == null) continue block14;
                            this.master.newSubWorldName((String)value, true);
                            continue block14;
                        }
                        case "radarAllowed": {
                            this.master.getRadarOptions().radarAllowed = (boolean)((Boolean)value);
                            continue block14;
                        }
                        case "radarMobsAllowed": {
                            this.master.getRadarOptions().radarMobsAllowed = (boolean)((Boolean)value);
                            continue block14;
                        }
                        case "radarPlayersAllowed": {
                            this.master.getRadarOptions().radarPlayersAllowed = (boolean)((Boolean)value);
                            continue block14;
                        }
                        case "cavesAllowed": {
                            this.master.getMapOptions().cavesAllowed = (boolean)((Boolean)value);
                            continue block14;
                        }
                    }
                    VoxelMap.getLogger().warn("Unknown configuration option " + setting);
                }
                return true;
            }
        }
        return false;
    }
}

