/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1159;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_311;
import net.minecraft.class_6367;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class GLUtils {
    private static class_289 tessellator = class_289.method_1348();
    private static class_287 vertexBuffer = tessellator.method_1349();
    public static class_1060 textureManager;
    public static class_276 frameBuffer;
    public static int fboID;
    public static int rboID;
    public static int fboTextureID;
    public static int depthTextureID;
    private static int previousFBOID;
    private static int previousFBOIDREAD;
    private static int previousFBOIDDRAW;
    private static int previousProgram;
    public static boolean hasAlphaBits;
    public static final int fboSize = 512;
    public static final int fboRad = 256;
    private static final IntBuffer dataBuffer;

    public static void setupFrameBuffer() {
        previousFBOID = GL11.glGetInteger((int)36006);
        fboID = GL30.glGenFramebuffers();
        fboTextureID = GL11.glGenTextures();
        int width = 512;
        int height = 512;
        GL30.glBindFramebuffer((int)36160, (int)fboID);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(4 * width * height));
        GL11.glBindTexture((int)3553, (int)fboTextureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5120, (ByteBuffer)byteBuffer);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)fboTextureID, (int)0);
        rboID = GL30.glGenRenderbuffers();
        GL30.glBindRenderbuffer((int)36161, (int)rboID);
        GL30.glRenderbufferStorage((int)36161, (int)33190, (int)width, (int)height);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)rboID);
        GL30.glBindRenderbuffer((int)36161, (int)0);
        GLUtils.checkFramebufferStatus();
        GL30.glBindFramebuffer((int)36160, (int)previousFBOID);
        GlStateManager._bindTexture((int)0);
    }

    public static void setupFrameBufferUsingMinecraft() {
        frameBuffer = new class_6367(512, 512, true, class_310.field_1703);
        fboID = GLUtils.frameBuffer.field_1476;
        fboTextureID = frameBuffer.method_30277();
    }

    public static void setupFrameBufferUsingMinecraftUnrolled() {
        RenderSystem.assertOnRenderThreadOrInit();
        fboID = GL30.glGenFramebuffers();
        fboTextureID = GL11.glGenTextures();
        depthTextureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)depthTextureID);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)34892, (int)0);
        GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)512, (int)512, (int)0, (int)6402, (int)5126, (IntBuffer)null);
        GL11.glBindTexture((int)3553, (int)fboTextureID);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)512, (int)512, (int)0, (int)6408, (int)5121, (IntBuffer)null);
        GL30.glBindFramebuffer((int)36160, (int)fboID);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)fboTextureID, (int)0);
        GL30.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)depthTextureID, (int)0);
        GLUtils.checkFramebufferStatus();
        GlStateManager._clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        int i = 16384;
        GlStateManager._clearDepth((double)1.0);
        GlStateManager._clear((int)(i |= 0x100), (boolean)class_310.field_1703);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
        GlStateManager._bindTexture((int)0);
    }

    public static void checkFramebufferStatus() {
        int i = GL30.glCheckFramebufferStatus((int)36160);
        if (i != 36053) {
            if (i == 36054) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i == 36055) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i == 36059) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i == 36060) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i);
        }
    }

    public static void bindFrameBuffer() {
        previousFBOID = GL11.glGetInteger((int)36006);
        previousFBOIDREAD = GL11.glGetInteger((int)36010);
        previousFBOIDDRAW = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36160, (int)fboID);
        GL30.glBindFramebuffer((int)36008, (int)fboID);
        GL30.glBindFramebuffer((int)36009, (int)fboID);
    }

    public static void unbindFrameBuffer() {
        GL30.glBindFramebuffer((int)36160, (int)previousFBOID);
        GL30.glBindFramebuffer((int)36008, (int)previousFBOIDREAD);
        GL30.glBindFramebuffer((int)36009, (int)previousFBOIDDRAW);
    }

    public static void setMap(int x, int y) {
        GLUtils.setMap(x, y, 128);
    }

    public static void setMapWithScale(int x, int y, float scale) {
        GLUtils.setMap(x, y, (int)(128.0f * scale));
    }

    public static void setMap(float x, float y, int imageSize) {
        float scale = (float)imageSize / 4.0f;
        GLUtils.ldrawthree(x - scale, y + scale, 1.0, 0.0f, 1.0f);
        GLUtils.ldrawthree(x + scale, y + scale, 1.0, 1.0f, 1.0f);
        GLUtils.ldrawthree(x + scale, y - scale, 1.0, 1.0f, 0.0f);
        GLUtils.ldrawthree(x - scale, y - scale, 1.0, 0.0f, 0.0f);
    }

    public static void setMap(Sprite icon, float x, float y, float imageSize) {
        float halfWidth = imageSize / 4.0f;
        GLUtils.ldrawthree(x - halfWidth, y + halfWidth, 1.0, icon.getMinU(), icon.getMaxV());
        GLUtils.ldrawthree(x + halfWidth, y + halfWidth, 1.0, icon.getMaxU(), icon.getMaxV());
        GLUtils.ldrawthree(x + halfWidth, y - halfWidth, 1.0, icon.getMaxU(), icon.getMinV());
        GLUtils.ldrawthree(x - halfWidth, y - halfWidth, 1.0, icon.getMinU(), icon.getMinV());
    }

    public static int tex(BufferedImage paramImg) {
        int glid = TextureUtil.generateTextureId();
        int width = paramImg.getWidth();
        int height = paramImg.getHeight();
        int[] imageData = new int[width * height];
        paramImg.getRGB(0, 0, width, height, imageData, 0, width);
        GLShim.glBindTexture(3553, glid);
        dataBuffer.clear();
        dataBuffer.put(imageData, 0, width * height);
        dataBuffer.position(0).limit(width * height);
        GLShim.glTexParameteri(3553, 10241, 9729);
        GLShim.glTexParameteri(3553, 10240, 9729);
        GLShim.glPixelStorei(3314, 0);
        GLShim.glPixelStorei(3316, 0);
        GLShim.glPixelStorei(3315, 0);
        GLShim.glTexImage2D(3553, 0, 6408, width, height, 0, 32993, 33639, dataBuffer);
        return glid;
    }

    public static void img(String paramStr) {
        textureManager.method_22813(new class_2960(paramStr));
    }

    public static void img2(String paramStr) {
        RenderSystem.setShaderTexture((int)0, (class_2960)new class_2960(paramStr));
    }

    public static void img(class_2960 paramResourceLocation) {
        textureManager.method_22813(paramResourceLocation);
    }

    public static void img2(class_2960 paramResourceLocation) {
        RenderSystem.setShaderTexture((int)0, (class_2960)paramResourceLocation);
    }

    public static void disp(int paramInt) {
        GLShim.glBindTexture(3553, paramInt);
    }

    public static void disp2(int paramInt) {
        RenderSystem.setShaderTexture((int)0, (int)paramInt);
    }

    public static void register(class_2960 resourceLocation, class_1044 image) {
        textureManager.method_4616(resourceLocation, image);
    }

    public static class_1011 nativeImageFromBufferedImage(BufferedImage base) {
        int glid = GLUtils.tex(base);
        class_1011 nativeImage = new class_1011(base.getWidth(), base.getHeight(), false);
        RenderSystem.bindTexture((int)glid);
        nativeImage.method_4327(0, false);
        return nativeImage;
    }

    public static void drawPre() {
        vertexBuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
    }

    public static void drawPre(class_293 vertexFormat) {
        vertexBuffer.method_1328(class_293.class_5596.field_27382, vertexFormat);
    }

    public static void drawPost() {
        tessellator.method_1350();
    }

    public static void glah(int g) {
        GLShim.glDeleteTextures(g);
    }

    public static void ldrawone(int x, int y, double z, float u, float v) {
        vertexBuffer.method_22912((double)x, (double)y, z).method_22913(u, v).method_1344();
    }

    public static void ldrawtwo(double x, double y, double z) {
        vertexBuffer.method_22912(x, y, z).method_1344();
    }

    public static void ldrawthree(double x, double y, double z, float u, float v) {
        vertexBuffer.method_22912(x, y, z).method_22913(u, v).method_1344();
    }

    public static void ldrawthree(class_1159 matrix4f, double x, double y, double z, float u, float v) {
        vertexBuffer.method_22918(matrix4f, (float)x, (float)y, (float)z).method_22913(u, v).method_1344();
    }

    static {
        fboID = 0;
        rboID = 0;
        fboTextureID = 0;
        depthTextureID = 0;
        previousFBOID = 0;
        previousFBOIDREAD = 0;
        previousFBOIDDRAW = 0;
        previousProgram = 0;
        hasAlphaBits = false;
        dataBuffer = class_311.method_1596((int)0x1000000).asIntBuffer();
    }
}

