/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.Contact;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1456;
import net.minecraft.class_1463;
import net.minecraft.class_1493;
import net.minecraft.class_1569;
import net.minecraft.class_1590;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4466;
import net.minecraft.class_4587;
import net.minecraft.class_745;
import net.minecraft.class_7833;

public class RadarSimple
implements IRadar {
    private LayoutVariables layoutVariables = null;
    public final MapSettingsManager minimapOptions;
    public final RadarSettingsManager options;
    private final TextureAtlas textureAtlas;
    private boolean completedLoading = false;
    private int timer = 500;
    private float direction = 0.0f;
    private final ArrayList<Contact> contacts = new ArrayList(40);
    final UUID devUUID = UUID.fromString("9b37abb9-2487-4712-bb96-21a1e0b2023c");

    public RadarSimple(VoxelMap master) {
        this.minimapOptions = master.getMapOptions();
        this.options = master.getRadarOptions();
        this.textureAtlas = new TextureAtlas("pings");
        this.textureAtlas.method_4527(false, false);
    }

    @Override
    public void onResourceManagerReload(class_3300 resourceManager) {
        this.loadTexturePackIcons();
    }

    private void loadTexturePackIcons() {
        this.completedLoading = false;
        try {
            this.textureAtlas.reset();
            BufferedImage contact = ImageUtils.loadImage(new class_2960("voxelmap", "images/radar/contact.png"), 0, 0, 32, 32, 32, 32);
            contact = ImageUtils.fillOutline(contact, false, true, 32.0f, 32.0f, 0);
            this.textureAtlas.registerIconForBufferedImage("contact", contact);
            BufferedImage facing = ImageUtils.loadImage(new class_2960("voxelmap", "images/radar/contact_facing.png"), 0, 0, 32, 32, 32, 32);
            facing = ImageUtils.fillOutline(facing, false, true, 32.0f, 32.0f, 0);
            this.textureAtlas.registerIconForBufferedImage("facing", facing);
            this.textureAtlas.stitch();
            this.completedLoading = true;
        }
        catch (Exception var4) {
            VoxelConstants.getLogger().error("Failed getting mobs " + var4.getLocalizedMessage(), (Throwable)var4);
        }
    }

    @Override
    public void onTickInGame(class_4587 matrixStack, LayoutVariables layoutVariables) {
        if (this.options.radarAllowed || this.options.radarMobsAllowed || this.options.radarPlayersAllowed) {
            this.layoutVariables = layoutVariables;
            if (this.options.isChanged()) {
                this.timer = 500;
            }
            this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
            while (this.direction >= 360.0f) {
                this.direction -= 360.0f;
            }
            while (this.direction < 0.0f) {
                this.direction += 360.0f;
            }
            if (this.completedLoading && this.timer > 95) {
                this.calculateMobs();
                this.timer = 0;
            }
            ++this.timer;
            if (this.completedLoading) {
                this.renderMapMobs(matrixStack, this.layoutVariables.mapX, this.layoutVariables.mapY);
            }
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void calculateMobs() {
        this.contacts.clear();
        for (class_1297 entity : VoxelConstants.getMinecraft().field_1687.method_18112()) {
            try {
                if (entity == null || entity.method_5756((class_1657)VoxelConstants.getPlayer()) || (!this.options.showHostiles || !this.options.radarAllowed && !this.options.radarMobsAllowed || !this.isHostile(entity)) && (!this.options.showPlayers || !this.options.radarAllowed && !this.options.radarPlayersAllowed || !this.isPlayer(entity)) && (!this.options.showNeutrals || !this.options.radarMobsAllowed || !this.isNeutral(entity))) continue;
                int wayX = GameVariableAccessShim.xCoord() - (int)entity.method_19538().method_10216();
                int wayZ = GameVariableAccessShim.zCoord() - (int)entity.method_19538().method_10215();
                int wayY = GameVariableAccessShim.yCoord() - (int)entity.method_19538().method_10214();
                double hypot = wayX * wayX + wayZ * wayZ + wayY * wayY;
                if (!((hypot /= this.layoutVariables.zoomScaleAdjusted * this.layoutVariables.zoomScaleAdjusted) < 961.0)) continue;
                Contact contact2 = new Contact(entity, this.getUnknownMobNeutrality(entity));
                String unscrubbedName = contact2.entity.method_5476().getString();
                contact2.setName(unscrubbedName);
                contact2.updateLocation();
                this.contacts.add(contact2);
            }
            catch (Exception var11) {
                VoxelConstants.getLogger().error(var11.getLocalizedMessage(), (Throwable)var11);
            }
        }
        this.contacts.sort(Comparator.comparingInt(contact -> contact.y));
    }

    private EnumMobs getUnknownMobNeutrality(class_1297 entity) {
        if (this.isHostile(entity)) {
            return EnumMobs.GENERICHOSTILE;
        }
        return !(entity instanceof class_1321) || !((class_1321)entity).method_6181() || !VoxelConstants.getMinecraft().method_1496() && !((class_1321)entity).method_6177().equals((Object)VoxelConstants.getPlayer()) ? EnumMobs.GENERICNEUTRAL : EnumMobs.GENERICTAME;
    }

    private boolean isHostile(class_1297 entity) {
        if (entity instanceof class_1590) {
            class_1590 zombifiedPiglinEntity = (class_1590)entity;
            return zombifiedPiglinEntity.method_7076((class_1657)VoxelConstants.getPlayer());
        }
        if (entity instanceof class_1569) {
            return true;
        }
        if (entity instanceof class_4466) {
            class_4466 beeEntity = (class_4466)entity;
            return beeEntity.method_29511();
        }
        if (entity instanceof class_1456) {
            class_1456 polarBearEntity = (class_1456)entity;
            for (class_1456 object : polarBearEntity.field_6002.method_18467(class_1456.class, polarBearEntity.method_5829().method_1009(8.0, 4.0, 8.0))) {
                if (!object.method_6109()) continue;
                return true;
            }
        }
        if (entity instanceof class_1463) {
            class_1463 rabbitEntity = (class_1463)entity;
            return rabbitEntity.method_47855().method_47856() == 99;
        }
        if (entity instanceof class_1493) {
            class_1493 wolfEntity = (class_1493)entity;
            return wolfEntity.method_29511();
        }
        return false;
    }

    private boolean isPlayer(class_1297 entity) {
        return entity instanceof class_745;
    }

    private boolean isNeutral(class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return false;
        }
        return !(entity instanceof class_1657) && !this.isHostile(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderMapMobs(class_4587 matrixStack, int x, int y) {
        double max = this.layoutVariables.zoomScaleAdjusted * 32.0;
        GLUtils.disp2(this.textureAtlas.method_4624());
        for (Contact contact : this.contacts) {
            boolean inRange;
            contact.updateLocation();
            double contactX = contact.x;
            double contactZ = contact.z;
            int contactY = contact.y;
            double wayX = GameVariableAccessShim.xCoordDouble() - contactX;
            double wayZ = GameVariableAccessShim.zCoordDouble() - contactZ;
            int wayY = GameVariableAccessShim.yCoord() - contactY;
            double adjustedDiff = max - (double)Math.max(Math.abs(wayY), 0);
            contact.brightness = (float)Math.max(adjustedDiff / max, 0.0);
            contact.brightness *= contact.brightness;
            contact.angle = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
            contact.distance = Math.sqrt(wayX * wayX + wayZ * wayZ) / this.layoutVariables.zoomScaleAdjusted;
            GLShim.glBlendFunc(770, 771);
            if (wayY < 0) {
                GLShim.glColor4f(1.0f, 1.0f, 1.0f, contact.brightness);
            } else {
                GLShim.glColor3f(contact.brightness, contact.brightness, contact.brightness);
            }
            if (this.minimapOptions.rotates) {
                contact.angle += this.direction;
            } else if (this.minimapOptions.oldNorth) {
                contact.angle -= 90.0f;
            }
            if (!this.minimapOptions.squareMap) {
                inRange = contact.distance < 31.0;
            } else {
                double radLocate = Math.toRadians(contact.angle);
                double dispX = contact.distance * Math.cos(radLocate);
                double dispY = contact.distance * Math.sin(radLocate);
                boolean bl = inRange = Math.abs(dispX) <= 28.5 && Math.abs(dispY) <= 28.5;
            }
            if (!inRange) continue;
            try {
                matrixStack.method_22903();
                float contactFacing = contact.entity.method_5791();
                if (this.minimapOptions.rotates) {
                    contactFacing -= this.direction;
                } else if (this.minimapOptions.oldNorth) {
                    contactFacing += 90.0f;
                }
                matrixStack.method_22904((double)x, (double)y, 0.0);
                matrixStack.method_22907(class_7833.field_40718.rotationDegrees(-contact.angle));
                matrixStack.method_22904(0.0, -contact.distance, 0.0);
                matrixStack.method_22907(class_7833.field_40718.rotationDegrees(contact.angle + contactFacing));
                matrixStack.method_22904((double)(-x), (double)(-y), 0.0);
                RenderSystem.applyModelViewMatrix();
                this.applyFilteringParameters();
                GLUtils.drawPre();
                GLUtils.setMap(this.textureAtlas.getAtlasSprite("contact"), x, y, 16.0f);
                GLUtils.drawPost();
                if (!this.options.showFacing) continue;
                this.applyFilteringParameters();
                GLUtils.drawPre();
                GLUtils.setMap(this.textureAtlas.getAtlasSprite("facing"), x, y, 16.0f);
                GLUtils.drawPost();
            }
            catch (Exception e) {
                VoxelConstants.getLogger().error("Error rendering mob icon! " + e.getLocalizedMessage() + " contact type " + contact.type, (Throwable)e);
            }
            finally {
                matrixStack.method_22909();
                RenderSystem.applyModelViewMatrix();
            }
        }
    }

    private void applyFilteringParameters() {
        if (this.options.filtering) {
            GLShim.glTexParameteri(3553, 10241, 9729);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLShim.glTexParameteri(3553, 10242, 10496);
            GLShim.glTexParameteri(3553, 10243, 10496);
        } else {
            GLShim.glTexParameteri(3553, 10241, 9728);
            GLShim.glTexParameteri(3553, 10240, 9728);
        }
    }
}

