/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.Map;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.Radar;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSimple;
import com.mamiyaotaru.voxelmap.SettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.persistent.PersistentMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.DimensionManager;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.MapUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.TickCounter;
import com.mamiyaotaru.voxelmap.util.WorldUpdateListener;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import net.minecraft.class_3902;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_638;

public class VoxelMap
implements class_3302 {
    public static MapSettingsManager mapOptions;
    public static RadarSettingsManager radarOptions;
    private PersistentMapSettingsManager persistentMapOptions;
    private Map map;
    private IRadar radar;
    private IRadar radarSimple;
    private PersistentMap persistentMap;
    private SettingsAndLightingChangeNotifier settingsAndLightingChangeNotifier;
    private WorldUpdateListener worldUpdateListener = null;
    private ColorManager colorManager;
    private WaypointManager waypointManager;
    private DimensionManager dimensionManager;
    private class_638 world;
    private String worldName = "";
    private static String passMessage;

    VoxelMap() {
    }

    public void lateInit(boolean showUnderMenus, boolean isFair) {
        GLUtils.textureManager = VoxelConstants.getMinecraft().method_1531();
        mapOptions = new MapSettingsManager();
        VoxelMap.mapOptions.showUnderMenus = showUnderMenus;
        radarOptions = new RadarSettingsManager();
        mapOptions.addSecondaryOptionsManager(radarOptions);
        this.persistentMapOptions = new PersistentMapSettingsManager();
        mapOptions.addSecondaryOptionsManager(this.persistentMapOptions);
        BiomeRepository.loadBiomeColors();
        this.colorManager = new ColorManager(this);
        this.waypointManager = new WaypointManager(this);
        this.dimensionManager = new DimensionManager(this);
        this.persistentMap = new PersistentMap(this);
        mapOptions.loadAll();
        try {
            if (isFair) {
                VoxelMap.radarOptions.radarAllowed = false;
                VoxelMap.radarOptions.radarMobsAllowed = false;
                VoxelMap.radarOptions.radarPlayersAllowed = false;
            } else {
                VoxelMap.radarOptions.radarAllowed = true;
                VoxelMap.radarOptions.radarMobsAllowed = true;
                VoxelMap.radarOptions.radarPlayersAllowed = true;
                this.radar = new Radar(this);
                this.radarSimple = new RadarSimple(this);
            }
        }
        catch (RuntimeException var4) {
            VoxelConstants.getLogger().error("Failed creating radar " + var4.getLocalizedMessage(), (Throwable)var4);
            VoxelMap.radarOptions.radarAllowed = false;
            VoxelMap.radarOptions.radarMobsAllowed = false;
            VoxelMap.radarOptions.radarPlayersAllowed = false;
            this.radar = null;
            this.radarSimple = null;
        }
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            VoxelMap.radarOptions.radarAllowed = true;
            VoxelMap.radarOptions.radarPlayersAllowed = true;
            VoxelMap.radarOptions.radarMobsAllowed = true;
            VoxelMap.mapOptions.cavesAllowed = true;
        });
        this.map = new Map(this);
        this.settingsAndLightingChangeNotifier = new SettingsAndLightingChangeNotifier();
        this.worldUpdateListener = new WorldUpdateListener();
        this.worldUpdateListener.addListener(this.map);
        this.worldUpdateListener.addListener(this.persistentMap);
        class_3304 resourceManager = (class_3304)VoxelConstants.getMinecraft().method_1478();
        resourceManager.method_14477((class_3302)this);
        this.apply((class_3300)resourceManager);
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return synchronizer.method_18352((Object)class_3902.field_17274).thenRunAsync(() -> this.apply(manager), applyExecutor);
    }

    private void apply(class_3300 resourceManager) {
        this.waypointManager.onResourceManagerReload(resourceManager);
        if (this.radar != null) {
            this.radar.onResourceManagerReload(resourceManager);
        }
        if (this.radarSimple != null) {
            this.radarSimple.onResourceManagerReload(resourceManager);
        }
        this.colorManager.onResourceManagerReload(resourceManager);
    }

    public void onTickInGame(class_4587 matrixStack) {
        this.map.onTickInGame(matrixStack);
        if (passMessage != null) {
            VoxelConstants.getMinecraft().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)passMessage));
            passMessage = null;
        }
    }

    public void onTick() {
        if (GameVariableAccessShim.getWorld() != null && !GameVariableAccessShim.getWorld().equals(this.world) || this.world != null && !this.world.equals(GameVariableAccessShim.getWorld())) {
            this.world = GameVariableAccessShim.getWorld();
            this.waypointManager.newWorld((class_1937)this.world);
            this.persistentMap.newWorld(this.world);
            if (this.world != null) {
                MapUtils.reset();
                class_2540 buffer = new class_2540(Unpooled.buffer());
                buffer.writeBytes("worldinfo:world_id".getBytes(StandardCharsets.UTF_8));
                buffer.writeByte(0);
                buffer.writeBytes("voxelmap:settings".getBytes(StandardCharsets.UTF_8));
                VoxelConstants.getMinecraft().method_1562().method_2883((class_2596)new class_2817(new class_2960("minecraft:register"), buffer));
                ByteBuf wIdRequestBuf = Unpooled.buffer((int)3);
                wIdRequestBuf.writeByte(0);
                wIdRequestBuf.writeByte(42);
                wIdRequestBuf.writeByte(0);
                VoxelConstants.getPlayer().field_3944.method_2883((class_2596)new class_2817(new class_2960("worldinfo:world_id"), new class_2540(wIdRequestBuf)));
                VoxelConstants.getPlayer().method_3117();
                java.util.Map skinMap = VoxelConstants.getMinecraft().method_1582().method_4654(VoxelConstants.getPlayer().method_7334());
                if (skinMap.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    VoxelConstants.getMinecraft().method_1582().method_4656((MinecraftProfileTexture)skinMap.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                }
                if (!this.worldName.equals(this.waypointManager.getCurrentWorldName())) {
                    this.worldName = this.waypointManager.getCurrentWorldName();
                }
                this.map.newWorld(this.world);
            }
        }
        TickCounter.onTick();
        this.persistentMap.onTick();
    }

    public static void checkPermissionMessages(class_2561 message) {
        String msg = TextUtils.asFormattedString(message);
        if ((msg = msg.replaceAll("\u00a7r", "")).contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7d")) {
            VoxelMap.mapOptions.cavesAllowed = false;
            VoxelConstants.getLogger().info("Server disabled cavemapping.");
        }
        if (msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7e")) {
            VoxelMap.radarOptions.radarAllowed = false;
            VoxelMap.radarOptions.radarPlayersAllowed = false;
            VoxelMap.radarOptions.radarMobsAllowed = false;
            VoxelConstants.getLogger().info("Server disabled radar.");
        }
        if (msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7f")) {
            VoxelMap.mapOptions.cavesAllowed = true;
            VoxelConstants.getLogger().info("Server enabled cavemapping.");
        }
        if (msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a70")) {
            VoxelMap.radarOptions.radarAllowed = true;
            VoxelMap.radarOptions.radarPlayersAllowed = true;
            VoxelMap.radarOptions.radarMobsAllowed = true;
            VoxelConstants.getLogger().info("Server enabled radar.");
        }
    }

    public MapSettingsManager getMapOptions() {
        return mapOptions;
    }

    public RadarSettingsManager getRadarOptions() {
        return radarOptions;
    }

    public PersistentMapSettingsManager getPersistentMapOptions() {
        return this.persistentMapOptions;
    }

    public Map getMap() {
        return this.map;
    }

    public SettingsAndLightingChangeNotifier getSettingsAndLightingChangeNotifier() {
        return this.settingsAndLightingChangeNotifier;
    }

    public IRadar getRadar() {
        if (VoxelMap.radarOptions.showRadar) {
            if (VoxelMap.radarOptions.radarMode == 1) {
                return this.radarSimple;
            }
            if (VoxelMap.radarOptions.radarMode == 2) {
                return this.radar;
            }
        }
        return null;
    }

    public ColorManager getColorManager() {
        return this.colorManager;
    }

    public WaypointManager getWaypointManager() {
        return this.waypointManager;
    }

    public DimensionManager getDimensionManager() {
        return this.dimensionManager;
    }

    public IPersistentMap getPersistentMap() {
        return this.persistentMap;
    }

    public void setPermissions(boolean hasFullRadarPermission, boolean hasPlayersOnRadarPermission, boolean hasMobsOnRadarPermission, boolean hasCavemodePermission) {
        VoxelMap.radarOptions.radarAllowed = hasFullRadarPermission;
        VoxelMap.radarOptions.radarPlayersAllowed = hasPlayersOnRadarPermission;
        VoxelMap.radarOptions.radarMobsAllowed = hasMobsOnRadarPermission;
        VoxelMap.mapOptions.cavesAllowed = hasCavemodePermission;
    }

    public synchronized void newSubWorldName(String name, boolean fromServer) {
        this.waypointManager.setSubworldName(name, fromServer);
        this.map.newWorldName();
    }

    public synchronized void newSubWorldHash(String hash) {
        this.waypointManager.setSubworldHash(hash);
    }

    public String getWorldSeed() {
        return VoxelConstants.getWorldByKey((class_5321<class_1937>)class_1937.field_25179).map(value -> Long.toString(((class_3218)value).method_8412())).orElse("");
    }

    public void setWorldSeed(String newSeed) {
        if (VoxelConstants.getIntegratedServer().isEmpty()) {
            this.waypointManager.setWorldSeed(newSeed);
        }
    }

    public void sendPlayerMessageOnMainThread(String s) {
        passMessage = s;
    }

    public WorldUpdateListener getWorldUpdateListener() {
        return this.worldUpdateListener;
    }
}

