/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.textures.IIconCreator;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.BackgroundImageInfo;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.MessageUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mamiyaotaru.voxelmap.util.WaypointContainer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.minecraft.class_1132;
import net.minecraft.class_1937;
import net.minecraft.class_2535;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4587;
import net.minecraft.class_5218;
import net.minecraft.class_634;
import net.minecraft.class_642;
import net.minecraft.class_7134;

public class WaypointManager {
    final VoxelMap master;
    public final MapSettingsManager options;
    final TextureAtlas textureAtlas;
    final TextureAtlas textureAtlasChooser;
    private boolean loaded;
    private boolean needSave;
    private ArrayList<Waypoint> wayPts = new ArrayList();
    private Waypoint highlightedWaypoint;
    private String worldName = "";
    private String currentSubWorldName = "";
    private String currentSubworldDescriptor = "";
    private String currentSubworldDescriptorNoCodes = "";
    private boolean multiworld;
    private boolean gotAutoSubworldName;
    private DimensionContainer currentDimension;
    private final TreeSet<String> knownSubworldNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private final HashSet<String> oldNorthWorldNames = new HashSet();
    private final HashMap<String, String> worldSeeds = new HashMap();
    private BackgroundImageInfo backgroundImageInfo = null;
    private WaypointContainer waypointContainer;
    private File settingsFile;
    private Long lastNewWorldNameTime = 0L;
    private final Object waypointLock = new Object();

    public WaypointManager(VoxelMap master) {
        this.master = master;
        this.options = master.getMapOptions();
        this.textureAtlas = new TextureAtlas("waypoints");
        this.textureAtlas.method_4527(false, false);
        this.textureAtlasChooser = new TextureAtlas("chooser");
        this.textureAtlasChooser.method_4527(false, false);
        this.waypointContainer = new WaypointContainer(this.options);
    }

    public void onResourceManagerReload(class_3300 resourceManager) {
        ArrayList images = new ArrayList();
        IIconCreator iconCreator = textureAtlas -> {
            Map resourceMap = VoxelConstants.getMinecraft().method_1478().method_14488("images", asset -> asset.method_12832().endsWith(".png"));
            for (class_2960 candidate : resourceMap.keySet()) {
                if (!candidate.method_12836().equals("voxelmap") || !candidate.method_12832().contains("images/waypoints")) continue;
                images.add(candidate);
            }
            Sprite markerIcon = textureAtlas.registerIconForResource(new class_2960("voxelmap", "images/waypoints/marker.png"), VoxelConstants.getMinecraft().method_1478());
            Sprite markerIconSmall = textureAtlas.registerIconForResource(new class_2960("voxelmap", "images/waypoints/markersmall.png"), VoxelConstants.getMinecraft().method_1478());
            for (class_2960 resourceLocation : images) {
                Sprite icon = textureAtlas.registerIconForResource(resourceLocation, VoxelConstants.getMinecraft().method_1478());
                String name = resourceLocation.toString();
                if (name.toLowerCase().contains("waypoints/waypoint") && !name.toLowerCase().contains("small")) {
                    textureAtlas.registerMaskedIcon(name.replace(".png", "Small.png"), icon);
                    textureAtlas.registerMaskedIcon(name.replace("waypoints/waypoint", "waypoints/marker"), markerIcon);
                    textureAtlas.registerMaskedIcon(name.replace("waypoints/waypoint", "waypoints/marker").replace(".png", "Small.png"), markerIconSmall);
                    continue;
                }
                if (!name.toLowerCase().contains("waypoints/marker") || name.toLowerCase().contains("small")) continue;
                textureAtlas.registerMaskedIcon(name.replace(".png", "Small.png"), icon);
            }
        };
        this.textureAtlas.loadTextureAtlas(iconCreator);
        GLShim.glTexParameteri(3553, 10241, 9729);
        GLShim.glTexParameteri(3553, 10240, 9729);
        this.textureAtlasChooser.reset();
        int expectedSize = 32;
        for (class_2960 resourceLocation : images) {
            String name = resourceLocation.toString();
            if (!name.toLowerCase().contains("waypoints/waypoint") || name.toLowerCase().contains("small")) continue;
            try {
                Optional imageResource = resourceManager.method_14486(resourceLocation);
                BufferedImage bufferedImage = ImageIO.read(((class_3298)imageResource.get()).method_14482());
                ((class_3298)imageResource.get()).method_43039().close();
                float scale = (float)expectedSize / (float)bufferedImage.getWidth();
                bufferedImage = ImageUtils.scaleImage(bufferedImage, scale);
                this.textureAtlasChooser.registerIconForBufferedImage(name, bufferedImage);
            }
            catch (IOException var11) {
                this.textureAtlasChooser.registerIconForResource(resourceLocation, VoxelConstants.getMinecraft().method_1478());
            }
        }
        this.textureAtlasChooser.stitch();
    }

    public TextureAtlas getTextureAtlas() {
        return this.textureAtlas;
    }

    public TextureAtlas getTextureAtlasChooser() {
        return this.textureAtlasChooser;
    }

    public ArrayList<Waypoint> getWaypoints() {
        return this.wayPts;
    }

    public void newWorld(class_1937 world) {
        if (world == null) {
            this.currentDimension = null;
        } else {
            String mapName;
            if (VoxelConstants.getMinecraft().method_1496()) {
                mapName = this.getMapName();
            } else {
                mapName = this.getServerName();
                if (mapName != null) {
                    mapName = mapName.toLowerCase();
                }
            }
            if (!this.worldName.equals(mapName) && mapName != null && !mapName.isEmpty()) {
                this.currentDimension = null;
                this.worldName = mapName;
                this.master.getDimensionManager().populateDimensions(world);
                this.loadWaypoints();
            }
            this.master.getDimensionManager().enteredWorld(world);
            DimensionContainer dim = this.master.getDimensionManager().getDimensionContainerByWorld(world);
            this.enteredDimension(dim);
            this.setSubWorldDescriptor("");
        }
    }

    public String getMapName() {
        Optional<class_1132> integratedServer = VoxelConstants.getIntegratedServer();
        if (integratedServer.isEmpty()) {
            String error = "Tried fetching map name on a non-integrated server!";
            VoxelConstants.getLogger().fatal(error);
            throw new IllegalStateException(error);
        }
        return integratedServer.get().method_27050(class_5218.field_24188).normalize().toFile().getName();
    }

    public String getServerName() {
        Object serverName = "";
        try {
            class_642 serverData = VoxelConstants.getMinecraft().method_1558();
            if (serverData != null) {
                boolean isOnLAN = serverData.method_2994();
                if (isOnLAN) {
                    VoxelConstants.getLogger().warn("LAN server detected!");
                    serverName = serverData.field_3752;
                } else {
                    serverName = serverData.field_3761;
                }
            } else if (VoxelConstants.getMinecraft().method_1589()) {
                VoxelConstants.getLogger().warn("REALMS server detected!");
                serverName = "Realms";
            } else {
                class_634 netHandler = VoxelConstants.getMinecraft().method_1562();
                class_2535 networkManager = netHandler.method_2872();
                InetSocketAddress socketAddress = (InetSocketAddress)networkManager.method_10755();
                serverName = socketAddress.getHostString() + ":" + socketAddress.getPort();
            }
        }
        catch (Exception var6) {
            VoxelConstants.getLogger().error("error getting ServerData", (Throwable)var6);
        }
        return serverName;
    }

    public String getCurrentWorldName() {
        return this.worldName;
    }

    public void handleDeath() {
        HashSet<Waypoint> toDel = new HashSet<Waypoint>();
        for (Waypoint pt : this.wayPts) {
            if (pt.name.equals("Latest Death")) {
                pt.name = "Previous Death";
            }
            if (!pt.name.startsWith("Previous Death")) continue;
            if (this.options.deathpoints == 2) {
                int num = 0;
                try {
                    if (pt.name.length() > 15) {
                        num = Integer.parseInt(pt.name.substring(15));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                pt.red -= (pt.red - 0.5f) / 8.0f;
                pt.green -= (pt.green - 0.5f) / 8.0f;
                pt.blue -= (pt.blue - 0.5f) / 8.0f;
                pt.name = "Previous Death " + (num + 1);
                continue;
            }
            toDel.add(pt);
        }
        if (this.options.deathpoints != 2 && !toDel.isEmpty()) {
            for (Waypoint pt : toDel) {
                this.deleteWaypoint(pt);
            }
        }
        if (this.options.deathpoints != 0) {
            TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
            dimensions.add(VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByWorld((class_1937)VoxelConstants.getMinecraft().field_1687));
            double dimensionScale = VoxelConstants.getPlayer().field_6002.method_8597().comp_646();
            this.addWaypoint(new Waypoint("Latest Death", (int)((double)GameVariableAccessShim.xCoord() * dimensionScale), (int)((double)GameVariableAccessShim.zCoord() * dimensionScale), GameVariableAccessShim.yCoord() - 1, true, 1.0f, 1.0f, 1.0f, "Skull", this.getCurrentSubworldDescriptor(false), dimensions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enteredDimension(DimensionContainer dimension) {
        this.highlightedWaypoint = null;
        if (dimension == this.currentDimension) {
            this.multiworld = true;
        }
        this.currentDimension = dimension;
        Object object = this.waypointLock;
        synchronized (object) {
            this.waypointContainer = new WaypointContainer(this.options);
            for (Waypoint pt : this.wayPts) {
                pt.inDimension = pt.dimensions.isEmpty() || pt.dimensions.contains(dimension);
                this.waypointContainer.addWaypoint(pt);
            }
            this.waypointContainer.setHighlightedWaypoint(this.highlightedWaypoint);
        }
        this.loadBackgroundMapImage();
    }

    public void setOldNorth(boolean oldNorth) {
        String oldNorthWorldName = this.knownSubworldNames.isEmpty() ? "all" : this.getCurrentSubworldDescriptor(false);
        if (oldNorth) {
            this.oldNorthWorldNames.add(oldNorthWorldName);
        } else {
            this.oldNorthWorldNames.remove(oldNorthWorldName);
        }
        this.saveWaypoints();
    }

    public TreeSet<String> getKnownSubworldNames() {
        return this.knownSubworldNames;
    }

    public boolean receivedAutoSubworldName() {
        return this.gotAutoSubworldName;
    }

    public boolean isMultiworld() {
        return this.multiworld || VoxelConstants.getMinecraft().method_1589();
    }

    public synchronized void setSubworldName(String name, boolean fromServer) {
        boolean notNull;
        boolean bl = notNull = !name.isEmpty();
        if (notNull || System.currentTimeMillis() - this.lastNewWorldNameTime > 2000L) {
            if (notNull) {
                if (fromServer) {
                    this.gotAutoSubworldName = true;
                }
                if (!name.equals(this.currentSubWorldName)) {
                    VoxelConstants.getLogger().warn("New world name: " + TextUtils.scrubCodes(name));
                }
                this.lastNewWorldNameTime = System.currentTimeMillis();
            }
            this.currentSubWorldName = name;
            this.setSubWorldDescriptor(this.currentSubWorldName);
        }
    }

    public synchronized void setSubworldHash(String hash) {
        if (this.currentSubWorldName.isEmpty()) {
            this.setSubWorldDescriptor(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSubWorldDescriptor(String descriptor) {
        boolean serverSaysOldNorth = false;
        if (descriptor.endsWith("\u00a7o\u00a7n")) {
            descriptor = descriptor.substring(0, descriptor.length() - 4);
            serverSaysOldNorth = true;
        }
        this.currentSubworldDescriptor = descriptor;
        this.currentSubworldDescriptorNoCodes = TextUtils.scrubCodes(this.currentSubworldDescriptor);
        this.newSubworldName(this.currentSubworldDescriptorNoCodes);
        String currentSubWorldDescriptorScrubbed = TextUtils.scrubName(this.currentSubworldDescriptorNoCodes);
        Object object = this.waypointLock;
        synchronized (object) {
            for (Waypoint pt : this.wayPts) {
                pt.inWorld = currentSubWorldDescriptorScrubbed.isEmpty() || Objects.equals(pt.world, "") || currentSubWorldDescriptorScrubbed.equals(pt.world);
            }
        }
        if (serverSaysOldNorth) {
            if (this.currentSubworldDescriptorNoCodes.isEmpty()) {
                this.oldNorthWorldNames.add("all");
            } else {
                this.oldNorthWorldNames.add(this.currentSubworldDescriptorNoCodes);
            }
        }
        this.master.getMapOptions().oldNorth = this.oldNorthWorldNames.contains(this.currentSubworldDescriptorNoCodes);
    }

    private void newSubworldName(String name) {
        if (name != null && !name.isEmpty()) {
            this.multiworld = true;
            if (this.knownSubworldNames.add(name)) {
                if (this.loaded) {
                    this.saveWaypoints();
                } else {
                    this.needSave = true;
                }
            }
            this.loadBackgroundMapImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSubworldName(String oldName, String newName) {
        if (!newName.equals(oldName) && this.knownSubworldNames.remove(oldName)) {
            File newCachedRegionFileDir;
            boolean success;
            this.knownSubworldNames.add(newName);
            Object object = this.waypointLock;
            synchronized (object) {
                for (Waypoint pt : this.wayPts) {
                    if (!pt.world.equals(oldName)) continue;
                    pt.world = newName;
                }
            }
            this.master.getPersistentMap().renameSubworld(oldName, newName);
            String worldName = this.getCurrentWorldName();
            String worldNamePathPart = TextUtils.scrubNameFile(worldName);
            String subWorldNamePathPart = TextUtils.scrubNameFile(oldName) + "/";
            File oldCachedRegionFileDir = new File(VoxelConstants.getMinecraft().field_1697, "/mods/mamiyaotaru/voxelmap/cache/" + worldNamePathPart + "/" + subWorldNamePathPart);
            if (oldCachedRegionFileDir.exists() && oldCachedRegionFileDir.isDirectory() && !(success = oldCachedRegionFileDir.renameTo(newCachedRegionFileDir = new File(VoxelConstants.getMinecraft().field_1697, "/mods/mamiyaotaru/voxelmap/cache/" + worldNamePathPart + "/" + (subWorldNamePathPart = TextUtils.scrubNameFile(newName) + "/"))))) {
                VoxelConstants.getLogger().warn("Failed renaming " + oldCachedRegionFileDir.getPath() + " to " + newCachedRegionFileDir.getPath());
            }
            if (oldName.equals(this.getCurrentSubworldDescriptor(false))) {
                this.setSubworldName(newName, false);
            }
            this.saveWaypoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSubworld(String name) {
        if (this.knownSubworldNames.remove(name)) {
            Object object = this.waypointLock;
            synchronized (object) {
                for (Waypoint pt : this.wayPts) {
                    if (!pt.world.equals(name)) continue;
                    pt.world = "";
                    pt.inWorld = true;
                }
            }
            this.saveWaypoints();
            this.lastNewWorldNameTime = 0L;
            this.setSubworldName("", false);
        }
        if (this.knownSubworldNames.isEmpty()) {
            this.multiworld = false;
        }
    }

    public String getCurrentSubworldDescriptor(boolean withCodes) {
        return withCodes ? this.currentSubworldDescriptor : this.currentSubworldDescriptorNoCodes;
    }

    public String getWorldSeed() {
        String seed;
        String key = "all";
        if (!this.knownSubworldNames.isEmpty()) {
            key = this.getCurrentSubworldDescriptor(false);
        }
        if ((seed = this.worldSeeds.get(key)) == null) {
            seed = "";
        }
        return seed;
    }

    public void setWorldSeed(String newSeed) {
        String worldName = "all";
        if (!this.knownSubworldNames.isEmpty()) {
            worldName = this.getCurrentSubworldDescriptor(false);
        }
        this.worldSeeds.put(worldName, newSeed);
        this.saveWaypoints();
    }

    public void saveWaypoints() {
        int portSepLoc;
        String worldNameSave = this.getCurrentWorldName();
        if (worldNameSave.endsWith(":25565") && (portSepLoc = worldNameSave.lastIndexOf(58)) != -1) {
            worldNameSave = worldNameSave.substring(0, portSepLoc);
        }
        worldNameSave = TextUtils.scrubNameFile(worldNameSave);
        File saveDir = new File(VoxelConstants.getMinecraft().field_1697, "/voxelmap/");
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        this.settingsFile = new File(saveDir, worldNameSave + ".points");
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.settingsFile), StandardCharsets.UTF_8));
            String knownSubworldsString = this.knownSubworldNames.stream().map(subworldName -> TextUtils.scrubName(subworldName) + ",").collect(Collectors.joining());
            out.println("subworlds:" + knownSubworldsString);
            String oldNorthWorldsString = this.oldNorthWorldNames.stream().map(oldNorthWorldName -> TextUtils.scrubName(oldNorthWorldName) + ",").collect(Collectors.joining());
            out.println("oldNorthWorlds:" + oldNorthWorldsString);
            String seedsString = this.worldSeeds.entrySet().stream().map(entry -> TextUtils.scrubName((String)entry.getKey()) + "#" + (String)entry.getValue() + ",").collect(Collectors.joining());
            out.println("seeds:" + seedsString);
            for (Waypoint pt : this.wayPts) {
                if (!pt.name.isEmpty() && pt.name.charAt(0) == '^') continue;
                StringBuilder dimensionsString = new StringBuilder();
                for (DimensionContainer dimension : pt.dimensions) {
                    dimensionsString.append(dimension.getStorageName()).append("#");
                }
                if (dimensionsString.toString().isEmpty()) {
                    dimensionsString.append(VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByResourceLocation(class_7134.field_37666.method_29177()).getStorageName());
                }
                out.println("name:" + TextUtils.scrubName(pt.name) + ",x:" + pt.x + ",z:" + pt.z + ",y:" + pt.y + ",enabled:" + pt.enabled + ",red:" + pt.red + ",green:" + pt.green + ",blue:" + pt.blue + ",suffix:" + pt.imageSuffix + ",world:" + TextUtils.scrubName(pt.world) + ",dimensions:" + dimensionsString);
            }
            out.close();
        }
        catch (FileNotFoundException var12) {
            MessageUtils.chatInfo("\u00a7EError Saving Waypoints");
            VoxelConstants.getLogger().error((Object)var12);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWaypoints() {
        this.loaded = false;
        this.multiworld = false;
        this.gotAutoSubworldName = false;
        this.currentDimension = null;
        this.setSubWorldDescriptor("");
        this.knownSubworldNames.clear();
        this.oldNorthWorldNames.clear();
        this.worldSeeds.clear();
        Object object = this.waypointLock;
        synchronized (object) {
            boolean loaded;
            int portSepLoc;
            this.wayPts = new ArrayList();
            String worldNameStandard = this.getCurrentWorldName();
            if (worldNameStandard.endsWith(":25565") && (portSepLoc = worldNameStandard.lastIndexOf(58)) != -1) {
                worldNameStandard = worldNameStandard.substring(0, portSepLoc);
            }
            if (!(loaded = this.loadWaypointsExtensible(worldNameStandard = TextUtils.scrubNameFile(worldNameStandard)))) {
                MessageUtils.chatInfo("\u00a7ENo waypoints exist for this world/server.");
            }
        }
        this.loaded = true;
        if (this.needSave) {
            this.needSave = false;
            this.saveWaypoints();
        }
        this.multiworld = this.multiworld || !this.knownSubworldNames.isEmpty();
    }

    private boolean loadWaypointsExtensible(String worldNameStandard) {
        File settingsFileNew = new File(VoxelConstants.getMinecraft().field_1697, "/voxelmap/" + worldNameStandard + ".points");
        File settingsFileOld = new File(VoxelConstants.getMinecraft().field_1697, "/mods/mamiyaotaru/voxelmap/" + worldNameStandard + ".points");
        if (!settingsFileOld.exists() && !settingsFileNew.exists()) {
            return false;
        }
        this.settingsFile = !settingsFileOld.exists() ? settingsFileNew : (!settingsFileNew.exists() ? settingsFileOld : settingsFileNew);
        if (this.settingsFile.exists()) {
            try {
                String[] worldSeedPairs;
                String[] oldNorthWorlds;
                String[] subWorlds;
                Properties properties = new Properties();
                FileReader fr = new FileReader(this.settingsFile);
                properties.load(fr);
                String subWorldsS = properties.getProperty("subworlds", "");
                for (String subWorld : subWorlds = subWorldsS.split(",")) {
                    if (subWorld.isEmpty()) continue;
                    this.knownSubworldNames.add(TextUtils.descrubName(subWorld));
                }
                String oldNorthWorldsS = properties.getProperty("oldNorthWorlds", "");
                for (String oldNorthWorld : oldNorthWorlds = oldNorthWorldsS.split(",")) {
                    if (oldNorthWorld.isEmpty()) continue;
                    this.oldNorthWorldNames.add(TextUtils.descrubName(oldNorthWorld));
                }
                String worldSeedsS = properties.getProperty("seeds", "");
                for (String pair : worldSeedPairs = worldSeedsS.split(",")) {
                    String[] worldSeedPair = pair.split("#");
                    if (worldSeedPair.length != 2) continue;
                    this.worldSeeds.put(worldSeedPair[0], worldSeedPair[1]);
                }
                fr.close();
            }
            catch (IOException exception) {
                VoxelConstants.getLogger().error((Object)exception);
            }
            try {
                String sCurrentLine;
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.settingsFile), StandardCharsets.UTF_8));
                while ((sCurrentLine = in.readLine()) != null) {
                    try {
                        String[] pairs = sCurrentLine.split(",");
                        if (pairs.length <= 1) continue;
                        String name = "";
                        int x = 0;
                        int z = 0;
                        int y = -1;
                        boolean enabled = false;
                        float red = 0.5f;
                        float green = 0.0f;
                        float blue = 0.0f;
                        String suffix = "";
                        String world = "";
                        TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
                        block36: for (String pair : pairs) {
                            int splitIndex = pair.indexOf(58);
                            if (splitIndex == -1) continue;
                            String key = pair.substring(0, splitIndex).toLowerCase().trim();
                            String value = pair.substring(splitIndex + 1).trim();
                            switch (key) {
                                case "name": {
                                    name = TextUtils.descrubName(value);
                                    continue block36;
                                }
                                case "x": {
                                    x = Integer.parseInt(value);
                                    continue block36;
                                }
                                case "z": {
                                    z = Integer.parseInt(value);
                                    continue block36;
                                }
                                case "y": {
                                    y = Integer.parseInt(value);
                                    continue block36;
                                }
                                case "enabled": {
                                    enabled = Boolean.parseBoolean(value);
                                    continue block36;
                                }
                                case "red": {
                                    red = Float.parseFloat(value);
                                    continue block36;
                                }
                                case "green": {
                                    green = Float.parseFloat(value);
                                    continue block36;
                                }
                                case "blue": {
                                    blue = Float.parseFloat(value);
                                    continue block36;
                                }
                                case "suffix": {
                                    suffix = value;
                                    continue block36;
                                }
                                case "world": {
                                    world = TextUtils.descrubName(value);
                                    continue block36;
                                }
                                case "dimensions": {
                                    String[] dimensionStrings;
                                    for (String dimensionString : dimensionStrings = value.split("#")) {
                                        dimensions.add(VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByIdentifier(dimensionString));
                                    }
                                    if (dimensions.size() != 0) continue block36;
                                    dimensions.add(VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByResourceLocation(class_7134.field_37666.method_29177()));
                                }
                            }
                        }
                        if (name.isEmpty()) continue;
                        this.loadWaypoint(name, x, z, y, enabled, red, green, blue, suffix, world, dimensions);
                        if (world.isEmpty()) continue;
                        this.knownSubworldNames.add(TextUtils.descrubName(world));
                    }
                    catch (Exception exception) {
                        VoxelConstants.getLogger().error((Object)exception);
                    }
                }
                in.close();
                return true;
            }
            catch (IOException var25) {
                MessageUtils.chatInfo("\u00a7EError Loading Waypoints");
                VoxelConstants.getLogger().error("waypoint load error: " + var25.getLocalizedMessage(), (Throwable)var25);
                return false;
            }
        }
        return false;
    }

    private void loadWaypoint(String name, int x, int z, int y, boolean enabled, float red, float green, float blue, String suffix, String world, TreeSet<DimensionContainer> dimensions) {
        Waypoint newWaypoint = new Waypoint(name, x, z, y, enabled, red, green, blue, suffix, world, dimensions);
        if (!this.wayPts.contains(newWaypoint)) {
            this.wayPts.add(newWaypoint);
        }
    }

    public void deleteWaypoint(Waypoint point) {
        this.waypointContainer.removeWaypoint(point);
        this.wayPts.remove(point);
        this.saveWaypoints();
        if (point == this.highlightedWaypoint) {
            this.setHighlightedWaypoint(null, false);
        }
    }

    public void addWaypoint(Waypoint newWaypoint) {
        this.wayPts.add(newWaypoint);
        this.waypointContainer.addWaypoint(newWaypoint);
        this.saveWaypoints();
        if (this.highlightedWaypoint != null && this.highlightedWaypoint.getX() == newWaypoint.getX() && this.highlightedWaypoint.getZ() == newWaypoint.getZ()) {
            this.setHighlightedWaypoint(newWaypoint, false);
        }
    }

    public void setHighlightedWaypoint(Waypoint waypoint, boolean toggle) {
        if (toggle && waypoint == this.highlightedWaypoint) {
            this.highlightedWaypoint = null;
        } else {
            if (waypoint != null && !this.wayPts.contains(waypoint)) {
                waypoint.red = 2.0f;
                waypoint.blue = 0.0f;
                waypoint.green = 0.0f;
            }
            this.highlightedWaypoint = waypoint;
        }
        this.waypointContainer.setHighlightedWaypoint(this.highlightedWaypoint);
    }

    public Waypoint getHighlightedWaypoint() {
        return this.highlightedWaypoint;
    }

    public void renderWaypoints(float partialTicks, class_4587 matrixStack, boolean beacons, boolean signs, boolean withDepth, boolean withoutDepth) {
        if (this.waypointContainer != null) {
            this.waypointContainer.renderWaypoints(partialTicks, matrixStack, beacons, signs, withDepth, withoutDepth);
        }
    }

    private void loadBackgroundMapImage() {
        if (this.backgroundImageInfo != null) {
            GLUtils.glah(this.backgroundImageInfo.glid);
            this.backgroundImageInfo = null;
        }
        try {
            Object path = this.getCurrentWorldName();
            String subworldDescriptor = this.getCurrentSubworldDescriptor(false);
            if (subworldDescriptor != null && !subworldDescriptor.equals("")) {
                path = (String)path + "/" + subworldDescriptor;
            }
            path = (String)path + "/" + this.currentDimension.getStorageName();
            String tempPath = "images/backgroundmaps/" + (String)path + "/map.png";
            class_2960 identifier = new class_2960("voxelmap", tempPath);
            InputStream is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(identifier).get()).method_14482();
            BufferedImage image = ImageIO.read(is);
            is.close();
            BufferedImage mapImage = new BufferedImage(((Image)image).getWidth(null), ((Image)image).getHeight(null), 2);
            Graphics2D gfx = mapImage.createGraphics();
            gfx.drawImage((Image)image, 0, 0, null);
            gfx.dispose();
            is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(new class_2960("voxelmap", "images/backgroundmaps/" + (String)path + "/map.txt")).get()).method_14482();
            InputStreamReader isr = new InputStreamReader(is);
            Properties mapProperties = new Properties();
            mapProperties.load(isr);
            String left = mapProperties.getProperty("left");
            String right = mapProperties.getProperty("right");
            String top = mapProperties.getProperty("top");
            String bottom = mapProperties.getProperty("bottom");
            String width = mapProperties.getProperty("width");
            String height = mapProperties.getProperty("height");
            String scale = mapProperties.getProperty("scale");
            if (left != null && top != null && width != null && height != null) {
                this.backgroundImageInfo = new BackgroundImageInfo(mapImage, Integer.parseInt(left), Integer.parseInt(top), Integer.parseInt(width), Integer.parseInt(height));
            } else if (left != null && top != null && scale != null) {
                this.backgroundImageInfo = new BackgroundImageInfo(mapImage, Integer.parseInt(left), Integer.parseInt(top), Float.parseFloat(scale));
            } else if (left != null && top != null && right != null && bottom != null) {
                int widthInt = Integer.parseInt(right) - Integer.parseInt(left);
                this.backgroundImageInfo = new BackgroundImageInfo(mapImage, Integer.parseInt(left), Integer.parseInt(top), widthInt, widthInt);
            }
            isr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BackgroundImageInfo getBackgroundImageInfo() {
        return this.backgroundImageInfo;
    }
}

