/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiButtonText;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiOptionButtonMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class GuiMinimapPerformance
extends GuiScreenMinimap {
    private static final EnumOptionsMinimap[] relevantOptions = new EnumOptionsMinimap[]{EnumOptionsMinimap.LIGHTING, EnumOptionsMinimap.TERRAIN, EnumOptionsMinimap.WATERTRANSPARENCY, EnumOptionsMinimap.BLOCKTRANSPARENCY, EnumOptionsMinimap.BIOMES, EnumOptionsMinimap.FILTERING, EnumOptionsMinimap.CHUNKGRID, EnumOptionsMinimap.BIOMEOVERLAY, EnumOptionsMinimap.SLIMECHUNKS};
    private GuiButtonText worldSeedButton;
    private GuiOptionButtonMinimap slimeChunksButton;
    private final class_437 parentScreen;
    protected String screenTitle = "Details / Performance";
    private final MapSettingsManager options;
    final VoxelMap master;

    public GuiMinimapPerformance(class_437 par1GuiScreen, VoxelMap master) {
        this.parentScreen = par1GuiScreen;
        this.options = master.getMapOptions();
        this.master = master;
    }

    private int getLeftBorder() {
        return this.getWidth() / 2 - 155;
    }

    public void method_25426() {
        this.screenTitle = I18nUtils.getString("options.minimap.detailsperformance", new Object[0]);
        int leftBorder = this.getLeftBorder();
        int var2 = 0;
        for (EnumOptionsMinimap option : relevantOptions) {
            Object text = this.options.getKeyText(option);
            if ((option == EnumOptionsMinimap.WATERTRANSPARENCY || option == EnumOptionsMinimap.BLOCKTRANSPARENCY || option == EnumOptionsMinimap.BIOMES) && !this.options.multicore && this.options.getOptionBooleanValue(option)) {
                text = "\u00a7c" + (String)text;
            }
            GuiOptionButtonMinimap optionButton = new GuiOptionButtonMinimap(leftBorder + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, (class_2561)class_2561.method_43470((String)text), this::optionClicked);
            this.method_37063((class_364)optionButton);
            ++var2;
            if (optionButton.returnEnumOptions() != EnumOptionsMinimap.SLIMECHUNKS) continue;
            this.slimeChunksButton = optionButton;
            this.slimeChunksButton.field_22763 = VoxelConstants.getMinecraft().method_1496() || !this.master.getWorldSeed().equals("");
        }
        String worldSeedDisplay = this.master.getWorldSeed();
        if (worldSeedDisplay.equals("")) {
            worldSeedDisplay = I18nUtils.getString("selectWorld.versionUnknown", new Object[0]);
        }
        String buttonText = I18nUtils.getString("options.minimap.worldseed", new Object[0]) + ": " + worldSeedDisplay;
        this.worldSeedButton = new GuiButtonText(this.getFontRenderer(), leftBorder + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), 150, 20, (class_2561)class_2561.method_43470((String)buttonText), button -> this.worldSeedButton.setEditing(true));
        this.worldSeedButton.setText(this.master.getWorldSeed());
        this.worldSeedButton.field_22763 = !VoxelConstants.getMinecraft().method_1496();
        this.method_37063((class_364)this.worldSeedButton);
        ++var2;
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.done"), button -> VoxelConstants.getMinecraft().method_1507(this.parentScreen)).method_46434(this.getWidth() / 2 - 100, this.getHeight() / 6 + 168, 200, 20).method_46431());
    }

    @Override
    public void method_25432() {
    }

    protected void optionClicked(class_4185 par1GuiButton) {
        EnumOptionsMinimap option = ((GuiOptionButtonMinimap)par1GuiButton).returnEnumOptions();
        this.options.setOptionValue(option);
        String perfBomb = "";
        if ((option == EnumOptionsMinimap.WATERTRANSPARENCY || option == EnumOptionsMinimap.BLOCKTRANSPARENCY || option == EnumOptionsMinimap.BIOMES) && !this.options.multicore && this.options.getOptionBooleanValue(option)) {
            perfBomb = "\u00a7c";
        }
        par1GuiButton.method_25355((class_2561)class_2561.method_43470((String)(perfBomb + this.options.getKeyText(option))));
    }

    public boolean method_25404(int keysm, int scancode, int b) {
        if (keysm == 258) {
            this.worldSeedButton.method_25404(keysm, scancode, b);
        }
        if ((keysm == 257 || keysm == 335) && this.worldSeedButton.isEditing()) {
            this.newSeed();
        }
        return super.method_25404(keysm, scancode, b);
    }

    public boolean method_25400(char character, int keycode) {
        boolean OK = super.method_25400(character, keycode);
        if (character == '\r' && this.worldSeedButton.isEditing()) {
            this.newSeed();
        }
        return OK;
    }

    private void newSeed() {
        String newSeed = this.worldSeedButton.getText();
        this.master.setWorldSeed(newSeed);
        String worldSeedDisplay = this.master.getWorldSeed();
        if (worldSeedDisplay.equals("")) {
            worldSeedDisplay = I18nUtils.getString("selectWorld.versionUnknown", new Object[0]);
        }
        String buttonText = I18nUtils.getString("options.minimap.worldseed", new Object[0]) + ": " + worldSeedDisplay;
        this.worldSeedButton.method_25355((class_2561)class_2561.method_43470((String)buttonText));
        this.worldSeedButton.setText(this.master.getWorldSeed());
        this.master.getMap().forceFullRender(true);
        this.slimeChunksButton.field_22763 = VoxelConstants.getMinecraft().method_1496() || !this.master.getWorldSeed().equals("");
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.drawMap(matrixStack);
        this.method_25420(matrixStack);
        GuiMinimapPerformance.method_25300((class_4587)matrixStack, (class_327)this.getFontRenderer(), (String)this.screenTitle, (int)(this.getWidth() / 2), (int)20, (int)0xFFFFFF);
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void method_25393() {
        this.worldSeedButton.tick();
    }
}

