/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.persistent.ComparisonCachedRegion;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.MessageUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_1937;
import net.minecraft.class_638;

public class WorldMatcher {
    private final VoxelMap master;
    private final IPersistentMap map;
    private final class_638 world;
    private boolean cancelled = false;

    public WorldMatcher(VoxelMap master, IPersistentMap map, class_638 world) {
        this.master = master;
        this.map = map;
        this.world = world;
    }

    public void findMatch() {
        Runnable runnable = new Runnable(){
            int x;
            int z;
            final ArrayList<ComparisonCachedRegion> candidateRegions = new ArrayList();
            ComparisonCachedRegion region;
            final String worldName;
            final String worldNamePathPart;
            final String dimensionName;
            final String dimensionNamePathPart;
            final File cachedRegionFileDir;
            {
                this.worldName = WorldMatcher.this.master.getWaypointManager().getCurrentWorldName();
                this.worldNamePathPart = TextUtils.scrubNameFile(this.worldName);
                this.dimensionName = WorldMatcher.this.master.getDimensionManager().getDimensionContainerByWorld((class_1937)WorldMatcher.this.world).getStorageName();
                this.dimensionNamePathPart = TextUtils.scrubNameFile(this.dimensionName);
                this.cachedRegionFileDir = new File(VoxelConstants.getMinecraft().field_1697, "/voxelmap/cache/" + this.worldNamePathPart + "/");
            }

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException var8) {
                    VoxelConstants.getLogger().error((Object)var8);
                }
                this.cachedRegionFileDir.mkdirs();
                ArrayList<String> knownSubworldNames = new ArrayList<String>(WorldMatcher.this.master.getWaypointManager().getKnownSubworldNames());
                String[] subworldNamesArray = new String[knownSubworldNames.size()];
                knownSubworldNames.toArray(subworldNamesArray);
                MessageUtils.printDebug("player coords " + VoxelConstants.getPlayer().method_23317() + " " + VoxelConstants.getPlayer().method_23321() + " in world " + WorldMatcher.this.master.getWaypointManager().getCurrentWorldName());
                this.x = (int)Math.floor(VoxelConstants.getPlayer().method_23317() / 256.0);
                this.z = (int)Math.floor(VoxelConstants.getPlayer().method_23321() / 256.0);
                this.loadRegions(subworldNamesArray);
                int attempts = 0;
                while (!(WorldMatcher.this.cancelled || this.candidateRegions.size() != 0 && this.region.getLoadedChunks() >= 5 || attempts >= 5)) {
                    ++attempts;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException var7) {
                        VoxelConstants.getLogger().error((Object)var7);
                    }
                    if (this.x == (int)Math.floor(VoxelConstants.getPlayer().method_23317() / 256.0) && this.z == (int)Math.floor(VoxelConstants.getPlayer().method_23321() / 256.0)) {
                        if (this.candidateRegions.size() > 0) {
                            MessageUtils.printDebug("going to load current region");
                            this.region.loadCurrent();
                            MessageUtils.printDebug("loaded chunks in local region: " + this.region.getLoadedChunks());
                        }
                    } else {
                        this.x = (int)Math.floor(VoxelConstants.getPlayer().method_23317() / 256.0);
                        this.z = (int)Math.floor(VoxelConstants.getPlayer().method_23321() / 256.0);
                        MessageUtils.printDebug("player coords changed to " + VoxelConstants.getPlayer().method_23317() + " " + VoxelConstants.getPlayer().method_23321() + " in world " + WorldMatcher.this.master.getWaypointManager().getCurrentWorldName());
                        this.loadRegions(subworldNamesArray);
                    }
                    if (attempts < 5) continue;
                    if (this.candidateRegions.size() == 0) {
                        MessageUtils.printDebug("no candidate regions at current coordinates, bailing");
                        continue;
                    }
                    MessageUtils.printDebug("took too long to load local region, bailing");
                }
                Iterator<ComparisonCachedRegion> iterator = this.candidateRegions.iterator();
                while (!WorldMatcher.this.cancelled && iterator.hasNext()) {
                    ComparisonCachedRegion candidateRegion = iterator.next();
                    MessageUtils.printDebug("testing region " + candidateRegion.getSubworldName() + ": " + candidateRegion.getKey());
                    if (this.region.getSimilarityTo(candidateRegion) < 95) {
                        MessageUtils.printDebug("region failed");
                        iterator.remove();
                        continue;
                    }
                    MessageUtils.printDebug("region succeeded");
                }
                MessageUtils.printDebug("remaining regions: " + this.candidateRegions.size());
                if (!WorldMatcher.this.cancelled && this.candidateRegions.size() == 1 && !WorldMatcher.this.master.getWaypointManager().receivedAutoSubworldName()) {
                    WorldMatcher.this.master.newSubWorldName(this.candidateRegions.get(0).getSubworldName(), false);
                    MessageUtils.chatInfo(I18nUtils.getString("worldmap.multiworld.foundworld1", new Object[0]) + ": \u00a7a" + this.candidateRegions.get(0).getSubworldName() + ".\u00a7r " + I18nUtils.getString("worldmap.multiworld.foundworld2", new Object[0]));
                } else if (!WorldMatcher.this.cancelled && !WorldMatcher.this.master.getWaypointManager().receivedAutoSubworldName()) {
                    MessageUtils.printDebug("remaining regions: " + this.candidateRegions.size());
                    MessageUtils.chatInfo("\u00a74VoxelMap\u00a7r: " + I18nUtils.getString("worldmap.multiworld.unknownsubworld", new Object[0]));
                }
            }

            private void loadRegions(String[] subworldNamesArray) {
                for (String subworldName : subworldNamesArray) {
                    if (WorldMatcher.this.cancelled) continue;
                    File subworldDir = new File(this.cachedRegionFileDir, subworldName + "/" + this.dimensionNamePathPart);
                    if (subworldDir.isDirectory()) {
                        ComparisonCachedRegion candidateRegion = new ComparisonCachedRegion(WorldMatcher.this.map, this.x + "," + this.z, WorldMatcher.this.world, this.worldName, subworldName, this.x, this.z);
                        candidateRegion.loadStored();
                        this.candidateRegions.add(candidateRegion);
                        MessageUtils.printDebug("added candidate region " + candidateRegion.getSubworldName() + ": " + candidateRegion.getKey());
                        continue;
                    }
                    MessageUtils.printDebug(subworldName + " not found as a candidate region");
                }
                this.region = new ComparisonCachedRegion(WorldMatcher.this.map, this.x + "," + this.z, VoxelConstants.getMinecraft().field_1687, this.worldName, "", this.x, this.z);
                MessageUtils.printDebug("going to load current region");
                this.region.loadCurrent();
                MessageUtils.printDebug("loaded chunks in local region: " + this.region.getLoadedChunks());
            }
        };
        ThreadManager.executorService.execute(runnable);
    }

    public void cancel() {
        this.cancelled = true;
    }
}

