/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_7924;

public class BiomeRepository {
    public static class_1959 DEFAULT;
    public static class_1959 FOREST;
    public static class_1959 SWAMP;
    public static class_1959 SWAMP_HILLS;
    private static final Random generator;
    private static final HashMap<Integer, Integer> IDtoColor;
    private static final TreeMap<String, Integer> nameToColor;
    private static boolean dirty;

    public static void getBiomes() {
        DEFAULT = (class_1959)VoxelConstants.getMinecraft().field_1687.method_30349().method_30530(class_7924.field_41236).method_29107(class_1972.field_9423);
        FOREST = (class_1959)VoxelConstants.getMinecraft().field_1687.method_30349().method_30530(class_7924.field_41236).method_29107(class_1972.field_9409);
        SWAMP = (class_1959)VoxelConstants.getMinecraft().field_1687.method_30349().method_30530(class_7924.field_41236).method_29107(class_1972.field_9471);
        SWAMP_HILLS = (class_1959)VoxelConstants.getMinecraft().field_1687.method_30349().method_30530(class_7924.field_41236).method_29107(class_1972.field_9471);
    }

    public static void loadBiomeColors() {
        File saveDir = new File(VoxelConstants.getMinecraft().field_1697, "/voxelmap/");
        File settingsFile = new File(saveDir, "biomecolors.txt");
        if (settingsFile.exists()) {
            try {
                String sCurrentLine;
                BufferedReader br = new BufferedReader(new FileReader(settingsFile));
                while ((sCurrentLine = br.readLine()) != null) {
                    String[] curLine = sCurrentLine.split("=");
                    if (curLine.length != 2) continue;
                    String name = curLine[0];
                    int color = 0;
                    try {
                        color = Integer.decode(curLine[1]);
                    }
                    catch (NumberFormatException var10) {
                        VoxelConstants.getLogger().warn("Error decoding integer string for biome colors; " + curLine[1]);
                    }
                    if (nameToColor.put(name, color) == null) continue;
                    dirty = true;
                }
                br.close();
            }
            catch (Exception var12) {
                VoxelConstants.getLogger().error("biome load error: " + var12.getLocalizedMessage(), (Throwable)var12);
            }
        }
        try {
            String sCurrentLine;
            InputStream is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(new class_2960("voxelmap", "conf/biomecolors.txt")).get()).method_14482();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((sCurrentLine = br.readLine()) != null) {
                int color;
                String[] curLine = sCurrentLine.split("=");
                if (curLine.length != 2) continue;
                String name = curLine[0];
                try {
                    color = Integer.decode(curLine[1]);
                }
                catch (NumberFormatException var9) {
                    VoxelConstants.getLogger().warn("Error decoding integer string for biome colors; " + curLine[1]);
                    color = 0;
                }
                if (nameToColor.get(name) != null) continue;
                nameToColor.put(name, color);
                dirty = true;
            }
            br.close();
            is.close();
        }
        catch (IOException var11) {
            VoxelConstants.getLogger().error("Error loading biome color config file from litemod!", (Throwable)var11);
        }
    }

    public static void saveBiomeColors() {
        if (dirty) {
            File saveDir = new File(VoxelConstants.getMinecraft().field_1697, "/voxelmap/");
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File settingsFile = new File(saveDir, "biomecolors.txt");
            try {
                PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
                for (Map.Entry<String, Integer> entry : nameToColor.entrySet()) {
                    String name = entry.getKey();
                    Integer color = entry.getValue();
                    StringBuilder hexColor = new StringBuilder(Integer.toHexString(color));
                    while (hexColor.length() < 6) {
                        hexColor.insert(0, "0");
                    }
                    hexColor.insert(0, "0x");
                    out.println(name + "=" + hexColor);
                }
                out.close();
            }
            catch (Exception var8) {
                VoxelConstants.getLogger().error("biome save error: " + var8.getLocalizedMessage(), (Throwable)var8);
            }
        }
        dirty = false;
    }

    public static int getBiomeColor(int biomeID) {
        Integer color = IDtoColor.get(biomeID);
        if (color == null) {
            class_1959 biome = (class_1959)VoxelConstants.getMinecraft().field_1687.method_30349().method_30530(class_7924.field_41236).method_10200(biomeID);
            if (biome != null) {
                String friendlyName;
                String identifier = VoxelConstants.getMinecraft().field_1687.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome).toString();
                color = nameToColor.get(identifier);
                if (color == null && (color = nameToColor.get(friendlyName = BiomeRepository.getName(biome))) != null) {
                    nameToColor.remove(friendlyName);
                    nameToColor.put(identifier, color);
                    dirty = true;
                }
                if (color == null) {
                    int r = generator.nextInt(255);
                    int g = generator.nextInt(255);
                    int b = generator.nextInt(255);
                    color = r << 16 | g << 8 | b;
                    nameToColor.put(identifier, color);
                    dirty = true;
                }
            } else {
                VoxelConstants.getLogger().warn("non biome");
                color = 0;
            }
            IDtoColor.put(biomeID, color);
        }
        return color;
    }

    private static String getName(class_1959 biome) {
        class_2960 resourceLocation = VoxelConstants.getMinecraft().field_1687.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        String translationKey = class_156.method_646((String)"biome", (class_2960)resourceLocation);
        String name = I18nUtils.getString(translationKey, new Object[0]);
        if (name.equals(translationKey)) {
            name = TextUtils.prettify(resourceLocation.method_12832());
        }
        return name;
    }

    public static String getName(int biomeID) {
        String name = null;
        class_1959 biome = (class_1959)VoxelConstants.getMinecraft().field_1687.method_30349().method_30530(class_7924.field_41236).method_10200(biomeID);
        if (biome != null) {
            name = BiomeRepository.getName(biome);
        }
        if (name == null) {
            name = "Unknown";
        }
        return name;
    }

    static {
        generator = new Random();
        IDtoColor = new HashMap(256);
        nameToColor = new TreeMap();
        dirty = false;
    }
}

