/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class GLShim {
    public static void glEnable(int attrib) {
        switch (attrib) {
            case 2884: {
                RenderSystem.enableCull();
                break;
            }
            case 2929: {
                RenderSystem.enableDepthTest();
                break;
            }
            case 3042: {
                RenderSystem.enableBlend();
                break;
            }
            case 3089: {
                GL11.glEnable((int)3089);
                break;
            }
            case 3553: {
                RenderSystem.enableTexture();
                break;
            }
            case 32823: {
                RenderSystem.enablePolygonOffset();
            }
        }
    }

    public static void glDisable(int attrib) {
        switch (attrib) {
            case 2884: {
                RenderSystem.disableCull();
                break;
            }
            case 2929: {
                RenderSystem.disableDepthTest();
                break;
            }
            case 3042: {
                RenderSystem.disableBlend();
                break;
            }
            case 3089: {
                GL11.glDisable((int)3089);
                break;
            }
            case 3553: {
                RenderSystem.disableTexture();
                break;
            }
            case 32823: {
                RenderSystem.disablePolygonOffset();
            }
        }
    }

    public static void glBlendFunc(int sfactor, int dfactor) {
        RenderSystem.blendFunc((int)sfactor, (int)dfactor);
    }

    public static void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha) {
        RenderSystem.blendFuncSeparate((int)sfactorRGB, (int)dfactorRGB, (int)sfactorAlpha, (int)dfactorAlpha);
    }

    public static void glClear(int mask) {
        RenderSystem.clear((int)mask, (boolean)VoxelConstants.isSystemMacOS());
    }

    public static void glClearColor(float red, float green, float blue, float alpha) {
        RenderSystem.clearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glClearDepth(double depth) {
        RenderSystem.clearDepth((double)depth);
    }

    public static void glColor3f(float red, float green, float blue) {
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static void glColor4f(float red, float green, float blue, float alpha) {
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glColor3ub(int red, int green, int blue) {
        RenderSystem.setShaderColor((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)1.0f);
    }

    public static void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        RenderSystem.colorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public static void glDeleteTextures(int id) {
        RenderSystem.deleteTexture((int)id);
    }

    public static void glDepthFunc(int func) {
        RenderSystem.depthFunc((int)func);
    }

    public static void glDepthMask(boolean flag) {
        RenderSystem.depthMask((boolean)flag);
    }

    public static int glGenTextures() {
        return GlStateManager._genTexture();
    }

    public static void glGetTexImage(int tex, int level, int format, int type, long pixels) {
        GlStateManager._getTexImage((int)tex, (int)level, (int)format, (int)type, (long)pixels);
    }

    public static int glGetTexLevelParameteri(int target, int level, int pname) {
        return GlStateManager._getTexLevelParameter((int)target, (int)level, (int)pname);
    }

    public static void glLogicOp(int opcode) {
        GlStateManager._logicOp((int)opcode);
    }

    public static void glPixelStorei(int parameterName, int parameter) {
        RenderSystem.pixelStore((int)parameterName, (int)parameter);
    }

    public static void glPolygonOffset(float factor, float units) {
        RenderSystem.polygonOffset((float)factor, (float)units);
    }

    public static void glSetActiveTextureUnit(int texture) {
        RenderSystem.activeTexture((int)texture);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        GlStateManager._texImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static void glTexParameterf(int target, int pname, float param) {
        GlStateManager._texParameter((int)target, (int)pname, (float)param);
    }

    public static void glTexParameteri(int target, int pname, int param) {
        RenderSystem.texParameter((int)target, (int)pname, (int)param);
    }

    public static void glTexSubImage2D(int target, int level, int xOffset, int yOffset, int width, int height, int format, int type, long memAddress) {
        GlStateManager._texSubImage2D((int)target, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)format, (int)type, (long)memAddress);
    }

    public static void glViewport(int x, int y, int width, int height) {
        RenderSystem.viewport((int)x, (int)y, (int)width, (int)height);
    }

    public static void glBindTexture(int target, int texture) {
        if (target == 3553) {
            RenderSystem.bindTexture((int)texture);
        } else {
            GL11.glBindTexture((int)target, (int)texture);
        }
    }

    public static void glGenerateMipmap(int glTexture2d) {
        GL30.glGenerateMipmap((int)glTexture2d);
    }

    public static boolean glGetBoolean(int pname) {
        return GL11.glGetBoolean((int)pname);
    }

    public static void glGetFloatv(int pname, FloatBuffer params) {
        GL11.glGetFloatv((int)pname, (FloatBuffer)params);
    }

    public static int glGetInteger(int pname) {
        return GL11.glGetInteger((int)pname);
    }

    public static void glGetTexImage(int tex, int level, int format, int type, ByteBuffer pixels) {
        GL11.glGetTexImage((int)tex, (int)level, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void glGetTexImage(int tex, int level, int format, int type, IntBuffer pixels) {
        GL11.glGetTexImage((int)tex, (int)level, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static void glPopAttrib() {
        GL11.glPopAttrib();
    }

    public static void glPushAttrib(int mask) {
        GL11.glPushAttrib((int)mask);
    }

    public static void glScissor(int x, int y, int width, int height) {
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public static void glTexImage2D(int glTexture2d, int level, int glRgba, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        GL11.glTexImage2D((int)glTexture2d, (int)level, (int)glRgba, (int)width, (int)height, (int)border, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static void glVertex2f(float x, float y) {
        GL11.glVertex2f((float)x, (float)y);
    }

    public static void glVertex3f(float x, float y, float z) {
        GL11.glVertex3f((float)x, (float)y, (float)z);
    }
}

